/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.box2d_version;

import gama.core.metamodel.shape.GamaPoint;
import gama.extension.physics.common.IPhysicalEntity;
import gama.extension.physics.common.VectorUtils;
import org.jbox2d.common.Vec2;

public interface IBox2DPhysicalEntity
extends IPhysicalEntity<Vec2> {
    public float getScale();

    @Override
    default public Vec2 toVector(GamaPoint gamaPoint) {
        return VectorUtils.toBox2DVector(gamaPoint, this.getScale());
    }

    default public Vec2 toVector(GamaPoint gamaPoint, Vec2 vec2) {
        return VectorUtils.toBox2DVector(gamaPoint, vec2, this.getScale());
    }

    @Override
    default public GamaPoint toGamaPoint(Vec2 vec2) {
        return VectorUtils.toGamaPoint(vec2, this.getScale());
    }

    default public GamaPoint toGamaPoint(Vec2 vec2, GamaPoint gamaPoint) {
        return VectorUtils.toGamaPoint(vec2, gamaPoint, this.getScale());
    }

    default public double toGama(float f) {
        return f / this.getScale();
    }

    default public float toBox2D(double d) {
        return (float)(d * (double)this.getScale());
    }
}

