/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.gaml;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.extension.physics.common.IBody;
import gama.extension.physics.gaml.StaticBodySkill;
import gama.gaml.operators.Cast;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="damping", type=2, init="0.1", doc={@GamlAnnotations.doc(value="Between 0 and 1. a linear decelaration coefficient that occurs even without contact ")}), @GamlAnnotations.variable(name="angular_damping", type=2, init="0.1", doc={@GamlAnnotations.doc(value="Between 0 and 1. an angular decelaration coefficient that occurs even without contact ")}), @GamlAnnotations.variable(name="contact_damping", type=2, init="0.1", doc={@GamlAnnotations.doc(value="Between 0 and 1. a decelaration coefficient that occurs in case of contact. Only available in the native Bullet library (no effect on the Java implementation)")}), @GamlAnnotations.variable(name="angular_velocity", type=7, init="{0,0,0}", doc={@GamlAnnotations.doc(value="The angular velocity of the agent in the three directions, expressed as a point.")}), @GamlAnnotations.variable(name="velocity", type=7, init="{0,0,0}", doc={@GamlAnnotations.doc(value="The linear velocity of the agent in the three directions, expressed as a point.")})})
@GamlAnnotations.skill(name="dynamic_body", concept={"skill", "3d"}, doc={@GamlAnnotations.doc(value="A skill allowing an agent to act like in a physical 3D world (if it is also registered in a model inheriting from 'physical_world'). Proposes a number of attributes (velocity...) and one action (apply), which allows to define its dynamic properties (forces, torques, ...)")})
public class DynamicBodySkill
extends StaticBodySkill {
    @GamlAnnotations.getter(value="velocity")
    public GamaPoint getVelocity(IAgent iAgent) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return new GamaPoint();
        }
        return iBody.getLinearVelocity(null);
    }

    @GamlAnnotations.setter(value="velocity")
    public void setVelocity(IAgent iAgent, GamaPoint gamaPoint) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return;
        }
        iBody.setLinearVelocity(gamaPoint);
    }

    @GamlAnnotations.getter(value="damping")
    public Double getDamping(IAgent iAgent) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return 0.0;
        }
        return iBody.getLinearDamping();
    }

    @GamlAnnotations.setter(value="damping")
    public void setDamping(IAgent iAgent, Double d) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return;
        }
        iBody.setDamping(d);
    }

    @GamlAnnotations.getter(value="contact_damping")
    public Double getContactDamping(IAgent iAgent) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return 0.0;
        }
        return iBody.getContactDamping();
    }

    @GamlAnnotations.setter(value="contact_damping")
    public void setContactDamping(IAgent iAgent, Double d) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return;
        }
        iBody.setContactDamping(d);
    }

    @GamlAnnotations.getter(value="angular_damping")
    public Double getAngularDamping(IAgent iAgent) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return 0.0;
        }
        return iBody.getAngularDamping();
    }

    @Override
    public Double getMass(IAgent iAgent) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return 0.0;
        }
        return iBody.getMass();
    }

    @Override
    public void setMass(IAgent iAgent, Double d) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return;
        }
        iBody.setMass(d);
    }

    @GamlAnnotations.setter(value="angular_damping")
    public void setAngularDamping(IAgent iAgent, Double d) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return;
        }
        iBody.setAngularDamping(d);
    }

    @GamlAnnotations.getter(value="angular_velocity")
    public GamaPoint getAngularVelocity(IAgent iAgent) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return new GamaPoint();
        }
        return iBody.getAngularVelocity(new GamaPoint());
    }

    @GamlAnnotations.setter(value="angular_velocity")
    public void setAngularVelocity(IAgent iAgent, GamaPoint gamaPoint) {
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return;
        }
        iBody.setAngularVelocity(gamaPoint);
    }

    @GamlAnnotations.action(doc={@GamlAnnotations.doc(value="An action that allows to apply different effects to the object, like forces, impulses, etc.")}, name="apply", args={@GamlAnnotations.arg(doc={@GamlAnnotations.doc(value="If true clears all forces applied to the agent and clears its veolicity as well")}, name="clearance", type=3), @GamlAnnotations.arg(doc={@GamlAnnotations.doc(value="An idealised change of momentum. Adds to the velocity of the object. This is the kind of push that you would use on a pool billiard ball.")}, name="impulse", type=7), @GamlAnnotations.arg(doc={@GamlAnnotations.doc(value="Move (push) the object once with a certain moment, expressed as a point (vector). Adds to the existing forces.")}, name="force", type=7), @GamlAnnotations.arg(doc={@GamlAnnotations.doc(value="Rotate (twist) the object once around its axes, expressed as a point (vector)")}, name="torque", type=7)})
    public Object primApply(IScope iScope) {
        GamaPoint gamaPoint;
        GamaPoint gamaPoint2;
        IAgent iAgent = this.getCurrentAgent(iScope);
        IBody iBody = this.getBody(iAgent);
        if (iBody == null) {
            return null;
        }
        if (iScope.hasArg("clearance")) {
            Boolean bl = iScope.getBoolArg("clearance");
            if (!bl.booleanValue()) {
                return this;
            }
            iBody.clearForces();
            iBody.setLinearVelocity(null);
            iBody.setAngularVelocity(null);
            return this;
        }
        GamaPoint gamaPoint3 = Cast.asPoint((IScope)iScope, (Object)iScope.getArg("impulse", 7));
        if (gamaPoint3 != null) {
            iBody.applyImpulse(gamaPoint3);
        }
        if ((gamaPoint2 = Cast.asPoint((IScope)iScope, (Object)iScope.getArg("force", 7))) != null) {
            iBody.applyForce(gamaPoint2);
        }
        if ((gamaPoint = Cast.asPoint((IScope)iScope, (Object)iScope.getArg("torque", 7))) != null) {
            iBody.applyTorque(gamaPoint);
        }
        return this;
    }
}

