/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.java_version;

import com.bulletphysics.BulletGlobals;
import com.bulletphysics.collision.broadphase.DbvtBroadphase;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.collision.narrowphase.ManifoldPoint;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.google.common.collect.Multimap;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.extension.physics.common.AbstractPhysicalWorld;
import gama.extension.physics.common.IBody;
import gama.extension.physics.common.IShapeConverter;
import gama.extension.physics.gaml.PhysicalSimulationAgent;
import gama.extension.physics.java_version.BulletBodyWrapper;
import gama.extension.physics.java_version.BulletShapeConverter;
import gama.extension.physics.java_version.IBulletPhysicalEntity;
import javax.vecmath.Vector3f;

public class BulletPhysicalWorld
extends AbstractPhysicalWorld<DiscreteDynamicsWorld, CollisionShape, Vector3f>
implements IBulletPhysicalEntity {
    private final CollisionConfiguration config = new DefaultCollisionConfiguration();
    private final CollisionDispatcher dispatcher = new CollisionDispatcher(this.config);

    public BulletPhysicalWorld(PhysicalSimulationAgent physicalSimulationAgent) {
        super(physicalSimulationAgent);
    }

    @Override
    protected IShapeConverter<CollisionShape, Vector3f> createShapeConverter() {
        return new BulletShapeConverter();
    }

    @Override
    public DiscreteDynamicsWorld createWorld() {
        DbvtBroadphase dbvtBroadphase = new DbvtBroadphase();
        SequentialImpulseConstraintSolver sequentialImpulseConstraintSolver = new SequentialImpulseConstraintSolver();
        this.world = new DiscreteDynamicsWorld(this.dispatcher, dbvtBroadphase, sequentialImpulseConstraintSolver, this.config);
        this.setGravity(this.simulation.getGravity(this.simulation.getScope()));
        this.setCCD(this.simulation.getCCD(this.simulation.getScope()));
        return (DiscreteDynamicsWorld)this.world;
    }

    @Override
    public void updateEngine(Double d, int n) {
        ((DiscreteDynamicsWorld)this.getWorld()).stepSimulation(d.floatValue(), n);
    }

    @Override
    public void registerAgent(IAgent iAgent) {
        BulletBodyWrapper bulletBodyWrapper = new BulletBodyWrapper(iAgent, this);
        ((DiscreteDynamicsWorld)this.getWorld()).addRigidBody((RigidBody)bulletBodyWrapper.getBody());
        bulletBodyWrapper.setCCD(this.simulation.getCCD(this.simulation.getScope()));
    }

    @Override
    public void unregisterAgent(IAgent iAgent) {
        BulletBodyWrapper bulletBodyWrapper = (BulletBodyWrapper)iAgent.getAttribute("%%rigid_body%%");
        ((DiscreteDynamicsWorld)this.getWorld()).removeRigidBody((RigidBody)bulletBodyWrapper.getBody());
    }

    @Override
    public void updateAgentsShape() {
        for (IAgent iAgent : this.updatableAgents) {
            this.unregisterAgent(iAgent);
        }
        for (IAgent iAgent : this.updatableAgents) {
            this.registerAgent(iAgent);
        }
        this.updatableAgents.clear();
    }

    @Override
    public void collectContacts(Multimap<IBody, IBody> multimap) {
        block0: for (PersistentManifold persistentManifold : this.dispatcher.getInternalManifoldPointer()) {
            if (persistentManifold == null) continue;
            IBody iBody = (IBody)((RigidBody)persistentManifold.getBody0()).getUserPointer();
            IBody iBody2 = (IBody)((RigidBody)persistentManifold.getBody1()).getUserPointer();
            if (iBody.isNoNotification() && iBody2.isNoNotification()) continue;
            int n = persistentManifold.getNumContacts();
            int n2 = 0;
            while (n2 < n) {
                ManifoldPoint manifoldPoint = persistentManifold.getContactPoint(n2);
                if ((double)manifoldPoint.getDistance() < 0.1) {
                    multimap.put((Object)iBody, (Object)iBody2);
                    continue block0;
                }
                ++n2;
            }
        }
    }

    @Override
    public void setCCD(boolean bl) {
        if (this.world != null) {
            ((DiscreteDynamicsWorld)this.world).getCollisionObjectArray().forEach(collisionObject -> {
                if (collisionObject.isStaticObject()) {
                    return;
                }
                Object object = collisionObject.getUserPointer();
                if (object instanceof IBody) {
                    ((IBody)object).setCCD(bl);
                }
            });
        }
    }

    @Override
    public void setGravity(GamaPoint gamaPoint) {
        if (this.world != null) {
            ((DiscreteDynamicsWorld)this.world).setGravity((Vector3f)this.toVector(gamaPoint));
        }
    }

    @Override
    public void dispose() {
        if (this.world != null) {
            ((DiscreteDynamicsWorld)this.world).destroy();
            this.world = null;
        }
        BulletGlobals.cleanCurrentThread();
    }

    @Override
    public void updatePositionsAndRotations() {
        ((DiscreteDynamicsWorld)this.world).getCollisionObjectArray().forEach(collisionObject -> {
            RigidBody rigidBody = (RigidBody)collisionObject;
            IBody iBody = (IBody)rigidBody.getUserPointer();
            if (rigidBody.isActive() && !rigidBody.isStaticObject()) {
                iBody.transferLocationAndRotationToAgent();
            }
        });
    }
}

