/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Distance;
import org.jbox2d.collision.DistanceInput;
import org.jbox2d.collision.DistanceOutput;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.IWorldPool;

public class Collision {
    public static final int NULL_FEATURE = Integer.MAX_VALUE;
    private final IWorldPool pool;
    private final DistanceInput input = new DistanceInput();
    private final Distance.SimplexCache cache = new Distance.SimplexCache();
    private final DistanceOutput output = new DistanceOutput();
    private static Vec2 d = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Transform xf = new Transform();
    private final Vec2 n = new Vec2();
    private final Vec2 v1 = new Vec2();
    private final EdgeResults results1 = new EdgeResults();
    private final EdgeResults results2 = new EdgeResults();
    private final ClipVertex[] incidentEdge = new ClipVertex[2];
    private final Vec2 localTangent = new Vec2();
    private final Vec2 localNormal = new Vec2();
    private final Vec2 planePoint = new Vec2();
    private final Vec2 tangent = new Vec2();
    private final Vec2 v11 = new Vec2();
    private final Vec2 v12 = new Vec2();
    private final ClipVertex[] clipPoints1 = new ClipVertex[2];
    private final ClipVertex[] clipPoints2 = new ClipVertex[2];
    private final Vec2 Q = new Vec2();
    private final Vec2 e = new Vec2();
    private final ContactID cf = new ContactID();
    private final Vec2 e1 = new Vec2();
    private final Vec2 P = new Vec2();
    private final EPCollider collider = new EPCollider();

    public Collision(IWorldPool iWorldPool) {
        this.incidentEdge[0] = new ClipVertex();
        this.incidentEdge[1] = new ClipVertex();
        this.clipPoints1[0] = new ClipVertex();
        this.clipPoints1[1] = new ClipVertex();
        this.clipPoints2[0] = new ClipVertex();
        this.clipPoints2[1] = new ClipVertex();
        this.pool = iWorldPool;
    }

    public final boolean testOverlap(Shape shape, int n, Shape shape2, int n2, Transform transform, Transform transform2) {
        this.input.proxyA.set(shape, n);
        this.input.proxyB.set(shape2, n2);
        this.input.transformA.set(transform);
        this.input.transformB.set(transform2);
        this.input.useRadii = true;
        this.cache.count = 0;
        this.pool.getDistance().distance(this.output, this.cache, this.input);
        return this.output.distance < 1.1920929E-6f;
    }

    public static final void getPointStates(PointState[] pointStateArray, PointState[] pointStateArray2, Manifold manifold, Manifold manifold2) {
        int n;
        ContactID contactID;
        int n2 = 0;
        while (n2 < Settings.maxManifoldPoints) {
            pointStateArray[n2] = PointState.NULL_STATE;
            pointStateArray2[n2] = PointState.NULL_STATE;
            ++n2;
        }
        n2 = 0;
        while (n2 < manifold.pointCount) {
            contactID = manifold.points[n2].id;
            pointStateArray[n2] = PointState.REMOVE_STATE;
            n = 0;
            while (n < manifold2.pointCount) {
                if (manifold2.points[n].id.isEqual(contactID)) {
                    pointStateArray[n2] = PointState.PERSIST_STATE;
                    break;
                }
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < manifold2.pointCount) {
            contactID = manifold2.points[n2].id;
            pointStateArray2[n2] = PointState.ADD_STATE;
            n = 0;
            while (n < manifold.pointCount) {
                if (manifold.points[n].id.isEqual(contactID)) {
                    pointStateArray2[n2] = PointState.PERSIST_STATE;
                    break;
                }
                ++n;
            }
            ++n2;
        }
    }

    public static final int clipSegmentToLine(ClipVertex[] clipVertexArray, ClipVertex[] clipVertexArray2, Vec2 vec2, float f, int n) {
        int n2 = 0;
        ClipVertex clipVertex = clipVertexArray2[0];
        ClipVertex clipVertex2 = clipVertexArray2[1];
        Vec2 vec22 = clipVertex.v;
        Vec2 vec23 = clipVertex2.v;
        float f2 = Vec2.dot(vec2, vec22) - f;
        float f3 = Vec2.dot(vec2, vec23) - f;
        if (f2 <= 0.0f) {
            clipVertexArray[n2++].set(clipVertex);
        }
        if (f3 <= 0.0f) {
            clipVertexArray[n2++].set(clipVertex2);
        }
        if (f2 * f3 < 0.0f) {
            float f4 = f2 / (f2 - f3);
            ClipVertex clipVertex3 = clipVertexArray[n2];
            clipVertex3.v.x = vec22.x + f4 * (vec23.x - vec22.x);
            clipVertex3.v.y = vec22.y + f4 * (vec23.y - vec22.y);
            clipVertex3.id.indexA = (byte)n;
            clipVertex3.id.indexB = clipVertex.id.indexB;
            clipVertex3.id.typeA = (byte)ContactID.Type.VERTEX.ordinal();
            clipVertex3.id.typeB = (byte)ContactID.Type.FACE.ordinal();
            ++n2;
        }
        return n2;
    }

    public final void collideCircles(Manifold manifold, CircleShape circleShape, Transform transform, CircleShape circleShape2, Transform transform2) {
        manifold.pointCount = 0;
        Vec2 vec2 = circleShape.m_p;
        Vec2 vec22 = circleShape2.m_p;
        float f = transform2.q.c * vec22.x - transform2.q.s * vec22.y + transform2.p.x;
        float f2 = transform.q.c * vec2.x - transform.q.s * vec2.y + transform.p.x;
        float f3 = f - f2;
        float f4 = transform2.q.s * vec22.x + transform2.q.c * vec22.y + transform2.p.y;
        float f5 = transform.q.s * vec2.x + transform.q.c * vec2.y + transform.p.y;
        float f6 = f4 - f5;
        float f7 = f3 * f3 + f6 * f6;
        float f8 = circleShape.m_radius + circleShape2.m_radius;
        if (f7 > f8 * f8) {
            return;
        }
        manifold.type = Manifold.ManifoldType.CIRCLES;
        manifold.localPoint.set(vec2);
        manifold.localNormal.setZero();
        manifold.pointCount = 1;
        manifold.points[0].localPoint.set(vec22);
        manifold.points[0].id.zero();
    }

    public final void collidePolygonAndCircle(Manifold manifold, PolygonShape polygonShape, Transform transform, CircleShape circleShape, Transform transform2) {
        manifold.pointCount = 0;
        Vec2 vec2 = circleShape.m_p;
        Rot rot = transform2.q;
        Rot rot2 = transform.q;
        float f = rot.c * vec2.x - rot.s * vec2.y + transform2.p.x;
        float f2 = rot.s * vec2.x + rot.c * vec2.y + transform2.p.y;
        float f3 = f - transform.p.x;
        float f4 = f2 - transform.p.y;
        float f5 = rot2.c * f3 + rot2.s * f4;
        float f6 = -rot2.s * f3 + rot2.c * f4;
        int n = 0;
        float f7 = -3.4028235E38f;
        float f8 = polygonShape.m_radius + circleShape.m_radius;
        int n2 = polygonShape.m_count;
        Vec2[] vec2Array = polygonShape.m_vertices;
        Vec2[] vec2Array2 = polygonShape.m_normals;
        int n3 = 0;
        while (n3 < n2) {
            Vec2 vec22 = vec2Array[n3];
            float f9 = f5 - vec22.x;
            float f10 = f6 - vec22.y;
            float f11 = vec2Array2[n3].x * f9 + vec2Array2[n3].y * f10;
            if (f11 > f8) {
                return;
            }
            if (f11 > f7) {
                f7 = f11;
                n = n3;
            }
            ++n3;
        }
        n3 = n;
        int n4 = n3 + 1 < n2 ? n3 + 1 : 0;
        Vec2 vec23 = vec2Array[n3];
        Vec2 vec24 = vec2Array[n4];
        if (f7 < 1.1920929E-7f) {
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            Vec2 vec25 = vec2Array2[n];
            manifold.localNormal.x = vec25.x;
            manifold.localNormal.y = vec25.y;
            manifold.localPoint.x = (vec23.x + vec24.x) * 0.5f;
            manifold.localPoint.y = (vec23.y + vec24.y) * 0.5f;
            ManifoldPoint manifoldPoint = manifold.points[0];
            manifoldPoint.localPoint.x = vec2.x;
            manifoldPoint.localPoint.y = vec2.y;
            manifoldPoint.id.zero();
            return;
        }
        float f12 = f5 - vec23.x;
        float f13 = f6 - vec23.y;
        float f14 = vec24.x - vec23.x;
        float f15 = vec24.y - vec23.y;
        float f16 = f12 * f14 + f13 * f15;
        float f17 = f5 - vec24.x;
        float f18 = f6 - vec24.y;
        float f19 = vec23.x - vec24.x;
        float f20 = vec23.y - vec24.y;
        float f21 = f17 * f19 + f18 * f20;
        if (f16 <= 0.0f) {
            float f22 = f5 - vec23.x;
            float f23 = f6 - vec23.y;
            if (f22 * f22 + f23 * f23 > f8 * f8) {
                return;
            }
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            manifold.localNormal.x = f5 - vec23.x;
            manifold.localNormal.y = f6 - vec23.y;
            manifold.localNormal.normalize();
            manifold.localPoint.set(vec23);
            manifold.points[0].localPoint.set(vec2);
            manifold.points[0].id.zero();
        } else if (f21 <= 0.0f) {
            float f24 = f5 - vec24.x;
            float f25 = f6 - vec24.y;
            if (f24 * f24 + f25 * f25 > f8 * f8) {
                return;
            }
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            manifold.localNormal.x = f5 - vec24.x;
            manifold.localNormal.y = f6 - vec24.y;
            manifold.localNormal.normalize();
            manifold.localPoint.set(vec24);
            manifold.points[0].localPoint.set(vec2);
            manifold.points[0].id.zero();
        } else {
            float f26 = (vec23.x + vec24.x) * 0.5f;
            float f27 = (vec23.y + vec24.y) * 0.5f;
            float f28 = f5 - f26;
            float f29 = f6 - f27;
            Vec2 vec26 = vec2Array2[n3];
            f7 = f28 * vec26.x + f29 * vec26.y;
            if (f7 > f8) {
                return;
            }
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.FACE_A;
            manifold.localNormal.set(vec2Array2[n3]);
            manifold.localPoint.x = f26;
            manifold.localPoint.y = f27;
            manifold.points[0].localPoint.set(vec2);
            manifold.points[0].id.zero();
        }
    }

    public final void findMaxSeparation(EdgeResults edgeResults, PolygonShape polygonShape, Transform transform, PolygonShape polygonShape2, Transform transform2) {
        int n = polygonShape.m_count;
        int n2 = polygonShape2.m_count;
        Vec2[] vec2Array = polygonShape.m_normals;
        Vec2[] vec2Array2 = polygonShape.m_vertices;
        Vec2[] vec2Array3 = polygonShape2.m_vertices;
        Transform.mulTransToOutUnsafe(transform2, transform, this.xf);
        Rot rot = this.xf.q;
        int n3 = 0;
        float f = -3.4028235E38f;
        int n4 = 0;
        while (n4 < n) {
            Rot.mulToOutUnsafe(rot, vec2Array[n4], this.n);
            Transform.mulToOutUnsafe(this.xf, vec2Array2[n4], this.v1);
            float f2 = Float.MAX_VALUE;
            int n5 = 0;
            while (n5 < n2) {
                Vec2 vec2 = vec2Array3[n5];
                float f3 = this.n.x * (vec2.x - this.v1.x) + this.n.y * (vec2.y - this.v1.y);
                if (f3 < f2) {
                    f2 = f3;
                }
                ++n5;
            }
            if (f2 > f) {
                f = f2;
                n3 = n4;
            }
            ++n4;
        }
        edgeResults.edgeIndex = n3;
        edgeResults.separation = f;
    }

    public final void findIncidentEdge(ClipVertex[] clipVertexArray, PolygonShape polygonShape, Transform transform, int n, PolygonShape polygonShape2, Transform transform2) {
        int n2 = polygonShape.m_count;
        Vec2[] vec2Array = polygonShape.m_normals;
        int n3 = polygonShape2.m_count;
        Vec2[] vec2Array2 = polygonShape2.m_vertices;
        Vec2[] vec2Array3 = polygonShape2.m_normals;
        assert (n >= 0 && n < n2);
        ClipVertex clipVertex = clipVertexArray[0];
        ClipVertex clipVertex2 = clipVertexArray[1];
        Rot rot = transform.q;
        Rot rot2 = transform2.q;
        Vec2 vec2 = vec2Array[n];
        float f = rot.c * vec2.x - rot.s * vec2.y;
        float f2 = rot.s * vec2.x + rot.c * vec2.y;
        float f3 = rot2.c * f + rot2.s * f2;
        float f4 = -rot2.s * f + rot2.c * f2;
        int n4 = 0;
        float f5 = Float.MAX_VALUE;
        int n5 = 0;
        while (n5 < n3) {
            Vec2 vec22 = vec2Array3[n5];
            float f6 = f3 * vec22.x + f4 * vec22.y;
            if (f6 < f5) {
                f5 = f6;
                n4 = n5;
            }
            ++n5;
        }
        n5 = n4;
        int n6 = n5 + 1 < n3 ? n5 + 1 : 0;
        Vec2 vec23 = vec2Array2[n5];
        Vec2 vec24 = clipVertex.v;
        vec24.x = rot2.c * vec23.x - rot2.s * vec23.y + transform2.p.x;
        vec24.y = rot2.s * vec23.x + rot2.c * vec23.y + transform2.p.y;
        clipVertex.id.indexA = (byte)n;
        clipVertex.id.indexB = (byte)n5;
        clipVertex.id.typeA = (byte)ContactID.Type.FACE.ordinal();
        clipVertex.id.typeB = (byte)ContactID.Type.VERTEX.ordinal();
        Vec2 vec25 = vec2Array2[n6];
        Vec2 vec26 = clipVertex2.v;
        vec26.x = rot2.c * vec25.x - rot2.s * vec25.y + transform2.p.x;
        vec26.y = rot2.s * vec25.x + rot2.c * vec25.y + transform2.p.y;
        clipVertex2.id.indexA = (byte)n;
        clipVertex2.id.indexB = (byte)n6;
        clipVertex2.id.typeA = (byte)ContactID.Type.FACE.ordinal();
        clipVertex2.id.typeB = (byte)ContactID.Type.VERTEX.ordinal();
    }

    public final void collidePolygons(Manifold manifold, PolygonShape polygonShape, Transform transform, PolygonShape polygonShape2, Transform transform2) {
        boolean bl;
        int n;
        Transform transform3;
        Transform transform4;
        PolygonShape polygonShape3;
        PolygonShape polygonShape4;
        manifold.pointCount = 0;
        float f = polygonShape.m_radius + polygonShape2.m_radius;
        this.findMaxSeparation(this.results1, polygonShape, transform, polygonShape2, transform2);
        if (this.results1.separation > f) {
            return;
        }
        this.findMaxSeparation(this.results2, polygonShape2, transform2, polygonShape, transform);
        if (this.results2.separation > f) {
            return;
        }
        float f2 = 0.1f * Settings.linearSlop;
        if (this.results2.separation > this.results1.separation + f2) {
            polygonShape4 = polygonShape2;
            polygonShape3 = polygonShape;
            transform4 = transform2;
            transform3 = transform;
            n = this.results2.edgeIndex;
            manifold.type = Manifold.ManifoldType.FACE_B;
            bl = true;
        } else {
            polygonShape4 = polygonShape;
            polygonShape3 = polygonShape2;
            transform4 = transform;
            transform3 = transform2;
            n = this.results1.edgeIndex;
            manifold.type = Manifold.ManifoldType.FACE_A;
            bl = false;
        }
        Rot rot = transform4.q;
        this.findIncidentEdge(this.incidentEdge, polygonShape4, transform4, n, polygonShape3, transform3);
        int n2 = polygonShape4.m_count;
        Vec2[] vec2Array = polygonShape4.m_vertices;
        int n3 = n;
        int n4 = n + 1 < n2 ? n + 1 : 0;
        this.v11.set(vec2Array[n3]);
        this.v12.set(vec2Array[n4]);
        this.localTangent.x = this.v12.x - this.v11.x;
        this.localTangent.y = this.v12.y - this.v11.y;
        this.localTangent.normalize();
        this.localNormal.x = 1.0f * this.localTangent.y;
        this.localNormal.y = -1.0f * this.localTangent.x;
        this.planePoint.x = (this.v11.x + this.v12.x) * 0.5f;
        this.planePoint.y = (this.v11.y + this.v12.y) * 0.5f;
        this.tangent.x = rot.c * this.localTangent.x - rot.s * this.localTangent.y;
        this.tangent.y = rot.s * this.localTangent.x + rot.c * this.localTangent.y;
        float f3 = 1.0f * this.tangent.y;
        float f4 = -1.0f * this.tangent.x;
        Transform.mulToOut(transform4, this.v11, this.v11);
        Transform.mulToOut(transform4, this.v12, this.v12);
        float f5 = f3 * this.v11.x + f4 * this.v11.y;
        float f6 = -(this.tangent.x * this.v11.x + this.tangent.y * this.v11.y) + f;
        float f7 = this.tangent.x * this.v12.x + this.tangent.y * this.v12.y + f;
        this.tangent.negateLocal();
        int n5 = Collision.clipSegmentToLine(this.clipPoints1, this.incidentEdge, this.tangent, f6, n3);
        this.tangent.negateLocal();
        if (n5 < 2) {
            return;
        }
        n5 = Collision.clipSegmentToLine(this.clipPoints2, this.clipPoints1, this.tangent, f7, n4);
        if (n5 < 2) {
            return;
        }
        manifold.localNormal.set(this.localNormal);
        manifold.localPoint.set(this.planePoint);
        int n6 = 0;
        int n7 = 0;
        while (n7 < Settings.maxManifoldPoints) {
            float f8 = f3 * this.clipPoints2[n7].v.x + f4 * this.clipPoints2[n7].v.y - f5;
            if (f8 <= f) {
                ManifoldPoint manifoldPoint = manifold.points[n6];
                Vec2 vec2 = manifoldPoint.localPoint;
                float f9 = this.clipPoints2[n7].v.x - transform3.p.x;
                float f10 = this.clipPoints2[n7].v.y - transform3.p.y;
                vec2.x = transform3.q.c * f9 + transform3.q.s * f10;
                vec2.y = -transform3.q.s * f9 + transform3.q.c * f10;
                manifoldPoint.id.set(this.clipPoints2[n7].id);
                if (bl) {
                    manifoldPoint.id.flip();
                }
                ++n6;
            }
            ++n7;
        }
        manifold.pointCount = n6;
    }

    public void collideEdgeAndCircle(Manifold manifold, EdgeShape edgeShape, Transform transform, CircleShape circleShape, Transform transform2) {
        manifold.pointCount = 0;
        Transform.mulToOutUnsafe(transform2, circleShape.m_p, this.temp);
        Transform.mulTransToOutUnsafe(transform, this.temp, this.Q);
        Vec2 vec2 = edgeShape.m_vertex1;
        Vec2 vec22 = edgeShape.m_vertex2;
        this.e.set(vec22).subLocal(vec2);
        float f = Vec2.dot(this.e, this.temp.set(vec22).subLocal(this.Q));
        float f2 = Vec2.dot(this.e, this.temp.set(this.Q).subLocal(vec2));
        float f3 = edgeShape.m_radius + circleShape.m_radius;
        this.cf.indexB = 0;
        this.cf.typeB = (byte)ContactID.Type.VERTEX.ordinal();
        if (f2 <= 0.0f) {
            Vec2 vec23 = vec2;
            d.set(this.Q).subLocal(vec23);
            float f4 = Vec2.dot(d, d);
            if (f4 > f3 * f3) {
                return;
            }
            if (edgeShape.m_hasVertex0) {
                Vec2 vec24 = edgeShape.m_vertex0;
                Vec2 vec25 = vec2;
                this.e1.set(vec25).subLocal(vec24);
                float f5 = Vec2.dot(this.e1, this.temp.set(vec25).subLocal(this.Q));
                if (f5 > 0.0f) {
                    return;
                }
            }
            this.cf.indexA = 0;
            this.cf.typeA = (byte)ContactID.Type.VERTEX.ordinal();
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.CIRCLES;
            manifold.localNormal.setZero();
            manifold.localPoint.set(vec23);
            manifold.points[0].id.set(this.cf);
            manifold.points[0].localPoint.set(circleShape.m_p);
            return;
        }
        if (f <= 0.0f) {
            Vec2 vec26 = vec22;
            d.set(this.Q).subLocal(vec26);
            float f6 = Vec2.dot(d, d);
            if (f6 > f3 * f3) {
                return;
            }
            if (edgeShape.m_hasVertex3) {
                Vec2 vec27 = edgeShape.m_vertex3;
                Vec2 vec28 = vec22;
                Vec2 vec29 = this.e1;
                vec29.set(vec27).subLocal(vec28);
                float f7 = Vec2.dot(vec29, this.temp.set(this.Q).subLocal(vec28));
                if (f7 > 0.0f) {
                    return;
                }
            }
            this.cf.indexA = 1;
            this.cf.typeA = (byte)ContactID.Type.VERTEX.ordinal();
            manifold.pointCount = 1;
            manifold.type = Manifold.ManifoldType.CIRCLES;
            manifold.localNormal.setZero();
            manifold.localPoint.set(vec26);
            manifold.points[0].id.set(this.cf);
            manifold.points[0].localPoint.set(circleShape.m_p);
            return;
        }
        float f8 = Vec2.dot(this.e, this.e);
        assert (f8 > 0.0f);
        this.P.set(vec2).mulLocal(f).addLocal(this.temp.set(vec22).mulLocal(f2));
        this.P.mulLocal(1.0f / f8);
        d.set(this.Q).subLocal(this.P);
        float f9 = Vec2.dot(d, d);
        if (f9 > f3 * f3) {
            return;
        }
        this.n.x = -this.e.y;
        this.n.y = this.e.x;
        if (Vec2.dot(this.n, this.temp.set(this.Q).subLocal(vec2)) < 0.0f) {
            this.n.set(-this.n.x, -this.n.y);
        }
        this.n.normalize();
        this.cf.indexA = 0;
        this.cf.typeA = (byte)ContactID.Type.FACE.ordinal();
        manifold.pointCount = 1;
        manifold.type = Manifold.ManifoldType.FACE_A;
        manifold.localNormal.set(this.n);
        manifold.localPoint.set(vec2);
        manifold.points[0].id.set(this.cf);
        manifold.points[0].localPoint.set(circleShape.m_p);
    }

    public void collideEdgeAndPolygon(Manifold manifold, EdgeShape edgeShape, Transform transform, PolygonShape polygonShape, Transform transform2) {
        this.collider.collide(manifold, edgeShape, transform, polygonShape, transform2);
    }

    public static class ClipVertex {
        public final Vec2 v = new Vec2();
        public final ContactID id = new ContactID();

        public void set(ClipVertex clipVertex) {
            Vec2 vec2 = clipVertex.v;
            this.v.x = vec2.x;
            this.v.y = vec2.y;
            ContactID contactID = clipVertex.id;
            this.id.indexA = contactID.indexA;
            this.id.indexB = contactID.indexB;
            this.id.typeA = contactID.typeA;
            this.id.typeB = contactID.typeB;
        }
    }

    static class EPAxis {
        Type type;
        int index;
        float separation;

        EPAxis() {
        }

        static enum Type {
            UNKNOWN,
            EDGE_A,
            EDGE_B;

        }
    }

    static class EPCollider {
        final TempPolygon m_polygonB = new TempPolygon();
        final Transform m_xf = new Transform();
        final Vec2 m_centroidB = new Vec2();
        Vec2 m_v0 = new Vec2();
        Vec2 m_v1 = new Vec2();
        Vec2 m_v2 = new Vec2();
        Vec2 m_v3 = new Vec2();
        final Vec2 m_normal0 = new Vec2();
        final Vec2 m_normal1 = new Vec2();
        final Vec2 m_normal2 = new Vec2();
        final Vec2 m_normal = new Vec2();
        VertexType m_type1;
        VertexType m_type2;
        final Vec2 m_lowerLimit = new Vec2();
        final Vec2 m_upperLimit = new Vec2();
        float m_radius;
        boolean m_front;
        private final Vec2 edge1 = new Vec2();
        private final Vec2 temp = new Vec2();
        private final Vec2 edge0 = new Vec2();
        private final Vec2 edge2 = new Vec2();
        private final ClipVertex[] ie = new ClipVertex[2];
        private final ClipVertex[] clipPoints1 = new ClipVertex[2];
        private final ClipVertex[] clipPoints2 = new ClipVertex[2];
        private final ReferenceFace rf = new ReferenceFace();
        private final EPAxis edgeAxis = new EPAxis();
        private final EPAxis polygonAxis = new EPAxis();
        private final Vec2 perp = new Vec2();
        private final Vec2 n = new Vec2();

        public EPCollider() {
            int n = 0;
            while (n < 2) {
                this.ie[n] = new ClipVertex();
                this.clipPoints1[n] = new ClipVertex();
                this.clipPoints2[n] = new ClipVertex();
                ++n;
            }
        }

        public void collide(Manifold manifold, EdgeShape edgeShape, Transform transform, PolygonShape polygonShape, Transform transform2) {
            int n;
            int n2;
            Transform.mulTransToOutUnsafe(transform, transform2, this.m_xf);
            Transform.mulToOutUnsafe(this.m_xf, polygonShape.m_centroid, this.m_centroidB);
            this.m_v0 = edgeShape.m_vertex0;
            this.m_v1 = edgeShape.m_vertex1;
            this.m_v2 = edgeShape.m_vertex2;
            this.m_v3 = edgeShape.m_vertex3;
            boolean bl = edgeShape.m_hasVertex0;
            boolean bl2 = edgeShape.m_hasVertex3;
            this.edge1.set(this.m_v2).subLocal(this.m_v1);
            this.edge1.normalize();
            this.m_normal1.set(this.edge1.y, -this.edge1.x);
            float f = Vec2.dot(this.m_normal1, this.temp.set(this.m_centroidB).subLocal(this.m_v1));
            float f2 = 0.0f;
            float f3 = 0.0f;
            boolean bl3 = false;
            boolean bl4 = false;
            if (bl) {
                this.edge0.set(this.m_v1).subLocal(this.m_v0);
                this.edge0.normalize();
                this.m_normal0.set(this.edge0.y, -this.edge0.x);
                bl3 = Vec2.cross(this.edge0, this.edge1) >= 0.0f;
                f2 = Vec2.dot(this.m_normal0, this.temp.set(this.m_centroidB).subLocal(this.m_v0));
            }
            if (bl2) {
                this.edge2.set(this.m_v3).subLocal(this.m_v2);
                this.edge2.normalize();
                this.m_normal2.set(this.edge2.y, -this.edge2.x);
                bl4 = Vec2.cross(this.edge1, this.edge2) > 0.0f;
                f3 = Vec2.dot(this.m_normal2, this.temp.set(this.m_centroidB).subLocal(this.m_v2));
            }
            if (bl && bl2) {
                if (bl3 && bl4) {
                    boolean bl5 = this.m_front = f2 >= 0.0f || f >= 0.0f || f3 >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.x = this.m_normal1.x;
                        this.m_normal.y = this.m_normal1.y;
                        this.m_lowerLimit.x = this.m_normal0.x;
                        this.m_lowerLimit.y = this.m_normal0.y;
                        this.m_upperLimit.x = this.m_normal2.x;
                        this.m_upperLimit.y = this.m_normal2.y;
                    } else {
                        this.m_normal.x = -this.m_normal1.x;
                        this.m_normal.y = -this.m_normal1.y;
                        this.m_lowerLimit.x = -this.m_normal1.x;
                        this.m_lowerLimit.y = -this.m_normal1.y;
                        this.m_upperLimit.x = -this.m_normal1.x;
                        this.m_upperLimit.y = -this.m_normal1.y;
                    }
                } else if (bl3) {
                    boolean bl6 = this.m_front = f2 >= 0.0f || f >= 0.0f && f3 >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.x = this.m_normal1.x;
                        this.m_normal.y = this.m_normal1.y;
                        this.m_lowerLimit.x = this.m_normal0.x;
                        this.m_lowerLimit.y = this.m_normal0.y;
                        this.m_upperLimit.x = this.m_normal1.x;
                        this.m_upperLimit.y = this.m_normal1.y;
                    } else {
                        this.m_normal.x = -this.m_normal1.x;
                        this.m_normal.y = -this.m_normal1.y;
                        this.m_lowerLimit.x = -this.m_normal2.x;
                        this.m_lowerLimit.y = -this.m_normal2.y;
                        this.m_upperLimit.x = -this.m_normal1.x;
                        this.m_upperLimit.y = -this.m_normal1.y;
                    }
                } else if (bl4) {
                    boolean bl7 = this.m_front = f3 >= 0.0f || f2 >= 0.0f && f >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.x = this.m_normal1.x;
                        this.m_normal.y = this.m_normal1.y;
                        this.m_lowerLimit.x = this.m_normal1.x;
                        this.m_lowerLimit.y = this.m_normal1.y;
                        this.m_upperLimit.x = this.m_normal2.x;
                        this.m_upperLimit.y = this.m_normal2.y;
                    } else {
                        this.m_normal.x = -this.m_normal1.x;
                        this.m_normal.y = -this.m_normal1.y;
                        this.m_lowerLimit.x = -this.m_normal1.x;
                        this.m_lowerLimit.y = -this.m_normal1.y;
                        this.m_upperLimit.x = -this.m_normal0.x;
                        this.m_upperLimit.y = -this.m_normal0.y;
                    }
                } else {
                    boolean bl8 = this.m_front = f2 >= 0.0f && f >= 0.0f && f3 >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.x = this.m_normal1.x;
                        this.m_normal.y = this.m_normal1.y;
                        this.m_lowerLimit.x = this.m_normal1.x;
                        this.m_lowerLimit.y = this.m_normal1.y;
                        this.m_upperLimit.x = this.m_normal1.x;
                        this.m_upperLimit.y = this.m_normal1.y;
                    } else {
                        this.m_normal.x = -this.m_normal1.x;
                        this.m_normal.y = -this.m_normal1.y;
                        this.m_lowerLimit.x = -this.m_normal2.x;
                        this.m_lowerLimit.y = -this.m_normal2.y;
                        this.m_upperLimit.x = -this.m_normal0.x;
                        this.m_upperLimit.y = -this.m_normal0.y;
                    }
                }
            } else if (bl) {
                if (bl3) {
                    boolean bl9 = this.m_front = f2 >= 0.0f || f >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.x = this.m_normal1.x;
                        this.m_normal.y = this.m_normal1.y;
                        this.m_lowerLimit.x = this.m_normal0.x;
                        this.m_lowerLimit.y = this.m_normal0.y;
                        this.m_upperLimit.x = -this.m_normal1.x;
                        this.m_upperLimit.y = -this.m_normal1.y;
                    } else {
                        this.m_normal.x = -this.m_normal1.x;
                        this.m_normal.y = -this.m_normal1.y;
                        this.m_lowerLimit.x = this.m_normal1.x;
                        this.m_lowerLimit.y = this.m_normal1.y;
                        this.m_upperLimit.x = -this.m_normal1.x;
                        this.m_upperLimit.y = -this.m_normal1.y;
                    }
                } else {
                    boolean bl10 = this.m_front = f2 >= 0.0f && f >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.x = this.m_normal1.x;
                        this.m_normal.y = this.m_normal1.y;
                        this.m_lowerLimit.x = this.m_normal1.x;
                        this.m_lowerLimit.y = this.m_normal1.y;
                        this.m_upperLimit.x = -this.m_normal1.x;
                        this.m_upperLimit.y = -this.m_normal1.y;
                    } else {
                        this.m_normal.x = -this.m_normal1.x;
                        this.m_normal.y = -this.m_normal1.y;
                        this.m_lowerLimit.x = this.m_normal1.x;
                        this.m_lowerLimit.y = this.m_normal1.y;
                        this.m_upperLimit.x = -this.m_normal0.x;
                        this.m_upperLimit.y = -this.m_normal0.y;
                    }
                }
            } else if (bl2) {
                if (bl4) {
                    boolean bl11 = this.m_front = f >= 0.0f || f3 >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.x = this.m_normal1.x;
                        this.m_normal.y = this.m_normal1.y;
                        this.m_lowerLimit.x = -this.m_normal1.x;
                        this.m_lowerLimit.y = -this.m_normal1.y;
                        this.m_upperLimit.x = this.m_normal2.x;
                        this.m_upperLimit.y = this.m_normal2.y;
                    } else {
                        this.m_normal.x = -this.m_normal1.x;
                        this.m_normal.y = -this.m_normal1.y;
                        this.m_lowerLimit.x = -this.m_normal1.x;
                        this.m_lowerLimit.y = -this.m_normal1.y;
                        this.m_upperLimit.x = this.m_normal1.x;
                        this.m_upperLimit.y = this.m_normal1.y;
                    }
                } else {
                    boolean bl12 = this.m_front = f >= 0.0f && f3 >= 0.0f;
                    if (this.m_front) {
                        this.m_normal.x = this.m_normal1.x;
                        this.m_normal.y = this.m_normal1.y;
                        this.m_lowerLimit.x = -this.m_normal1.x;
                        this.m_lowerLimit.y = -this.m_normal1.y;
                        this.m_upperLimit.x = this.m_normal1.x;
                        this.m_upperLimit.y = this.m_normal1.y;
                    } else {
                        this.m_normal.x = -this.m_normal1.x;
                        this.m_normal.y = -this.m_normal1.y;
                        this.m_lowerLimit.x = -this.m_normal2.x;
                        this.m_lowerLimit.y = -this.m_normal2.y;
                        this.m_upperLimit.x = this.m_normal1.x;
                        this.m_upperLimit.y = this.m_normal1.y;
                    }
                }
            } else {
                boolean bl13 = this.m_front = f >= 0.0f;
                if (this.m_front) {
                    this.m_normal.x = this.m_normal1.x;
                    this.m_normal.y = this.m_normal1.y;
                    this.m_lowerLimit.x = -this.m_normal1.x;
                    this.m_lowerLimit.y = -this.m_normal1.y;
                    this.m_upperLimit.x = -this.m_normal1.x;
                    this.m_upperLimit.y = -this.m_normal1.y;
                } else {
                    this.m_normal.x = -this.m_normal1.x;
                    this.m_normal.y = -this.m_normal1.y;
                    this.m_lowerLimit.x = this.m_normal1.x;
                    this.m_lowerLimit.y = this.m_normal1.y;
                    this.m_upperLimit.x = this.m_normal1.x;
                    this.m_upperLimit.y = this.m_normal1.y;
                }
            }
            this.m_polygonB.count = polygonShape.m_count;
            int n3 = 0;
            while (n3 < polygonShape.m_count) {
                Transform.mulToOutUnsafe(this.m_xf, polygonShape.m_vertices[n3], this.m_polygonB.vertices[n3]);
                Rot.mulToOutUnsafe(this.m_xf.q, polygonShape.m_normals[n3], this.m_polygonB.normals[n3]);
                ++n3;
            }
            this.m_radius = 2.0f * Settings.polygonRadius;
            manifold.pointCount = 0;
            this.computeEdgeSeparation(this.edgeAxis);
            if (this.edgeAxis.type == EPAxis.Type.UNKNOWN) {
                return;
            }
            if (this.edgeAxis.separation > this.m_radius) {
                return;
            }
            this.computePolygonSeparation(this.polygonAxis);
            if (this.polygonAxis.type != EPAxis.Type.UNKNOWN && this.polygonAxis.separation > this.m_radius) {
                return;
            }
            EPAxis ePAxis = this.polygonAxis.type == EPAxis.Type.UNKNOWN ? this.edgeAxis : (this.polygonAxis.separation > 0.98f * this.edgeAxis.separation + 0.001f ? this.polygonAxis : this.edgeAxis);
            ClipVertex clipVertex = this.ie[0];
            ClipVertex clipVertex2 = this.ie[1];
            if (ePAxis.type == EPAxis.Type.EDGE_A) {
                manifold.type = Manifold.ManifoldType.FACE_A;
                n2 = 0;
                float f4 = Vec2.dot(this.m_normal, this.m_polygonB.normals[0]);
                n = 1;
                while (n < this.m_polygonB.count) {
                    float f5 = Vec2.dot(this.m_normal, this.m_polygonB.normals[n]);
                    if (f5 < f4) {
                        f4 = f5;
                        n2 = n;
                    }
                    ++n;
                }
                n = n2;
                int n4 = n + 1 < this.m_polygonB.count ? n + 1 : 0;
                clipVertex.v.set(this.m_polygonB.vertices[n]);
                clipVertex.id.indexA = 0;
                clipVertex.id.indexB = (byte)n;
                clipVertex.id.typeA = (byte)ContactID.Type.FACE.ordinal();
                clipVertex.id.typeB = (byte)ContactID.Type.VERTEX.ordinal();
                clipVertex2.v.set(this.m_polygonB.vertices[n4]);
                clipVertex2.id.indexA = 0;
                clipVertex2.id.indexB = (byte)n4;
                clipVertex2.id.typeA = (byte)ContactID.Type.FACE.ordinal();
                clipVertex2.id.typeB = (byte)ContactID.Type.VERTEX.ordinal();
                if (this.m_front) {
                    this.rf.i1 = 0;
                    this.rf.i2 = 1;
                    this.rf.v1.set(this.m_v1);
                    this.rf.v2.set(this.m_v2);
                    this.rf.normal.set(this.m_normal1);
                } else {
                    this.rf.i1 = 1;
                    this.rf.i2 = 0;
                    this.rf.v1.set(this.m_v2);
                    this.rf.v2.set(this.m_v1);
                    this.rf.normal.set(this.m_normal1).negateLocal();
                }
            } else {
                manifold.type = Manifold.ManifoldType.FACE_B;
                clipVertex.v.set(this.m_v1);
                clipVertex.id.indexA = 0;
                clipVertex.id.indexB = (byte)ePAxis.index;
                clipVertex.id.typeA = (byte)ContactID.Type.VERTEX.ordinal();
                clipVertex.id.typeB = (byte)ContactID.Type.FACE.ordinal();
                clipVertex2.v.set(this.m_v2);
                clipVertex2.id.indexA = 0;
                clipVertex2.id.indexB = (byte)ePAxis.index;
                clipVertex2.id.typeA = (byte)ContactID.Type.VERTEX.ordinal();
                clipVertex2.id.typeB = (byte)ContactID.Type.FACE.ordinal();
                this.rf.i1 = ePAxis.index;
                this.rf.i2 = this.rf.i1 + 1 < this.m_polygonB.count ? this.rf.i1 + 1 : 0;
                this.rf.v1.set(this.m_polygonB.vertices[this.rf.i1]);
                this.rf.v2.set(this.m_polygonB.vertices[this.rf.i2]);
                this.rf.normal.set(this.m_polygonB.normals[this.rf.i1]);
            }
            this.rf.sideNormal1.set(this.rf.normal.y, -this.rf.normal.x);
            this.rf.sideNormal2.set(this.rf.sideNormal1).negateLocal();
            this.rf.sideOffset1 = Vec2.dot(this.rf.sideNormal1, this.rf.v1);
            this.rf.sideOffset2 = Vec2.dot(this.rf.sideNormal2, this.rf.v2);
            n2 = Collision.clipSegmentToLine(this.clipPoints1, this.ie, this.rf.sideNormal1, this.rf.sideOffset1, this.rf.i1);
            if (n2 < Settings.maxManifoldPoints) {
                return;
            }
            n2 = Collision.clipSegmentToLine(this.clipPoints2, this.clipPoints1, this.rf.sideNormal2, this.rf.sideOffset2, this.rf.i2);
            if (n2 < Settings.maxManifoldPoints) {
                return;
            }
            if (ePAxis.type == EPAxis.Type.EDGE_A) {
                manifold.localNormal.set(this.rf.normal);
                manifold.localPoint.set(this.rf.v1);
            } else {
                manifold.localNormal.set(polygonShape.m_normals[this.rf.i1]);
                manifold.localPoint.set(polygonShape.m_vertices[this.rf.i1]);
            }
            int n5 = 0;
            n = 0;
            while (n < Settings.maxManifoldPoints) {
                float f6 = Vec2.dot(this.rf.normal, this.temp.set(this.clipPoints2[n].v).subLocal(this.rf.v1));
                if (f6 <= this.m_radius) {
                    ManifoldPoint manifoldPoint = manifold.points[n5];
                    if (ePAxis.type == EPAxis.Type.EDGE_A) {
                        Transform.mulTransToOutUnsafe(this.m_xf, this.clipPoints2[n].v, manifoldPoint.localPoint);
                        manifoldPoint.id.set(this.clipPoints2[n].id);
                    } else {
                        manifoldPoint.localPoint.set(this.clipPoints2[n].v);
                        manifoldPoint.id.typeA = this.clipPoints2[n].id.typeB;
                        manifoldPoint.id.typeB = this.clipPoints2[n].id.typeA;
                        manifoldPoint.id.indexA = this.clipPoints2[n].id.indexB;
                        manifoldPoint.id.indexB = this.clipPoints2[n].id.indexA;
                    }
                    ++n5;
                }
                ++n;
            }
            manifold.pointCount = n5;
        }

        public void computeEdgeSeparation(EPAxis ePAxis) {
            ePAxis.type = EPAxis.Type.EDGE_A;
            ePAxis.index = this.m_front ? 0 : 1;
            ePAxis.separation = Float.MAX_VALUE;
            float f = this.m_normal.x;
            float f2 = this.m_normal.y;
            int n = 0;
            while (n < this.m_polygonB.count) {
                Vec2 vec2 = this.m_polygonB.vertices[n];
                float f3 = vec2.x - this.m_v1.x;
                float f4 = vec2.y - this.m_v1.y;
                float f5 = f * f3 + f2 * f4;
                if (f5 < ePAxis.separation) {
                    ePAxis.separation = f5;
                }
                ++n;
            }
        }

        public void computePolygonSeparation(EPAxis ePAxis) {
            ePAxis.type = EPAxis.Type.UNKNOWN;
            ePAxis.index = -1;
            ePAxis.separation = -3.4028235E38f;
            this.perp.x = -this.m_normal.y;
            this.perp.y = this.m_normal.x;
            int n = 0;
            while (n < this.m_polygonB.count) {
                Vec2 vec2 = this.m_polygonB.normals[n];
                Vec2 vec22 = this.m_polygonB.vertices[n];
                this.n.x = -vec2.x;
                this.n.y = -vec2.y;
                float f = vec22.x - this.m_v1.x;
                float f2 = vec22.y - this.m_v1.y;
                float f3 = this.n.x * f + this.n.y * f2;
                float f4 = this.n.x * (f = vec22.x - this.m_v2.x) + this.n.y * (f2 = vec22.y - this.m_v2.y);
                float f5 = MathUtils.min(f3, f4);
                if (f5 > this.m_radius) {
                    ePAxis.type = EPAxis.Type.EDGE_B;
                    ePAxis.index = n;
                    ePAxis.separation = f5;
                    return;
                }
                if (!(!(this.n.x * this.perp.x + this.n.y * this.perp.y >= 0.0f) ? Vec2.dot(this.temp.set(this.n).subLocal(this.m_lowerLimit), this.m_normal) < -Settings.angularSlop : Vec2.dot(this.temp.set(this.n).subLocal(this.m_upperLimit), this.m_normal) < -Settings.angularSlop) && f5 > ePAxis.separation) {
                    ePAxis.type = EPAxis.Type.EDGE_B;
                    ePAxis.index = n;
                    ePAxis.separation = f5;
                }
                ++n;
            }
        }

        static enum VertexType {
            ISOLATED,
            CONCAVE,
            CONVEX;

        }
    }

    private static class EdgeResults {
        public float separation;
        public int edgeIndex;

        private EdgeResults() {
        }
    }

    public static enum PointState {
        NULL_STATE,
        ADD_STATE,
        PERSIST_STATE,
        REMOVE_STATE;

    }

    static class ReferenceFace {
        int i1;
        int i2;
        final Vec2 v1 = new Vec2();
        final Vec2 v2 = new Vec2();
        final Vec2 normal = new Vec2();
        final Vec2 sideNormal1 = new Vec2();
        float sideOffset1;
        final Vec2 sideNormal2 = new Vec2();
        float sideOffset2;

        ReferenceFace() {
        }
    }

    static class TempPolygon {
        final Vec2[] vertices = new Vec2[Settings.maxPolygonVertices];
        final Vec2[] normals = new Vec2[Settings.maxPolygonVertices];
        int count;

        public TempPolygon() {
            int n = 0;
            while (n < this.vertices.length) {
                this.vertices[n] = new Vec2();
                this.normals[n] = new Vec2();
                ++n;
            }
        }
    }
}

