/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

public class ContactID
implements Comparable<ContactID> {
    public byte indexA;
    public byte indexB;
    public byte typeA;
    public byte typeB;

    public int getKey() {
        return this.indexA << 24 | this.indexB << 16 | this.typeA << 8 | this.typeB;
    }

    public boolean isEqual(ContactID contactID) {
        return this.getKey() == contactID.getKey();
    }

    public ContactID() {
    }

    public ContactID(ContactID contactID) {
        this.set(contactID);
    }

    public void set(ContactID contactID) {
        this.indexA = contactID.indexA;
        this.indexB = contactID.indexB;
        this.typeA = contactID.typeA;
        this.typeB = contactID.typeB;
    }

    public void flip() {
        byte by = this.indexA;
        this.indexA = this.indexB;
        this.indexB = by;
        by = this.typeA;
        this.typeA = this.typeB;
        this.typeB = by;
    }

    public void zero() {
        this.indexA = 0;
        this.indexB = 0;
        this.typeA = 0;
        this.typeB = 0;
    }

    @Override
    public int compareTo(ContactID contactID) {
        return this.getKey() - contactID.getKey();
    }

    public static enum Type {
        VERTEX,
        FACE;

    }
}

