/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class CircleShape
extends Shape {
    public final Vec2 m_p = new Vec2();

    public CircleShape() {
        super(ShapeType.CIRCLE);
        this.m_radius = 0.0f;
    }

    @Override
    public final Shape clone() {
        CircleShape circleShape = new CircleShape();
        circleShape.m_p.x = this.m_p.x;
        circleShape.m_p.y = this.m_p.y;
        circleShape.m_radius = this.m_radius;
        return circleShape;
    }

    @Override
    public final int getChildCount() {
        return 1;
    }

    public final int getSupport(Vec2 vec2) {
        return 0;
    }

    public final Vec2 getSupportVertex(Vec2 vec2) {
        return this.m_p;
    }

    public final int getVertexCount() {
        return 1;
    }

    public final Vec2 getVertex(int n) {
        assert (n == 0);
        return this.m_p;
    }

    @Override
    public final boolean testPoint(Transform transform, Vec2 vec2) {
        Rot rot = transform.q;
        Vec2 vec22 = transform.p;
        float f = -(rot.c * this.m_p.x - rot.s * this.m_p.y + vec22.x - vec2.x);
        float f2 = -(rot.s * this.m_p.x + rot.c * this.m_p.y + vec22.y - vec2.y);
        return f * f + f2 * f2 <= this.m_radius * this.m_radius;
    }

    @Override
    public float computeDistanceToOut(Transform transform, Vec2 vec2, int n, Vec2 vec22) {
        Rot rot = transform.q;
        float f = rot.c * this.m_p.x - rot.s * this.m_p.y + transform.p.x;
        float f2 = rot.s * this.m_p.x + rot.c * this.m_p.y + transform.p.y;
        float f3 = vec2.x - f;
        float f4 = vec2.y - f2;
        float f5 = MathUtils.sqrt(f3 * f3 + f4 * f4);
        vec22.x = f3 * 1.0f / f5;
        vec22.y = f4 * 1.0f / f5;
        return f5 - this.m_radius;
    }

    @Override
    public final boolean raycast(RayCastOutput rayCastOutput, RayCastInput rayCastInput, Transform transform, int n) {
        Vec2 vec2 = rayCastInput.p1;
        Vec2 vec22 = rayCastInput.p2;
        Rot rot = transform.q;
        Vec2 vec23 = transform.p;
        float f = rot.c * this.m_p.x - rot.s * this.m_p.y + vec23.x;
        float f2 = vec2.x - f;
        float f3 = vec22.x - vec2.x;
        float f4 = rot.s * this.m_p.x + rot.c * this.m_p.y + vec23.y;
        float f5 = vec2.y - f4;
        float f6 = vec22.y - vec2.y;
        float f7 = f2 * f3 + f5 * f6;
        float f8 = f3 * f3 + f6 * f6;
        float f9 = f2 * f2 + f5 * f5 - this.m_radius * this.m_radius;
        float f10 = f7 * f7 - f8 * f9;
        if (f10 < 0.0f || f8 < 1.1920929E-7f) {
            return false;
        }
        float f11 = -(f7 + MathUtils.sqrt(f10));
        if (0.0f <= f11 && f11 <= rayCastInput.maxFraction * f8) {
            rayCastOutput.fraction = f11 /= f8;
            rayCastOutput.normal.x = f3 * f11 + f2;
            rayCastOutput.normal.y = f6 * f11 + f5;
            rayCastOutput.normal.normalize();
            return true;
        }
        return false;
    }

    @Override
    public final void computeAABB(AABB aABB, Transform transform, int n) {
        Rot rot = transform.q;
        Vec2 vec2 = transform.p;
        float f = rot.c * this.m_p.x - rot.s * this.m_p.y + vec2.x;
        float f2 = rot.s * this.m_p.x + rot.c * this.m_p.y + vec2.y;
        aABB.lowerBound.x = f - this.m_radius;
        aABB.lowerBound.y = f2 - this.m_radius;
        aABB.upperBound.x = f + this.m_radius;
        aABB.upperBound.y = f2 + this.m_radius;
    }

    @Override
    public final void computeMass(MassData massData, float f) {
        massData.mass = f * (float)Math.PI * this.m_radius * this.m_radius;
        massData.center.x = this.m_p.x;
        massData.center.y = this.m_p.y;
        massData.I = massData.mass * (0.5f * this.m_radius * this.m_radius + (this.m_p.x * this.m_p.x + this.m_p.y * this.m_p.y));
    }
}

