/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;

public class Mat22
implements Serializable {
    private static final long serialVersionUID = 2L;
    public final Vec2 ex;
    public final Vec2 ey;

    public String toString() {
        Object object = "";
        object = (String)object + "[" + this.ex.x + "," + this.ey.x + "]\n";
        object = (String)object + "[" + this.ex.y + "," + this.ey.y + "]";
        return object;
    }

    public Mat22() {
        this.ex = new Vec2();
        this.ey = new Vec2();
    }

    public Mat22(Vec2 vec2, Vec2 vec22) {
        this.ex = vec2.clone();
        this.ey = vec22.clone();
    }

    public Mat22(float f, float f2, float f3, float f4) {
        this.ex = new Vec2(f, f3);
        this.ey = new Vec2(f2, f4);
    }

    public final Mat22 set(Mat22 mat22) {
        this.ex.x = mat22.ex.x;
        this.ex.y = mat22.ex.y;
        this.ey.x = mat22.ey.x;
        this.ey.y = mat22.ey.y;
        return this;
    }

    public final Mat22 set(float f, float f2, float f3, float f4) {
        this.ex.x = f;
        this.ex.y = f3;
        this.ey.x = f2;
        this.ey.y = f4;
        return this;
    }

    public final Mat22 clone() {
        return new Mat22(this.ex, this.ey);
    }

    public final void set(float f) {
        float f2 = MathUtils.cos(f);
        float f3 = MathUtils.sin(f);
        this.ex.x = f2;
        this.ey.x = -f3;
        this.ex.y = f3;
        this.ey.y = f2;
    }

    public final void setIdentity() {
        this.ex.x = 1.0f;
        this.ey.x = 0.0f;
        this.ex.y = 0.0f;
        this.ey.y = 1.0f;
    }

    public final void setZero() {
        this.ex.x = 0.0f;
        this.ey.x = 0.0f;
        this.ex.y = 0.0f;
        this.ey.y = 0.0f;
    }

    public final float getAngle() {
        return MathUtils.atan2(this.ex.y, this.ex.x);
    }

    public final void set(Vec2 vec2, Vec2 vec22) {
        this.ex.x = vec2.x;
        this.ey.x = vec22.x;
        this.ex.y = vec2.y;
        this.ey.y = vec22.y;
    }

    public final Mat22 invert() {
        float f = this.ex.x;
        float f2 = this.ey.x;
        float f3 = this.ex.y;
        float f4 = this.ey.y;
        Mat22 mat22 = new Mat22();
        float f5 = f * f4 - f2 * f3;
        if (f5 != 0.0f) {
            f5 = 1.0f / f5;
        }
        mat22.ex.x = f5 * f4;
        mat22.ey.x = -f5 * f2;
        mat22.ex.y = -f5 * f3;
        mat22.ey.y = f5 * f;
        return mat22;
    }

    public final Mat22 invertLocal() {
        float f = this.ex.x;
        float f2 = this.ey.y;
        float f3 = this.ey.x;
        float f4 = this.ex.y;
        float f5 = f * f2 - f3 * f4;
        if (f5 != 0.0f) {
            f5 = 1.0f / f5;
        }
        this.ex.x = f5 * f2;
        this.ey.x = -f5 * f3;
        this.ex.y = -f5 * f4;
        this.ey.y = f5 * f;
        return this;
    }

    public final void invertToOut(Mat22 mat22) {
        float f = this.ex.x;
        float f2 = this.ey.x;
        float f3 = this.ex.y;
        float f4 = this.ey.y;
        float f5 = f * f4 - f2 * f3;
        f5 = 1.0f / f5;
        mat22.ex.x = f5 * f4;
        mat22.ey.x = -f5 * f2;
        mat22.ex.y = -f5 * f3;
        mat22.ey.y = f5 * f;
    }

    public final Mat22 abs() {
        return new Mat22(MathUtils.abs(this.ex.x), MathUtils.abs(this.ey.x), MathUtils.abs(this.ex.y), MathUtils.abs(this.ey.y));
    }

    public final void absLocal() {
        this.ex.absLocal();
        this.ey.absLocal();
    }

    public static final Mat22 abs(Mat22 mat22) {
        return mat22.abs();
    }

    public static void absToOut(Mat22 mat22, Mat22 mat222) {
        mat222.ex.x = MathUtils.abs(mat22.ex.x);
        mat222.ex.y = MathUtils.abs(mat22.ex.y);
        mat222.ey.x = MathUtils.abs(mat22.ey.x);
        mat222.ey.y = MathUtils.abs(mat22.ey.y);
    }

    public final Vec2 mul(Vec2 vec2) {
        return new Vec2(this.ex.x * vec2.x + this.ey.x * vec2.y, this.ex.y * vec2.x + this.ey.y * vec2.y);
    }

    public final void mulToOut(Vec2 vec2, Vec2 vec22) {
        float f = this.ex.y * vec2.x + this.ey.y * vec2.y;
        vec22.x = this.ex.x * vec2.x + this.ey.x * vec2.y;
        vec22.y = f;
    }

    public final void mulToOutUnsafe(Vec2 vec2, Vec2 vec22) {
        assert (vec2 != vec22);
        vec22.x = this.ex.x * vec2.x + this.ey.x * vec2.y;
        vec22.y = this.ex.y * vec2.x + this.ey.y * vec2.y;
    }

    public final Mat22 mul(Mat22 mat22) {
        Mat22 mat222 = new Mat22();
        mat222.ex.x = this.ex.x * mat22.ex.x + this.ey.x * mat22.ex.y;
        mat222.ex.y = this.ex.y * mat22.ex.x + this.ey.y * mat22.ex.y;
        mat222.ey.x = this.ex.x * mat22.ey.x + this.ey.x * mat22.ey.y;
        mat222.ey.y = this.ex.y * mat22.ey.x + this.ey.y * mat22.ey.y;
        return mat222;
    }

    public final Mat22 mulLocal(Mat22 mat22) {
        this.mulToOut(mat22, this);
        return this;
    }

    public final void mulToOut(Mat22 mat22, Mat22 mat222) {
        float f;
        float f2;
        float f3 = this.ex.y * mat22.ex.x + this.ey.y * mat22.ex.y;
        mat222.ex.x = f2 = this.ex.x * mat22.ex.x + this.ey.x * mat22.ex.y;
        mat222.ex.y = f3;
        float f4 = this.ex.y * mat22.ey.x + this.ey.y * mat22.ey.y;
        mat222.ey.x = f = this.ex.x * mat22.ey.x + this.ey.x * mat22.ey.y;
        mat222.ey.y = f4;
    }

    public final void mulToOutUnsafe(Mat22 mat22, Mat22 mat222) {
        assert (mat222 != mat22);
        assert (mat222 != this);
        mat222.ex.x = this.ex.x * mat22.ex.x + this.ey.x * mat22.ex.y;
        mat222.ex.y = this.ex.y * mat22.ex.x + this.ey.y * mat22.ex.y;
        mat222.ey.x = this.ex.x * mat22.ey.x + this.ey.x * mat22.ey.y;
        mat222.ey.y = this.ex.y * mat22.ey.x + this.ey.y * mat22.ey.y;
    }

    public final Mat22 mulTrans(Mat22 mat22) {
        Mat22 mat222 = new Mat22();
        mat222.ex.x = Vec2.dot(this.ex, mat22.ex);
        mat222.ex.y = Vec2.dot(this.ey, mat22.ex);
        mat222.ey.x = Vec2.dot(this.ex, mat22.ey);
        mat222.ey.y = Vec2.dot(this.ey, mat22.ey);
        return mat222;
    }

    public final Mat22 mulTransLocal(Mat22 mat22) {
        this.mulTransToOut(mat22, this);
        return this;
    }

    public final void mulTransToOut(Mat22 mat22, Mat22 mat222) {
        float f = this.ex.x * mat22.ex.x + this.ex.y * mat22.ex.y;
        float f2 = this.ey.x * mat22.ex.x + this.ey.y * mat22.ex.y;
        float f3 = this.ex.x * mat22.ey.x + this.ex.y * mat22.ey.y;
        float f4 = this.ey.x * mat22.ey.x + this.ey.y * mat22.ey.y;
        mat222.ex.x = f;
        mat222.ey.x = f3;
        mat222.ex.y = f2;
        mat222.ey.y = f4;
    }

    public final void mulTransToOutUnsafe(Mat22 mat22, Mat22 mat222) {
        assert (mat22 != mat222);
        assert (this != mat222);
        mat222.ex.x = this.ex.x * mat22.ex.x + this.ex.y * mat22.ex.y;
        mat222.ey.x = this.ex.x * mat22.ey.x + this.ex.y * mat22.ey.y;
        mat222.ex.y = this.ey.x * mat22.ex.x + this.ey.y * mat22.ex.y;
        mat222.ey.y = this.ey.x * mat22.ey.x + this.ey.y * mat22.ey.y;
    }

    public final Vec2 mulTrans(Vec2 vec2) {
        return new Vec2(vec2.x * this.ex.x + vec2.y * this.ex.y, vec2.x * this.ey.x + vec2.y * this.ey.y);
    }

    public final void mulTransToOut(Vec2 vec2, Vec2 vec22) {
        float f = vec2.x * this.ex.x + vec2.y * this.ex.y;
        vec22.y = vec2.x * this.ey.x + vec2.y * this.ey.y;
        vec22.x = f;
    }

    public final Mat22 add(Mat22 mat22) {
        Mat22 mat222 = new Mat22();
        mat222.ex.x = this.ex.x + mat22.ex.x;
        mat222.ex.y = this.ex.y + mat22.ex.y;
        mat222.ey.x = this.ey.x + mat22.ey.x;
        mat222.ey.y = this.ey.y + mat22.ey.y;
        return mat222;
    }

    public final Mat22 addLocal(Mat22 mat22) {
        this.ex.x += mat22.ex.x;
        this.ex.y += mat22.ex.y;
        this.ey.x += mat22.ey.x;
        this.ey.y += mat22.ey.y;
        return this;
    }

    public final Vec2 solve(Vec2 vec2) {
        float f = this.ex.x;
        float f2 = this.ey.y;
        float f3 = this.ey.x;
        float f4 = this.ex.y;
        float f5 = f * f2 - f3 * f4;
        if (f5 != 0.0f) {
            f5 = 1.0f / f5;
        }
        Vec2 vec22 = new Vec2(f5 * (f2 * vec2.x - f3 * vec2.y), f5 * (f * vec2.y - f4 * vec2.x));
        return vec22;
    }

    public final void solveToOut(Vec2 vec2, Vec2 vec22) {
        float f = this.ex.x;
        float f2 = this.ey.y;
        float f3 = this.ey.x;
        float f4 = this.ex.y;
        float f5 = f * f2 - f3 * f4;
        if (f5 != 0.0f) {
            f5 = 1.0f / f5;
        }
        float f6 = f5 * (f * vec2.y - f4 * vec2.x);
        vec22.x = f5 * (f2 * vec2.x - f3 * vec2.y);
        vec22.y = f6;
    }

    public static final Vec2 mul(Mat22 mat22, Vec2 vec2) {
        return new Vec2(mat22.ex.x * vec2.x + mat22.ey.x * vec2.y, mat22.ex.y * vec2.x + mat22.ey.y * vec2.y);
    }

    public static final void mulToOut(Mat22 mat22, Vec2 vec2, Vec2 vec22) {
        float f = mat22.ex.y * vec2.x + mat22.ey.y * vec2.y;
        vec22.x = mat22.ex.x * vec2.x + mat22.ey.x * vec2.y;
        vec22.y = f;
    }

    public static final void mulToOutUnsafe(Mat22 mat22, Vec2 vec2, Vec2 vec22) {
        assert (vec2 != vec22);
        vec22.x = mat22.ex.x * vec2.x + mat22.ey.x * vec2.y;
        vec22.y = mat22.ex.y * vec2.x + mat22.ey.y * vec2.y;
    }

    public static final Mat22 mul(Mat22 mat22, Mat22 mat222) {
        Mat22 mat223 = new Mat22();
        mat223.ex.x = mat22.ex.x * mat222.ex.x + mat22.ey.x * mat222.ex.y;
        mat223.ex.y = mat22.ex.y * mat222.ex.x + mat22.ey.y * mat222.ex.y;
        mat223.ey.x = mat22.ex.x * mat222.ey.x + mat22.ey.x * mat222.ey.y;
        mat223.ey.y = mat22.ex.y * mat222.ey.x + mat22.ey.y * mat222.ey.y;
        return mat223;
    }

    public static final void mulToOut(Mat22 mat22, Mat22 mat222, Mat22 mat223) {
        float f = mat22.ex.y * mat222.ex.x + mat22.ey.y * mat222.ex.y;
        float f2 = mat22.ex.x * mat222.ex.x + mat22.ey.x * mat222.ex.y;
        float f3 = mat22.ex.y * mat222.ey.x + mat22.ey.y * mat222.ey.y;
        float f4 = mat22.ex.x * mat222.ey.x + mat22.ey.x * mat222.ey.y;
        mat223.ex.x = f2;
        mat223.ex.y = f;
        mat223.ey.x = f4;
        mat223.ey.y = f3;
    }

    public static final void mulToOutUnsafe(Mat22 mat22, Mat22 mat222, Mat22 mat223) {
        assert (mat223 != mat22);
        assert (mat223 != mat222);
        mat223.ex.x = mat22.ex.x * mat222.ex.x + mat22.ey.x * mat222.ex.y;
        mat223.ex.y = mat22.ex.y * mat222.ex.x + mat22.ey.y * mat222.ex.y;
        mat223.ey.x = mat22.ex.x * mat222.ey.x + mat22.ey.x * mat222.ey.y;
        mat223.ey.y = mat22.ex.y * mat222.ey.x + mat22.ey.y * mat222.ey.y;
    }

    public static final Vec2 mulTrans(Mat22 mat22, Vec2 vec2) {
        return new Vec2(vec2.x * mat22.ex.x + vec2.y * mat22.ex.y, vec2.x * mat22.ey.x + vec2.y * mat22.ey.y);
    }

    public static final void mulTransToOut(Mat22 mat22, Vec2 vec2, Vec2 vec22) {
        float f = vec2.x * mat22.ex.x + vec2.y * mat22.ex.y;
        vec22.y = vec2.x * mat22.ey.x + vec2.y * mat22.ey.y;
        vec22.x = f;
    }

    public static final void mulTransToOutUnsafe(Mat22 mat22, Vec2 vec2, Vec2 vec22) {
        assert (vec22 != vec2);
        vec22.y = vec2.x * mat22.ey.x + vec2.y * mat22.ey.y;
        vec22.x = vec2.x * mat22.ex.x + vec2.y * mat22.ex.y;
    }

    public static final Mat22 mulTrans(Mat22 mat22, Mat22 mat222) {
        Mat22 mat223 = new Mat22();
        mat223.ex.x = mat22.ex.x * mat222.ex.x + mat22.ex.y * mat222.ex.y;
        mat223.ex.y = mat22.ey.x * mat222.ex.x + mat22.ey.y * mat222.ex.y;
        mat223.ey.x = mat22.ex.x * mat222.ey.x + mat22.ex.y * mat222.ey.y;
        mat223.ey.y = mat22.ey.x * mat222.ey.x + mat22.ey.y * mat222.ey.y;
        return mat223;
    }

    public static final void mulTransToOut(Mat22 mat22, Mat22 mat222, Mat22 mat223) {
        float f = mat22.ex.x * mat222.ex.x + mat22.ex.y * mat222.ex.y;
        float f2 = mat22.ey.x * mat222.ex.x + mat22.ey.y * mat222.ex.y;
        float f3 = mat22.ex.x * mat222.ey.x + mat22.ex.y * mat222.ey.y;
        float f4 = mat22.ey.x * mat222.ey.x + mat22.ey.y * mat222.ey.y;
        mat223.ex.x = f;
        mat223.ex.y = f2;
        mat223.ey.x = f3;
        mat223.ey.y = f4;
    }

    public static final void mulTransToOutUnsafe(Mat22 mat22, Mat22 mat222, Mat22 mat223) {
        assert (mat22 != mat223);
        assert (mat222 != mat223);
        mat223.ex.x = mat22.ex.x * mat222.ex.x + mat22.ex.y * mat222.ex.y;
        mat223.ex.y = mat22.ey.x * mat222.ex.x + mat22.ey.y * mat222.ex.y;
        mat223.ey.x = mat22.ex.x * mat222.ey.x + mat22.ex.y * mat222.ey.y;
        mat223.ey.y = mat22.ey.x * mat222.ey.x + mat22.ey.y * mat222.ey.y;
    }

    public static final Mat22 createRotationalTransform(float f) {
        Mat22 mat22 = new Mat22();
        float f2 = MathUtils.cos(f);
        float f3 = MathUtils.sin(f);
        mat22.ex.x = f2;
        mat22.ey.x = -f3;
        mat22.ex.y = f3;
        mat22.ey.y = f2;
        return mat22;
    }

    public static final void createRotationalTransform(float f, Mat22 mat22) {
        float f2 = MathUtils.cos(f);
        float f3 = MathUtils.sin(f);
        mat22.ex.x = f2;
        mat22.ey.x = -f3;
        mat22.ex.y = f3;
        mat22.ey.y = f2;
    }

    public static final Mat22 createScaleTransform(float f) {
        Mat22 mat22 = new Mat22();
        mat22.ex.x = f;
        mat22.ey.y = f;
        return mat22;
    }

    public static final void createScaleTransform(float f, Mat22 mat22) {
        mat22.ex.x = f;
        mat22.ey.y = f;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ex == null ? 0 : this.ex.hashCode());
        n = 31 * n + (this.ey == null ? 0 : this.ey.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Mat22 mat22 = (Mat22)object;
        if (this.ex == null ? mat22.ex != null : !this.ex.equals(mat22.ex)) {
            return false;
        }
        return !(this.ey == null ? mat22.ey != null : !this.ey.equals(mat22.ey));
    }
}

