/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import org.jbox2d.common.IViewportTransform;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;

public class OBBViewportTransform
implements IViewportTransform {
    protected final OBB box = new OBB();
    private boolean yFlip = false;
    private final Mat22 yFlipMat = new Mat22(1.0f, 0.0f, 0.0f, -1.0f);
    private final Mat22 inv = new Mat22();
    private final Mat22 inv2 = new Mat22();

    public OBBViewportTransform() {
        this.box.R.setIdentity();
    }

    public void set(OBBViewportTransform oBBViewportTransform) {
        this.box.center.set(oBBViewportTransform.box.center);
        this.box.extents.set(oBBViewportTransform.box.extents);
        this.box.R.set(oBBViewportTransform.box.R);
        this.yFlip = oBBViewportTransform.yFlip;
    }

    @Override
    public void setCamera(float f, float f2, float f3) {
        this.box.center.set(f, f2);
        Mat22.createScaleTransform(f3, this.box.R);
    }

    @Override
    public Vec2 getExtents() {
        return this.box.extents;
    }

    @Override
    public Mat22 getMat22Representation() {
        return this.box.R;
    }

    @Override
    public void setExtents(Vec2 vec2) {
        this.box.extents.set(vec2);
    }

    @Override
    public void setExtents(float f, float f2) {
        this.box.extents.set(f, f2);
    }

    @Override
    public Vec2 getCenter() {
        return this.box.center;
    }

    @Override
    public void setCenter(Vec2 vec2) {
        this.box.center.set(vec2);
    }

    @Override
    public void setCenter(float f, float f2) {
        this.box.center.set(f, f2);
    }

    public Mat22 getTransform() {
        return this.box.R;
    }

    public void setTransform(Mat22 mat22) {
        this.box.R.set(mat22);
    }

    @Override
    public void mulByTransform(Mat22 mat22) {
        this.box.R.mulLocal(mat22);
    }

    @Override
    public boolean isYFlip() {
        return this.yFlip;
    }

    @Override
    public void setYFlip(boolean bl) {
        this.yFlip = bl;
    }

    @Override
    public void getScreenVectorToWorld(Vec2 vec2, Vec2 vec22) {
        this.box.R.invertToOut(this.inv);
        this.inv.mulToOut(vec2, vec22);
        if (this.yFlip) {
            this.yFlipMat.mulToOut(vec22, vec22);
        }
    }

    @Override
    public void getWorldVectorToScreen(Vec2 vec2, Vec2 vec22) {
        this.box.R.mulToOut(vec2, vec22);
        if (this.yFlip) {
            this.yFlipMat.mulToOut(vec22, vec22);
        }
    }

    @Override
    public void getWorldToScreen(Vec2 vec2, Vec2 vec22) {
        vec22.x = vec2.x - this.box.center.x;
        vec22.y = vec2.y - this.box.center.y;
        this.box.R.mulToOut(vec22, vec22);
        if (this.yFlip) {
            this.yFlipMat.mulToOut(vec22, vec22);
        }
        vec22.x += this.box.extents.x;
        vec22.y += this.box.extents.y;
    }

    @Override
    public void getScreenToWorld(Vec2 vec2, Vec2 vec22) {
        vec22.x = vec2.x - this.box.extents.x;
        vec22.y = vec2.y - this.box.extents.y;
        if (this.yFlip) {
            this.yFlipMat.mulToOut(vec22, vec22);
        }
        this.box.R.invertToOut(this.inv2);
        this.inv2.mulToOut(vec22, vec22);
        vec22.x += this.box.center.x;
        vec22.y += this.box.center.y;
    }

    public static class OBB {
        public final Mat22 R = new Mat22();
        public final Vec2 center = new Vec2();
        public final Vec2 extents = new Vec2();
    }
}

