/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class Sweep
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Vec2 localCenter = new Vec2();
    public final Vec2 c0 = new Vec2();
    public final Vec2 c = new Vec2();
    public float a0;
    public float a;
    public float alpha0;

    public String toString() {
        String string = "Sweep:\nlocalCenter: " + String.valueOf(this.localCenter) + "\n";
        string = string + "c0: " + String.valueOf(this.c0) + ", c: " + String.valueOf(this.c) + "\n";
        string = string + "a0: " + this.a0 + ", a: " + this.a + "\n";
        string = string + "alpha0: " + this.alpha0;
        return string;
    }

    public final void normalize() {
        float f = (float)Math.PI * 2 * (float)MathUtils.floor(this.a0 / ((float)Math.PI * 2));
        this.a0 -= f;
        this.a -= f;
    }

    public final Sweep set(Sweep sweep) {
        this.localCenter.set(sweep.localCenter);
        this.c0.set(sweep.c0);
        this.c.set(sweep.c);
        this.a0 = sweep.a0;
        this.a = sweep.a;
        this.alpha0 = sweep.alpha0;
        return this;
    }

    public final void getTransform(Transform transform, float f) {
        assert (transform != null);
        transform.p.x = (1.0f - f) * this.c0.x + f * this.c.x;
        transform.p.y = (1.0f - f) * this.c0.y + f * this.c.y;
        float f2 = (1.0f - f) * this.a0 + f * this.a;
        transform.q.set(f2);
        Rot rot = transform.q;
        transform.p.x -= rot.c * this.localCenter.x - rot.s * this.localCenter.y;
        transform.p.y -= rot.s * this.localCenter.x + rot.c * this.localCenter.y;
    }

    public final void advance(float f) {
        assert (this.alpha0 < 1.0f);
        float f2 = (f - this.alpha0) / (1.0f - this.alpha0);
        this.c0.x += f2 * (this.c.x - this.c0.x);
        this.c0.y += f2 * (this.c.y - this.c0.y);
        this.a0 += f2 * (this.a - this.a0);
        this.alpha0 = f;
    }
}

