/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.callbacks.ContactFilter;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.callbacks.PairCallback;
import org.jbox2d.collision.broadphase.BroadPhase;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureProxy;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;

public class ContactManager
implements PairCallback {
    public BroadPhase m_broadPhase;
    public Contact m_contactList = null;
    public int m_contactCount = 0;
    public ContactFilter m_contactFilter = new ContactFilter();
    public ContactListener m_contactListener = null;
    private final World pool;

    public ContactManager(World world, BroadPhase broadPhase) {
        this.m_broadPhase = broadPhase;
        this.pool = world;
    }

    @Override
    public void addPair(Object object, Object object2) {
        Object object3;
        Body body;
        FixtureProxy fixtureProxy = (FixtureProxy)object;
        FixtureProxy fixtureProxy2 = (FixtureProxy)object2;
        Fixture fixture = fixtureProxy.fixture;
        Fixture fixture2 = fixtureProxy2.fixture;
        int n = fixtureProxy.childIndex;
        int n2 = fixtureProxy2.childIndex;
        Body body2 = fixture.getBody();
        if (body2 == (body = fixture2.getBody())) {
            return;
        }
        ContactEdge contactEdge = body.getContactList();
        while (contactEdge != null) {
            if (contactEdge.other == body2) {
                object3 = contactEdge.contact.getFixtureA();
                Fixture fixture3 = contactEdge.contact.getFixtureB();
                int n3 = contactEdge.contact.getChildIndexA();
                int n4 = contactEdge.contact.getChildIndexB();
                if (object3 == fixture && n3 == n && fixture3 == fixture2 && n4 == n2) {
                    return;
                }
                if (object3 == fixture2 && n3 == n2 && fixture3 == fixture && n4 == n) {
                    return;
                }
            }
            contactEdge = contactEdge.next;
        }
        if (!body.shouldCollide(body2)) {
            return;
        }
        if (this.m_contactFilter != null && !this.m_contactFilter.shouldCollide(fixture, fixture2)) {
            return;
        }
        object3 = this.pool.popContact(fixture, n, fixture2, n2);
        if (object3 == null) {
            return;
        }
        fixture = ((Contact)object3).getFixtureA();
        fixture2 = ((Contact)object3).getFixtureB();
        n = ((Contact)object3).getChildIndexA();
        n2 = ((Contact)object3).getChildIndexB();
        body2 = fixture.getBody();
        body = fixture2.getBody();
        ((Contact)object3).m_prev = null;
        ((Contact)object3).m_next = this.m_contactList;
        if (this.m_contactList != null) {
            this.m_contactList.m_prev = object3;
        }
        this.m_contactList = object3;
        ((Contact)object3).m_nodeA.contact = object3;
        ((Contact)object3).m_nodeA.other = body;
        ((Contact)object3).m_nodeA.prev = null;
        ((Contact)object3).m_nodeA.next = body2.m_contactList;
        if (body2.m_contactList != null) {
            body2.m_contactList.prev = ((Contact)object3).m_nodeA;
        }
        body2.m_contactList = ((Contact)object3).m_nodeA;
        ((Contact)object3).m_nodeB.contact = object3;
        ((Contact)object3).m_nodeB.other = body2;
        ((Contact)object3).m_nodeB.prev = null;
        ((Contact)object3).m_nodeB.next = body.m_contactList;
        if (body.m_contactList != null) {
            body.m_contactList.prev = ((Contact)object3).m_nodeB;
        }
        body.m_contactList = ((Contact)object3).m_nodeB;
        if (!fixture.isSensor() && !fixture2.isSensor()) {
            body2.setAwake(true);
            body.setAwake(true);
        }
        ++this.m_contactCount;
    }

    public void findNewContacts() {
        this.m_broadPhase.updatePairs(this);
    }

    public void destroy(Contact contact) {
        Fixture fixture = contact.getFixtureA();
        Fixture fixture2 = contact.getFixtureB();
        Body body = fixture.getBody();
        Body body2 = fixture2.getBody();
        if (this.m_contactListener != null && contact.isTouching()) {
            this.m_contactListener.endContact(contact);
        }
        if (contact.m_prev != null) {
            contact.m_prev.m_next = contact.m_next;
        }
        if (contact.m_next != null) {
            contact.m_next.m_prev = contact.m_prev;
        }
        if (contact == this.m_contactList) {
            this.m_contactList = contact.m_next;
        }
        if (contact.m_nodeA.prev != null) {
            contact.m_nodeA.prev.next = contact.m_nodeA.next;
        }
        if (contact.m_nodeA.next != null) {
            contact.m_nodeA.next.prev = contact.m_nodeA.prev;
        }
        if (contact.m_nodeA == body.m_contactList) {
            body.m_contactList = contact.m_nodeA.next;
        }
        if (contact.m_nodeB.prev != null) {
            contact.m_nodeB.prev.next = contact.m_nodeB.next;
        }
        if (contact.m_nodeB.next != null) {
            contact.m_nodeB.next.prev = contact.m_nodeB.prev;
        }
        if (contact.m_nodeB == body2.m_contactList) {
            body2.m_contactList = contact.m_nodeB.next;
        }
        this.pool.pushContact(contact);
        --this.m_contactCount;
    }

    public void collide() {
        Contact contact = this.m_contactList;
        while (contact != null) {
            boolean bl;
            Fixture fixture = contact.getFixtureA();
            Fixture fixture2 = contact.getFixtureB();
            int n = contact.getChildIndexA();
            int n2 = contact.getChildIndexB();
            Body body = fixture.getBody();
            Body body2 = fixture2.getBody();
            if ((contact.m_flags & 8) == 8) {
                if (!body2.shouldCollide(body)) {
                    Contact contact2 = contact;
                    contact = contact2.getNext();
                    this.destroy(contact2);
                    continue;
                }
                if (this.m_contactFilter != null && !this.m_contactFilter.shouldCollide(fixture, fixture2)) {
                    Contact contact3 = contact;
                    contact = contact3.getNext();
                    this.destroy(contact3);
                    continue;
                }
                contact.m_flags &= 0xFFFFFFF7;
            }
            boolean bl2 = body.isAwake() && body.m_type != BodyType.STATIC;
            boolean bl3 = bl = body2.isAwake() && body2.m_type != BodyType.STATIC;
            if (!bl2 && !bl) {
                contact = contact.getNext();
                continue;
            }
            int n3 = fixture.m_proxies[n].proxyId;
            int n4 = fixture2.m_proxies[n2].proxyId;
            boolean bl4 = this.m_broadPhase.testOverlap(n3, n4);
            if (!bl4) {
                Contact contact4 = contact;
                contact = contact4.getNext();
                this.destroy(contact4);
                continue;
            }
            contact.update(this.m_contactListener);
            contact = contact.getNext();
        }
    }
}

