/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.callbacks.ContactFilter;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.DestructionListener;
import org.jbox2d.callbacks.ParticleDestructionListener;
import org.jbox2d.callbacks.ParticleQueryCallback;
import org.jbox2d.callbacks.ParticleRaycastCallback;
import org.jbox2d.callbacks.QueryCallback;
import org.jbox2d.callbacks.RayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.TimeOfImpact;
import org.jbox2d.collision.broadphase.BroadPhase;
import org.jbox2d.collision.broadphase.BroadPhaseStrategy;
import org.jbox2d.collision.broadphase.DefaultBroadPhaseBuffer;
import org.jbox2d.collision.broadphase.DynamicTree;
import org.jbox2d.collision.shapes.ChainShape;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Sweep;
import org.jbox2d.common.Timer;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.ContactManager;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureProxy;
import org.jbox2d.dynamics.Island;
import org.jbox2d.dynamics.Profile;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.WorldQueryWrapper;
import org.jbox2d.dynamics.WorldRayCastWrapper;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.dynamics.contacts.ContactRegister;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.JointEdge;
import org.jbox2d.dynamics.joints.PulleyJoint;
import org.jbox2d.particle.ParticleBodyContact;
import org.jbox2d.particle.ParticleColor;
import org.jbox2d.particle.ParticleContact;
import org.jbox2d.particle.ParticleDef;
import org.jbox2d.particle.ParticleGroup;
import org.jbox2d.particle.ParticleGroupDef;
import org.jbox2d.particle.ParticleSystem;
import org.jbox2d.pooling.IDynamicStack;
import org.jbox2d.pooling.IWorldPool;
import org.jbox2d.pooling.arrays.Vec2Array;
import org.jbox2d.pooling.normal.DefaultWorldPool;

public class World {
    public static final int WORLD_POOL_SIZE = 100;
    public static final int WORLD_POOL_CONTAINER_SIZE = 10;
    public static final int NEW_FIXTURE = 1;
    public static final int LOCKED = 2;
    public static final int CLEAR_FORCES = 4;
    public int activeContacts = 0;
    public int contactPoolCount = 0;
    protected int m_flags;
    protected ContactManager m_contactManager;
    private Body m_bodyList;
    private Joint m_jointList;
    private int m_bodyCount;
    private int m_jointCount;
    private final Vec2 m_gravity = new Vec2();
    private boolean m_allowSleep;
    private DestructionListener m_destructionListener;
    private ParticleDestructionListener m_particleDestructionListener;
    private DebugDraw m_debugDraw;
    private final IWorldPool pool;
    private float m_inv_dt0;
    private boolean m_warmStarting;
    private boolean m_continuousPhysics;
    private boolean m_subStepping;
    private boolean m_stepComplete;
    private Profile m_profile;
    private ParticleSystem m_particleSystem;
    private ContactRegister[][] contactStacks = new ContactRegister[ShapeType.values().length][ShapeType.values().length];
    private final TimeStep step = new TimeStep();
    private final Timer stepTimer = new Timer();
    private final Timer tempTimer = new Timer();
    private final Color3f color = new Color3f();
    private final Transform xf = new Transform();
    private final Vec2 cA = new Vec2();
    private final Vec2 cB = new Vec2();
    private final Vec2Array avs = new Vec2Array();
    private final WorldQueryWrapper wqwrapper = new WorldQueryWrapper();
    private final WorldRayCastWrapper wrcwrapper = new WorldRayCastWrapper();
    private final RayCastInput input = new RayCastInput();
    private final Island island = new Island();
    private Body[] stack = new Body[10];
    private final Timer broadphaseTimer = new Timer();
    private final Island toiIsland = new Island();
    private final TimeOfImpact.TOIInput toiInput = new TimeOfImpact.TOIInput();
    private final TimeOfImpact.TOIOutput toiOutput = new TimeOfImpact.TOIOutput();
    private final TimeStep subStep = new TimeStep();
    private final Body[] tempBodies = new Body[2];
    private final Sweep backup1 = new Sweep();
    private final Sweep backup2 = new Sweep();
    private static Integer LIQUID_INT = new Integer(1234598372);
    private float liquidLength = 0.12f;
    private float averageLinearVel = -1.0f;
    private final Vec2 liquidOffset = new Vec2();
    private final Vec2 circCenterMoved = new Vec2();
    private final Color3f liquidColor = new Color3f(0.4f, 0.4f, 1.0f);
    private final Vec2 center = new Vec2();
    private final Vec2 axis = new Vec2();
    private final Vec2 v1 = new Vec2();
    private final Vec2 v2 = new Vec2();
    private final Vec2Array tlvertices = new Vec2Array();

    public World(Vec2 vec2) {
        this(vec2, new DefaultWorldPool(100, 10));
    }

    public World(Vec2 vec2, IWorldPool iWorldPool) {
        this(vec2, iWorldPool, new DynamicTree());
    }

    public World(Vec2 vec2, IWorldPool iWorldPool, BroadPhaseStrategy broadPhaseStrategy) {
        this(vec2, iWorldPool, new DefaultBroadPhaseBuffer(broadPhaseStrategy));
    }

    public World(Vec2 vec2, IWorldPool iWorldPool, BroadPhase broadPhase) {
        this.pool = iWorldPool;
        this.m_destructionListener = null;
        this.m_debugDraw = null;
        this.m_bodyList = null;
        this.m_jointList = null;
        this.m_bodyCount = 0;
        this.m_jointCount = 0;
        this.m_warmStarting = true;
        this.m_continuousPhysics = true;
        this.m_subStepping = false;
        this.m_stepComplete = true;
        this.m_allowSleep = true;
        this.m_gravity.set(vec2);
        this.m_flags = 4;
        this.m_inv_dt0 = 0.0f;
        this.m_contactManager = new ContactManager(this, broadPhase);
        this.m_profile = new Profile();
        this.m_particleSystem = new ParticleSystem(this);
        this.initializeRegisters();
    }

    public void setAllowSleep(boolean bl) {
        if (bl == this.m_allowSleep) {
            return;
        }
        this.m_allowSleep = bl;
        if (!this.m_allowSleep) {
            Body body = this.m_bodyList;
            while (body != null) {
                body.setAwake(true);
                body = body.m_next;
            }
        }
    }

    public void setSubStepping(boolean bl) {
        this.m_subStepping = bl;
    }

    public boolean isSubStepping() {
        return this.m_subStepping;
    }

    public boolean isAllowSleep() {
        return this.m_allowSleep;
    }

    private void addType(IDynamicStack<Contact> iDynamicStack, ShapeType shapeType, ShapeType shapeType2) {
        ContactRegister contactRegister = new ContactRegister();
        contactRegister.creator = iDynamicStack;
        contactRegister.primary = true;
        this.contactStacks[shapeType.ordinal()][shapeType2.ordinal()] = contactRegister;
        if (shapeType != shapeType2) {
            ContactRegister contactRegister2 = new ContactRegister();
            contactRegister2.creator = iDynamicStack;
            contactRegister2.primary = false;
            this.contactStacks[shapeType2.ordinal()][shapeType.ordinal()] = contactRegister2;
        }
    }

    private void initializeRegisters() {
        this.addType(this.pool.getCircleContactStack(), ShapeType.CIRCLE, ShapeType.CIRCLE);
        this.addType(this.pool.getPolyCircleContactStack(), ShapeType.POLYGON, ShapeType.CIRCLE);
        this.addType(this.pool.getPolyContactStack(), ShapeType.POLYGON, ShapeType.POLYGON);
        this.addType(this.pool.getEdgeCircleContactStack(), ShapeType.EDGE, ShapeType.CIRCLE);
        this.addType(this.pool.getEdgePolyContactStack(), ShapeType.EDGE, ShapeType.POLYGON);
        this.addType(this.pool.getChainCircleContactStack(), ShapeType.CHAIN, ShapeType.CIRCLE);
        this.addType(this.pool.getChainPolyContactStack(), ShapeType.CHAIN, ShapeType.POLYGON);
    }

    public DestructionListener getDestructionListener() {
        return this.m_destructionListener;
    }

    public ParticleDestructionListener getParticleDestructionListener() {
        return this.m_particleDestructionListener;
    }

    public void setParticleDestructionListener(ParticleDestructionListener particleDestructionListener) {
        this.m_particleDestructionListener = particleDestructionListener;
    }

    public Contact popContact(Fixture fixture, int n, Fixture fixture2, int n2) {
        ShapeType shapeType = fixture.getType();
        ShapeType shapeType2 = fixture2.getType();
        ContactRegister contactRegister = this.contactStacks[shapeType.ordinal()][shapeType2.ordinal()];
        if (contactRegister != null) {
            if (contactRegister.primary) {
                Contact contact = contactRegister.creator.pop();
                contact.init(fixture, n, fixture2, n2);
                return contact;
            }
            Contact contact = contactRegister.creator.pop();
            contact.init(fixture2, n2, fixture, n);
            return contact;
        }
        return null;
    }

    public void pushContact(Contact contact) {
        Fixture fixture = contact.getFixtureA();
        Fixture fixture2 = contact.getFixtureB();
        if (contact.m_manifold.pointCount > 0 && !fixture.isSensor() && !fixture2.isSensor()) {
            fixture.getBody().setAwake(true);
            fixture2.getBody().setAwake(true);
        }
        ShapeType shapeType = fixture.getType();
        ShapeType shapeType2 = fixture2.getType();
        IDynamicStack<Contact> iDynamicStack = this.contactStacks[shapeType.ordinal()][shapeType2.ordinal()].creator;
        iDynamicStack.push(contact);
    }

    public IWorldPool getPool() {
        return this.pool;
    }

    public void setDestructionListener(DestructionListener destructionListener) {
        this.m_destructionListener = destructionListener;
    }

    public void setContactFilter(ContactFilter contactFilter) {
        this.m_contactManager.m_contactFilter = contactFilter;
    }

    public void setContactListener(ContactListener contactListener) {
        this.m_contactManager.m_contactListener = contactListener;
    }

    public void setDebugDraw(DebugDraw debugDraw) {
        this.m_debugDraw = debugDraw;
    }

    public Body createBody(BodyDef bodyDef) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return null;
        }
        Body body = new Body(bodyDef, this);
        body.m_prev = null;
        body.m_next = this.m_bodyList;
        if (this.m_bodyList != null) {
            this.m_bodyList.m_prev = body;
        }
        this.m_bodyList = body;
        ++this.m_bodyCount;
        return body;
    }

    public void destroyBody(Body body) {
        Object object;
        Object object2;
        assert (this.m_bodyCount > 0);
        assert (!this.isLocked());
        if (this.isLocked()) {
            return;
        }
        JointEdge jointEdge = body.m_jointList;
        while (jointEdge != null) {
            object2 = jointEdge;
            jointEdge = jointEdge.next;
            if (this.m_destructionListener != null) {
                this.m_destructionListener.sayGoodbye(((JointEdge)object2).joint);
            }
            this.destroyJoint(((JointEdge)object2).joint);
            body.m_jointList = jointEdge;
        }
        body.m_jointList = null;
        object2 = body.m_contactList;
        while (object2 != null) {
            object = object2;
            object2 = ((ContactEdge)object2).next;
            this.m_contactManager.destroy(((ContactEdge)object).contact);
        }
        body.m_contactList = null;
        object = body.m_fixtureList;
        while (object != null) {
            Object object3 = object;
            object = ((Fixture)object).m_next;
            if (this.m_destructionListener != null) {
                this.m_destructionListener.sayGoodbye((Fixture)object3);
            }
            ((Fixture)object3).destroyProxies(this.m_contactManager.m_broadPhase);
            ((Fixture)object3).destroy();
            body.m_fixtureList = object;
            --body.m_fixtureCount;
        }
        body.m_fixtureList = null;
        body.m_fixtureCount = 0;
        if (body.m_prev != null) {
            body.m_prev.m_next = body.m_next;
        }
        if (body.m_next != null) {
            body.m_next.m_prev = body.m_prev;
        }
        if (body == this.m_bodyList) {
            this.m_bodyList = body.m_next;
        }
        --this.m_bodyCount;
    }

    public Joint createJoint(JointDef jointDef) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return null;
        }
        Joint joint = Joint.create(this, jointDef);
        joint.m_prev = null;
        joint.m_next = this.m_jointList;
        if (this.m_jointList != null) {
            this.m_jointList.m_prev = joint;
        }
        this.m_jointList = joint;
        ++this.m_jointCount;
        joint.m_edgeA.joint = joint;
        joint.m_edgeA.other = joint.getBodyB();
        joint.m_edgeA.prev = null;
        joint.m_edgeA.next = joint.getBodyA().m_jointList;
        if (joint.getBodyA().m_jointList != null) {
            joint.getBodyA().m_jointList.prev = joint.m_edgeA;
        }
        joint.getBodyA().m_jointList = joint.m_edgeA;
        joint.m_edgeB.joint = joint;
        joint.m_edgeB.other = joint.getBodyA();
        joint.m_edgeB.prev = null;
        joint.m_edgeB.next = joint.getBodyB().m_jointList;
        if (joint.getBodyB().m_jointList != null) {
            joint.getBodyB().m_jointList.prev = joint.m_edgeB;
        }
        joint.getBodyB().m_jointList = joint.m_edgeB;
        Body body = jointDef.bodyA;
        Body body2 = jointDef.bodyB;
        if (!jointDef.collideConnected) {
            ContactEdge contactEdge = body2.getContactList();
            while (contactEdge != null) {
                if (contactEdge.other == body) {
                    contactEdge.contact.flagForFiltering();
                }
                contactEdge = contactEdge.next;
            }
        }
        return joint;
    }

    public void destroyJoint(Joint joint) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return;
        }
        boolean bl = joint.getCollideConnected();
        if (joint.m_prev != null) {
            joint.m_prev.m_next = joint.m_next;
        }
        if (joint.m_next != null) {
            joint.m_next.m_prev = joint.m_prev;
        }
        if (joint == this.m_jointList) {
            this.m_jointList = joint.m_next;
        }
        Body body = joint.getBodyA();
        Body body2 = joint.getBodyB();
        body.setAwake(true);
        body2.setAwake(true);
        if (joint.m_edgeA.prev != null) {
            joint.m_edgeA.prev.next = joint.m_edgeA.next;
        }
        if (joint.m_edgeA.next != null) {
            joint.m_edgeA.next.prev = joint.m_edgeA.prev;
        }
        if (joint.m_edgeA == body.m_jointList) {
            body.m_jointList = joint.m_edgeA.next;
        }
        joint.m_edgeA.prev = null;
        joint.m_edgeA.next = null;
        if (joint.m_edgeB.prev != null) {
            joint.m_edgeB.prev.next = joint.m_edgeB.next;
        }
        if (joint.m_edgeB.next != null) {
            joint.m_edgeB.next.prev = joint.m_edgeB.prev;
        }
        if (joint.m_edgeB == body2.m_jointList) {
            body2.m_jointList = joint.m_edgeB.next;
        }
        joint.m_edgeB.prev = null;
        joint.m_edgeB.next = null;
        Joint.destroy(joint);
        assert (this.m_jointCount > 0);
        --this.m_jointCount;
        if (!bl) {
            ContactEdge contactEdge = body2.getContactList();
            while (contactEdge != null) {
                if (contactEdge.other == body) {
                    contactEdge.contact.flagForFiltering();
                }
                contactEdge = contactEdge.next;
            }
        }
    }

    public void step(float f, int n, int n2) {
        this.stepTimer.reset();
        this.tempTimer.reset();
        if ((this.m_flags & 1) == 1) {
            this.m_contactManager.findNewContacts();
            this.m_flags &= 0xFFFFFFFE;
        }
        this.m_flags |= 2;
        this.step.dt = f;
        this.step.velocityIterations = n;
        this.step.positionIterations = n2;
        this.step.inv_dt = f > 0.0f ? 1.0f / f : 0.0f;
        this.step.dtRatio = this.m_inv_dt0 * f;
        this.step.warmStarting = this.m_warmStarting;
        this.m_profile.stepInit.record(this.tempTimer.getMilliseconds());
        this.tempTimer.reset();
        this.m_contactManager.collide();
        this.m_profile.collide.record(this.tempTimer.getMilliseconds());
        if (this.m_stepComplete && this.step.dt > 0.0f) {
            this.tempTimer.reset();
            this.m_particleSystem.solve(this.step);
            this.m_profile.solveParticleSystem.record(this.tempTimer.getMilliseconds());
            this.tempTimer.reset();
            this.solve(this.step);
            this.m_profile.solve.record(this.tempTimer.getMilliseconds());
        }
        if (this.m_continuousPhysics && this.step.dt > 0.0f) {
            this.tempTimer.reset();
            this.solveTOI(this.step);
            this.m_profile.solveTOI.record(this.tempTimer.getMilliseconds());
        }
        if (this.step.dt > 0.0f) {
            this.m_inv_dt0 = this.step.inv_dt;
        }
        if ((this.m_flags & 4) == 4) {
            this.clearForces();
        }
        this.m_flags &= 0xFFFFFFFD;
        this.m_profile.step.record(this.stepTimer.getMilliseconds());
    }

    public void clearForces() {
        Body body = this.m_bodyList;
        while (body != null) {
            body.m_force.setZero();
            body.m_torque = 0.0f;
            body = body.getNext();
        }
    }

    public void drawDebugData() {
        Fixture fixture;
        Object object;
        boolean bl;
        if (this.m_debugDraw == null) {
            return;
        }
        int n = this.m_debugDraw.getFlags();
        boolean bl2 = bl = (n & 0x80) != 0;
        if ((n & 2) != 0) {
            object = this.m_bodyList;
            while (object != null) {
                this.xf.set(((Body)object).getTransform());
                fixture = ((Body)object).getFixtureList();
                while (fixture != null) {
                    if (!((Body)object).isActive()) {
                        this.color.set(0.5f, 0.5f, 0.3f);
                        this.drawShape(fixture, this.xf, this.color, bl);
                    } else if (((Body)object).getType() == BodyType.STATIC) {
                        this.color.set(0.5f, 0.9f, 0.3f);
                        this.drawShape(fixture, this.xf, this.color, bl);
                    } else if (((Body)object).getType() == BodyType.KINEMATIC) {
                        this.color.set(0.5f, 0.5f, 0.9f);
                        this.drawShape(fixture, this.xf, this.color, bl);
                    } else if (!((Body)object).isAwake()) {
                        this.color.set(0.5f, 0.5f, 0.5f);
                        this.drawShape(fixture, this.xf, this.color, bl);
                    } else {
                        this.color.set(0.9f, 0.7f, 0.7f);
                        this.drawShape(fixture, this.xf, this.color, bl);
                    }
                    fixture = fixture.getNext();
                }
                object = ((Body)object).getNext();
            }
            this.drawParticleSystem(this.m_particleSystem);
        }
        if ((n & 4) != 0) {
            object = this.m_jointList;
            while (object != null) {
                this.drawJoint((Joint)object);
                object = ((Joint)object).getNext();
            }
        }
        if ((n & 0x10) != 0) {
            this.color.set(0.3f, 0.9f, 0.9f);
            object = this.m_contactManager.m_contactList;
            while (object != null) {
                fixture = ((Contact)object).getFixtureA();
                Fixture fixture2 = ((Contact)object).getFixtureB();
                fixture.getAABB(((Contact)object).getChildIndexA()).getCenterToOut(this.cA);
                fixture2.getAABB(((Contact)object).getChildIndexB()).getCenterToOut(this.cB);
                this.m_debugDraw.drawSegment(this.cA, this.cB, this.color);
                object = ((Contact)object).getNext();
            }
        }
        if ((n & 8) != 0) {
            this.color.set(0.9f, 0.3f, 0.9f);
            object = this.m_bodyList;
            while (object != null) {
                if (((Body)object).isActive()) {
                    fixture = ((Body)object).getFixtureList();
                    while (fixture != null) {
                        int n2 = 0;
                        while (n2 < fixture.m_proxyCount) {
                            FixtureProxy fixtureProxy = fixture.m_proxies[n2];
                            AABB aABB = this.m_contactManager.m_broadPhase.getFatAABB(fixtureProxy.proxyId);
                            if (aABB != null) {
                                Vec2[] vec2Array = this.avs.get(4);
                                vec2Array[0].set(aABB.lowerBound.x, aABB.lowerBound.y);
                                vec2Array[1].set(aABB.upperBound.x, aABB.lowerBound.y);
                                vec2Array[2].set(aABB.upperBound.x, aABB.upperBound.y);
                                vec2Array[3].set(aABB.lowerBound.x, aABB.upperBound.y);
                                this.m_debugDraw.drawPolygon(vec2Array, 4, this.color);
                            }
                            ++n2;
                        }
                        fixture = fixture.getNext();
                    }
                }
                object = ((Body)object).getNext();
            }
        }
        if ((n & 0x20) != 0) {
            object = this.m_bodyList;
            while (object != null) {
                this.xf.set(((Body)object).getTransform());
                this.xf.p.set(((Body)object).getWorldCenter());
                this.m_debugDraw.drawTransform(this.xf);
                object = ((Body)object).getNext();
            }
        }
        if ((n & 0x40) != 0) {
            this.m_contactManager.m_broadPhase.drawTree(this.m_debugDraw);
        }
        this.m_debugDraw.flush();
    }

    public void queryAABB(QueryCallback queryCallback, AABB aABB) {
        this.wqwrapper.broadPhase = this.m_contactManager.m_broadPhase;
        this.wqwrapper.callback = queryCallback;
        this.m_contactManager.m_broadPhase.query(this.wqwrapper, aABB);
    }

    public void queryAABB(QueryCallback queryCallback, ParticleQueryCallback particleQueryCallback, AABB aABB) {
        this.wqwrapper.broadPhase = this.m_contactManager.m_broadPhase;
        this.wqwrapper.callback = queryCallback;
        this.m_contactManager.m_broadPhase.query(this.wqwrapper, aABB);
        this.m_particleSystem.queryAABB(particleQueryCallback, aABB);
    }

    public void queryAABB(ParticleQueryCallback particleQueryCallback, AABB aABB) {
        this.m_particleSystem.queryAABB(particleQueryCallback, aABB);
    }

    public void raycast(RayCastCallback rayCastCallback, Vec2 vec2, Vec2 vec22) {
        this.wrcwrapper.broadPhase = this.m_contactManager.m_broadPhase;
        this.wrcwrapper.callback = rayCastCallback;
        this.input.maxFraction = 1.0f;
        this.input.p1.set(vec2);
        this.input.p2.set(vec22);
        this.m_contactManager.m_broadPhase.raycast(this.wrcwrapper, this.input);
    }

    public void raycast(RayCastCallback rayCastCallback, ParticleRaycastCallback particleRaycastCallback, Vec2 vec2, Vec2 vec22) {
        this.wrcwrapper.broadPhase = this.m_contactManager.m_broadPhase;
        this.wrcwrapper.callback = rayCastCallback;
        this.input.maxFraction = 1.0f;
        this.input.p1.set(vec2);
        this.input.p2.set(vec22);
        this.m_contactManager.m_broadPhase.raycast(this.wrcwrapper, this.input);
        this.m_particleSystem.raycast(particleRaycastCallback, vec2, vec22);
    }

    public void raycast(ParticleRaycastCallback particleRaycastCallback, Vec2 vec2, Vec2 vec22) {
        this.m_particleSystem.raycast(particleRaycastCallback, vec2, vec22);
    }

    public Body getBodyList() {
        return this.m_bodyList;
    }

    public Joint getJointList() {
        return this.m_jointList;
    }

    public Contact getContactList() {
        return this.m_contactManager.m_contactList;
    }

    public boolean isSleepingAllowed() {
        return this.m_allowSleep;
    }

    public void setSleepingAllowed(boolean bl) {
        this.m_allowSleep = bl;
    }

    public void setWarmStarting(boolean bl) {
        this.m_warmStarting = bl;
    }

    public boolean isWarmStarting() {
        return this.m_warmStarting;
    }

    public void setContinuousPhysics(boolean bl) {
        this.m_continuousPhysics = bl;
    }

    public boolean isContinuousPhysics() {
        return this.m_continuousPhysics;
    }

    public int getProxyCount() {
        return this.m_contactManager.m_broadPhase.getProxyCount();
    }

    public int getBodyCount() {
        return this.m_bodyCount;
    }

    public int getJointCount() {
        return this.m_jointCount;
    }

    public int getContactCount() {
        return this.m_contactManager.m_contactCount;
    }

    public int getTreeHeight() {
        return this.m_contactManager.m_broadPhase.getTreeHeight();
    }

    public int getTreeBalance() {
        return this.m_contactManager.m_broadPhase.getTreeBalance();
    }

    public float getTreeQuality() {
        return this.m_contactManager.m_broadPhase.getTreeQuality();
    }

    public void setGravity(Vec2 vec2) {
        this.m_gravity.set(vec2);
    }

    public Vec2 getGravity() {
        return this.m_gravity;
    }

    public boolean isLocked() {
        return (this.m_flags & 2) == 2;
    }

    public void setAutoClearForces(boolean bl) {
        this.m_flags = bl ? (this.m_flags |= 4) : (this.m_flags &= 0xFFFFFFFB);
    }

    public boolean getAutoClearForces() {
        return (this.m_flags & 4) == 4;
    }

    public ContactManager getContactManager() {
        return this.m_contactManager;
    }

    public Profile getProfile() {
        return this.m_profile;
    }

    private void solve(TimeStep timeStep) {
        this.m_profile.solveInit.startAccum();
        this.m_profile.solveVelocity.startAccum();
        this.m_profile.solvePosition.startAccum();
        Object object = this.m_bodyList;
        while (object != null) {
            ((Body)object).m_xf0.set(((Body)object).m_xf);
            object = ((Body)object).m_next;
        }
        this.island.init(this.m_bodyCount, this.m_contactManager.m_contactCount, this.m_jointCount, this.m_contactManager.m_contactListener);
        object = this.m_bodyList;
        while (object != null) {
            ((Body)object).m_flags &= 0xFFFFFFFE;
            object = ((Body)object).m_next;
        }
        object = this.m_contactManager.m_contactList;
        while (object != null) {
            ((Contact)object).m_flags &= 0xFFFFFFFE;
            object = ((Contact)object).m_next;
        }
        object = this.m_jointList;
        while (object != null) {
            ((Joint)object).m_islandFlag = false;
            object = ((Joint)object).m_next;
        }
        int n = this.m_bodyCount;
        if (this.stack.length < n) {
            this.stack = new Body[n];
        }
        Body body = this.m_bodyList;
        while (body != null) {
            if ((body.m_flags & 1) != 1 && body.isAwake() && body.isActive() && body.getType() != BodyType.STATIC) {
                Object object2;
                this.island.clear();
                int n2 = 0;
                this.stack[n2++] = body;
                body.m_flags |= 1;
                while (n2 > 0) {
                    Object object3;
                    Body body2 = this.stack[--n2];
                    assert (body2.isActive());
                    this.island.add(body2);
                    body2.setAwake(true);
                    if (body2.getType() == BodyType.STATIC) continue;
                    object2 = body2.m_contactList;
                    while (object2 != null) {
                        object3 = ((ContactEdge)object2).contact;
                        if ((((Contact)object3).m_flags & 1) != 1 && ((Contact)object3).isEnabled() && ((Contact)object3).isTouching()) {
                            boolean bl = ((Contact)object3).m_fixtureA.m_isSensor;
                            boolean bl2 = ((Contact)object3).m_fixtureB.m_isSensor;
                            if (!bl && !bl2) {
                                this.island.add((Contact)object3);
                                ((Contact)object3).m_flags |= 1;
                                Body body3 = ((ContactEdge)object2).other;
                                if ((body3.m_flags & 1) != 1) {
                                    assert (n2 < n);
                                    this.stack[n2++] = body3;
                                    body3.m_flags |= 1;
                                }
                            }
                        }
                        object2 = ((ContactEdge)object2).next;
                    }
                    object2 = body2.m_jointList;
                    while (object2 != null) {
                        if (!((JointEdge)object2).joint.m_islandFlag && ((Body)(object3 = ((JointEdge)object2).other)).isActive()) {
                            this.island.add(((JointEdge)object2).joint);
                            ((JointEdge)object2).joint.m_islandFlag = true;
                            if ((((Body)object3).m_flags & 1) != 1) {
                                assert (n2 < n);
                                this.stack[n2++] = object3;
                                ((Body)object3).m_flags |= 1;
                            }
                        }
                        object2 = ((JointEdge)object2).next;
                    }
                }
                this.island.solve(this.m_profile, timeStep, this.m_gravity, this.m_allowSleep);
                int n3 = 0;
                while (n3 < this.island.m_bodyCount) {
                    object2 = this.island.m_bodies[n3];
                    if (((Body)object2).getType() == BodyType.STATIC) {
                        ((Body)object2).m_flags &= 0xFFFFFFFE;
                    }
                    ++n3;
                }
            }
            body = body.m_next;
        }
        this.m_profile.solveInit.endAccum();
        this.m_profile.solveVelocity.endAccum();
        this.m_profile.solvePosition.endAccum();
        this.broadphaseTimer.reset();
        body = this.m_bodyList;
        while (body != null) {
            if ((body.m_flags & 1) != 0 && body.getType() != BodyType.STATIC) {
                body.synchronizeFixtures();
            }
            body = body.getNext();
        }
        this.m_contactManager.findNewContacts();
        this.m_profile.broadphase.record(this.broadphaseTimer.getMilliseconds());
    }

    private void solveTOI(TimeStep timeStep) {
        block33: {
            Object object;
            Island island = this.toiIsland;
            island.init(2 * Settings.maxTOIContacts, Settings.maxTOIContacts, 0, this.m_contactManager.m_contactListener);
            if (this.m_stepComplete) {
                object = this.m_bodyList;
                while (object != null) {
                    ((Body)object).m_flags &= 0xFFFFFFFE;
                    ((Body)object).m_sweep.alpha0 = 0.0f;
                    object = ((Body)object).m_next;
                }
                object = this.m_contactManager.m_contactList;
                while (object != null) {
                    ((Contact)object).m_flags &= 0xFFFFFFDE;
                    ((Contact)object).m_toiCount = 0.0f;
                    ((Contact)object).m_toi = 1.0f;
                    object = ((Contact)object).m_next;
                }
            }
            while (true) {
                boolean bl;
                boolean bl2;
                Object object2;
                Object object3;
                Body body;
                Object object4;
                Object object5;
                object = null;
                float f = 1.0f;
                Object object6 = this.m_contactManager.m_contactList;
                while (object6 != null) {
                    block34: {
                        float f2;
                        block36: {
                            boolean bl3;
                            block35: {
                                if (!((Contact)object6).isEnabled() || ((Contact)object6).m_toiCount > (float)Settings.maxSubSteps) break block34;
                                f2 = 1.0f;
                                if ((((Contact)object6).m_flags & 0x20) == 0) break block35;
                                f2 = ((Contact)object6).m_toi;
                                break block36;
                            }
                            object5 = ((Contact)object6).getFixtureA();
                            object4 = ((Contact)object6).getFixtureB();
                            if (((Fixture)object5).isSensor() || ((Fixture)object4).isSensor()) break block34;
                            Body body2 = ((Fixture)object5).getBody();
                            body = ((Fixture)object4).getBody();
                            object3 = body2.m_type;
                            object2 = body.m_type;
                            assert (object3 == BodyType.DYNAMIC || object2 == BodyType.DYNAMIC);
                            boolean bl4 = body2.isAwake() && object3 != BodyType.STATIC;
                            boolean bl5 = bl2 = body.isAwake() && object2 != BodyType.STATIC;
                            if (!bl4 && !bl2) break block34;
                            bl = body2.isBullet() || object3 != BodyType.DYNAMIC;
                            boolean bl6 = bl3 = body.isBullet() || object2 != BodyType.DYNAMIC;
                            if (!bl && !bl3) break block34;
                            float f3 = body2.m_sweep.alpha0;
                            if (body2.m_sweep.alpha0 < body.m_sweep.alpha0) {
                                f3 = body.m_sweep.alpha0;
                                body2.m_sweep.advance(f3);
                            } else if (body.m_sweep.alpha0 < body2.m_sweep.alpha0) {
                                f3 = body2.m_sweep.alpha0;
                                body.m_sweep.advance(f3);
                            }
                            assert (f3 < 1.0f);
                            int n = ((Contact)object6).getChildIndexA();
                            int n2 = ((Contact)object6).getChildIndexB();
                            TimeOfImpact.TOIInput tOIInput = this.toiInput;
                            tOIInput.proxyA.set(((Fixture)object5).getShape(), n);
                            tOIInput.proxyB.set(((Fixture)object4).getShape(), n2);
                            tOIInput.sweepA.set(body2.m_sweep);
                            tOIInput.sweepB.set(body.m_sweep);
                            tOIInput.tMax = 1.0f;
                            this.pool.getTimeOfImpact().timeOfImpact(this.toiOutput, tOIInput);
                            float f4 = this.toiOutput.t;
                            f2 = this.toiOutput.state == TimeOfImpact.TOIOutputState.TOUCHING ? MathUtils.min(f3 + (1.0f - f3) * f4, 1.0f) : 1.0f;
                            ((Contact)object6).m_toi = f2;
                            ((Contact)object6).m_flags |= 0x20;
                        }
                        if (f2 < f) {
                            object = object6;
                            f = f2;
                        }
                    }
                    object6 = ((Contact)object6).m_next;
                }
                if (object == null || 0.9999988f < f) {
                    this.m_stepComplete = true;
                    break block33;
                }
                object6 = ((Contact)object).getFixtureA();
                Fixture fixture = ((Contact)object).getFixtureB();
                object5 = ((Fixture)object6).getBody();
                object4 = fixture.getBody();
                this.backup1.set(((Body)object5).m_sweep);
                this.backup2.set(((Body)object4).m_sweep);
                ((Body)object5).advance(f);
                ((Body)object4).advance(f);
                ((Contact)object).update(this.m_contactManager.m_contactListener);
                ((Contact)object).m_flags &= 0xFFFFFFDF;
                ((Contact)object).m_toiCount += 1.0f;
                if (!((Contact)object).isEnabled() || !((Contact)object).isTouching()) {
                    ((Contact)object).setEnabled(false);
                    ((Body)object5).m_sweep.set(this.backup1);
                    ((Body)object4).m_sweep.set(this.backup2);
                    ((Body)object5).synchronizeTransform();
                    ((Body)object4).synchronizeTransform();
                    continue;
                }
                ((Body)object5).setAwake(true);
                ((Body)object4).setAwake(true);
                island.clear();
                island.add((Body)object5);
                island.add((Body)object4);
                island.add((Contact)object);
                ((Body)object5).m_flags |= 1;
                ((Body)object4).m_flags |= 1;
                ((Contact)object).m_flags |= 1;
                this.tempBodies[0] = object5;
                this.tempBodies[1] = object4;
                int n = 0;
                while (n < 2) {
                    body = this.tempBodies[n];
                    if (body.m_type == BodyType.DYNAMIC) {
                        object3 = body.m_contactList;
                        while (object3 != null) {
                            if (island.m_bodyCount == island.m_bodyCapacity || island.m_contactCount == island.m_contactCapacity) break;
                            object2 = ((ContactEdge)object3).contact;
                            if ((((Contact)object2).m_flags & 1) == 0) {
                                Body body3 = ((ContactEdge)object3).other;
                                if (body3.m_type != BodyType.DYNAMIC || body.isBullet() || body3.isBullet()) {
                                    bl2 = ((Contact)object2).m_fixtureA.m_isSensor;
                                    bl = ((Contact)object2).m_fixtureB.m_isSensor;
                                    if (!bl2 && !bl) {
                                        this.backup1.set(body3.m_sweep);
                                        if ((body3.m_flags & 1) == 0) {
                                            body3.advance(f);
                                        }
                                        ((Contact)object2).update(this.m_contactManager.m_contactListener);
                                        if (!((Contact)object2).isEnabled()) {
                                            body3.m_sweep.set(this.backup1);
                                            body3.synchronizeTransform();
                                        } else if (!((Contact)object2).isTouching()) {
                                            body3.m_sweep.set(this.backup1);
                                            body3.synchronizeTransform();
                                        } else {
                                            ((Contact)object2).m_flags |= 1;
                                            island.add((Contact)object2);
                                            if ((body3.m_flags & 1) == 0) {
                                                body3.m_flags |= 1;
                                                if (body3.m_type != BodyType.STATIC) {
                                                    body3.setAwake(true);
                                                }
                                                island.add(body3);
                                            }
                                        }
                                    }
                                }
                            }
                            object3 = ((ContactEdge)object3).next;
                        }
                    }
                    ++n;
                }
                this.subStep.dt = (1.0f - f) * timeStep.dt;
                this.subStep.inv_dt = 1.0f / this.subStep.dt;
                this.subStep.dtRatio = 1.0f;
                this.subStep.positionIterations = 20;
                this.subStep.velocityIterations = timeStep.velocityIterations;
                this.subStep.warmStarting = false;
                island.solveTOI(this.subStep, ((Body)object5).m_islandIndex, ((Body)object4).m_islandIndex);
                n = 0;
                while (n < island.m_bodyCount) {
                    body = island.m_bodies[n];
                    body.m_flags &= 0xFFFFFFFE;
                    if (body.m_type == BodyType.DYNAMIC) {
                        body.synchronizeFixtures();
                        object3 = body.m_contactList;
                        while (object3 != null) {
                            ((ContactEdge)object3).contact.m_flags &= 0xFFFFFFDE;
                            object3 = ((ContactEdge)object3).next;
                        }
                    }
                    ++n;
                }
                this.m_contactManager.findNewContacts();
                if (this.m_subStepping) break;
            }
            this.m_stepComplete = false;
        }
    }

    private void drawJoint(Joint joint) {
        Body body = joint.getBodyA();
        Body body2 = joint.getBodyB();
        Transform transform = body.getTransform();
        Transform transform2 = body2.getTransform();
        Vec2 vec2 = transform.p;
        Vec2 vec22 = transform2.p;
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        joint.getAnchorA(vec23);
        joint.getAnchorB(vec24);
        this.color.set(0.5f, 0.8f, 0.8f);
        switch (joint.getType()) {
            case DISTANCE: {
                this.m_debugDraw.drawSegment(vec23, vec24, this.color);
                break;
            }
            case PULLEY: {
                PulleyJoint pulleyJoint = (PulleyJoint)joint;
                Vec2 vec25 = pulleyJoint.getGroundAnchorA();
                Vec2 vec26 = pulleyJoint.getGroundAnchorB();
                this.m_debugDraw.drawSegment(vec25, vec23, this.color);
                this.m_debugDraw.drawSegment(vec26, vec24, this.color);
                this.m_debugDraw.drawSegment(vec25, vec26, this.color);
                break;
            }
            case MOUSE: 
            case CONSTANT_VOLUME: {
                break;
            }
            default: {
                this.m_debugDraw.drawSegment(vec2, vec23, this.color);
                this.m_debugDraw.drawSegment(vec23, vec24, this.color);
                this.m_debugDraw.drawSegment(vec22, vec24, this.color);
            }
        }
        this.pool.pushVec2(2);
    }

    private void drawShape(Fixture fixture, Transform transform, Color3f color3f, boolean bl) {
        switch (fixture.getType()) {
            case CIRCLE: {
                CircleShape circleShape = (CircleShape)fixture.getShape();
                Transform.mulToOutUnsafe(transform, circleShape.m_p, this.center);
                float f = circleShape.m_radius;
                transform.q.getXAxis(this.axis);
                if (fixture.getUserData() != null && fixture.getUserData().equals(LIQUID_INT)) {
                    Body body = fixture.getBody();
                    this.liquidOffset.set(body.m_linearVelocity);
                    float f2 = body.m_linearVelocity.length();
                    this.averageLinearVel = this.averageLinearVel == -1.0f ? f2 : 0.98f * this.averageLinearVel + 0.02f * f2;
                    this.liquidOffset.mulLocal(this.liquidLength / this.averageLinearVel / 2.0f);
                    this.circCenterMoved.set(this.center).addLocal(this.liquidOffset);
                    this.center.subLocal(this.liquidOffset);
                    this.m_debugDraw.drawSegment(this.center, this.circCenterMoved, this.liquidColor);
                    return;
                }
                if (bl) {
                    this.m_debugDraw.drawCircle(this.center, f, this.axis, color3f);
                    break;
                }
                this.m_debugDraw.drawSolidCircle(this.center, f, this.axis, color3f);
                break;
            }
            case POLYGON: {
                PolygonShape polygonShape = (PolygonShape)fixture.getShape();
                int n = polygonShape.m_count;
                assert (n <= Settings.maxPolygonVertices);
                Vec2[] vec2Array = this.tlvertices.get(Settings.maxPolygonVertices);
                int n2 = 0;
                while (n2 < n) {
                    Transform.mulToOutUnsafe(transform, polygonShape.m_vertices[n2], vec2Array[n2]);
                    ++n2;
                }
                if (bl) {
                    this.m_debugDraw.drawPolygon(vec2Array, n, color3f);
                    break;
                }
                this.m_debugDraw.drawSolidPolygon(vec2Array, n, color3f);
                break;
            }
            case EDGE: {
                EdgeShape edgeShape = (EdgeShape)fixture.getShape();
                Transform.mulToOutUnsafe(transform, edgeShape.m_vertex1, this.v1);
                Transform.mulToOutUnsafe(transform, edgeShape.m_vertex2, this.v2);
                this.m_debugDraw.drawSegment(this.v1, this.v2, color3f);
                break;
            }
            case CHAIN: {
                ChainShape chainShape = (ChainShape)fixture.getShape();
                int n = chainShape.m_count;
                Vec2[] vec2Array = chainShape.m_vertices;
                Transform.mulToOutUnsafe(transform, vec2Array[0], this.v1);
                int n3 = 1;
                while (n3 < n) {
                    Transform.mulToOutUnsafe(transform, vec2Array[n3], this.v2);
                    this.m_debugDraw.drawSegment(this.v1, this.v2, color3f);
                    this.m_debugDraw.drawCircle(this.v1, 0.05f, color3f);
                    this.v1.set(this.v2);
                    ++n3;
                }
                break;
            }
        }
    }

    private void drawParticleSystem(ParticleSystem particleSystem) {
        boolean bl = (this.m_debugDraw.getFlags() & 0x80) != 0;
        int n = particleSystem.getParticleCount();
        if (n != 0) {
            float f = particleSystem.getParticleRadius();
            Vec2[] vec2Array = particleSystem.getParticlePositionBuffer();
            ParticleColor[] particleColorArray = null;
            if (particleSystem.m_colorBuffer.data != null) {
                particleColorArray = particleSystem.getParticleColorBuffer();
            }
            if (bl) {
                this.m_debugDraw.drawParticlesWireframe(vec2Array, f, particleColorArray, n);
            } else {
                this.m_debugDraw.drawParticles(vec2Array, f, particleColorArray, n);
            }
        }
    }

    public int createParticle(ParticleDef particleDef) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return 0;
        }
        int n = this.m_particleSystem.createParticle(particleDef);
        return n;
    }

    public void destroyParticle(int n) {
        this.destroyParticle(n, false);
    }

    public void destroyParticle(int n, boolean bl) {
        this.m_particleSystem.destroyParticle(n, bl);
    }

    public int destroyParticlesInShape(Shape shape, Transform transform) {
        return this.destroyParticlesInShape(shape, transform, false);
    }

    public int destroyParticlesInShape(Shape shape, Transform transform, boolean bl) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return 0;
        }
        return this.m_particleSystem.destroyParticlesInShape(shape, transform, bl);
    }

    public ParticleGroup createParticleGroup(ParticleGroupDef particleGroupDef) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return null;
        }
        ParticleGroup particleGroup = this.m_particleSystem.createParticleGroup(particleGroupDef);
        return particleGroup;
    }

    public void joinParticleGroups(ParticleGroup particleGroup, ParticleGroup particleGroup2) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return;
        }
        this.m_particleSystem.joinParticleGroups(particleGroup, particleGroup2);
    }

    public void destroyParticlesInGroup(ParticleGroup particleGroup, boolean bl) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return;
        }
        this.m_particleSystem.destroyParticlesInGroup(particleGroup, bl);
    }

    public void destroyParticlesInGroup(ParticleGroup particleGroup) {
        this.destroyParticlesInGroup(particleGroup, false);
    }

    public ParticleGroup[] getParticleGroupList() {
        return this.m_particleSystem.getParticleGroupList();
    }

    public int getParticleGroupCount() {
        return this.m_particleSystem.getParticleGroupCount();
    }

    public int getParticleCount() {
        return this.m_particleSystem.getParticleCount();
    }

    public int getParticleMaxCount() {
        return this.m_particleSystem.getParticleMaxCount();
    }

    public void setParticleMaxCount(int n) {
        this.m_particleSystem.setParticleMaxCount(n);
    }

    public void setParticleDensity(float f) {
        this.m_particleSystem.setParticleDensity(f);
    }

    public float getParticleDensity() {
        return this.m_particleSystem.getParticleDensity();
    }

    public void setParticleGravityScale(float f) {
        this.m_particleSystem.setParticleGravityScale(f);
    }

    public float getParticleGravityScale() {
        return this.m_particleSystem.getParticleGravityScale();
    }

    public void setParticleDamping(float f) {
        this.m_particleSystem.setParticleDamping(f);
    }

    public float getParticleDamping() {
        return this.m_particleSystem.getParticleDamping();
    }

    public void setParticleRadius(float f) {
        this.m_particleSystem.setParticleRadius(f);
    }

    public float getParticleRadius() {
        return this.m_particleSystem.getParticleRadius();
    }

    public int[] getParticleFlagsBuffer() {
        return this.m_particleSystem.getParticleFlagsBuffer();
    }

    public Vec2[] getParticlePositionBuffer() {
        return this.m_particleSystem.getParticlePositionBuffer();
    }

    public Vec2[] getParticleVelocityBuffer() {
        return this.m_particleSystem.getParticleVelocityBuffer();
    }

    public ParticleColor[] getParticleColorBuffer() {
        return this.m_particleSystem.getParticleColorBuffer();
    }

    public ParticleGroup[] getParticleGroupBuffer() {
        return this.m_particleSystem.getParticleGroupBuffer();
    }

    public Object[] getParticleUserDataBuffer() {
        return this.m_particleSystem.getParticleUserDataBuffer();
    }

    public void setParticleFlagsBuffer(int[] nArray, int n) {
        this.m_particleSystem.setParticleFlagsBuffer(nArray, n);
    }

    public void setParticlePositionBuffer(Vec2[] vec2Array, int n) {
        this.m_particleSystem.setParticlePositionBuffer(vec2Array, n);
    }

    public void setParticleVelocityBuffer(Vec2[] vec2Array, int n) {
        this.m_particleSystem.setParticleVelocityBuffer(vec2Array, n);
    }

    public void setParticleColorBuffer(ParticleColor[] particleColorArray, int n) {
        this.m_particleSystem.setParticleColorBuffer(particleColorArray, n);
    }

    public void setParticleUserDataBuffer(Object[] objectArray, int n) {
        this.m_particleSystem.setParticleUserDataBuffer(objectArray, n);
    }

    public ParticleContact[] getParticleContacts() {
        return this.m_particleSystem.m_contactBuffer;
    }

    public int getParticleContactCount() {
        return this.m_particleSystem.m_contactCount;
    }

    public ParticleBodyContact[] getParticleBodyContacts() {
        return this.m_particleSystem.m_bodyContactBuffer;
    }

    public int getParticleBodyContactCount() {
        return this.m_particleSystem.m_bodyContactCount;
    }

    public float computeParticleCollisionEnergy() {
        return this.m_particleSystem.computeParticleCollisionEnergy();
    }
}

