/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.WorldManifold;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Transform;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.pooling.IWorldPool;

public abstract class Contact {
    public static final int ISLAND_FLAG = 1;
    public static final int TOUCHING_FLAG = 2;
    public static final int ENABLED_FLAG = 4;
    public static final int FILTER_FLAG = 8;
    public static final int BULLET_HIT_FLAG = 16;
    public static final int TOI_FLAG = 32;
    public int m_flags;
    public Contact m_prev;
    public Contact m_next;
    public ContactEdge m_nodeA = null;
    public ContactEdge m_nodeB = null;
    public Fixture m_fixtureA = null;
    public Fixture m_fixtureB = null;
    public int m_indexA;
    public int m_indexB;
    public final Manifold m_manifold;
    public float m_toiCount;
    public float m_toi;
    public float m_friction;
    public float m_restitution;
    public float m_tangentSpeed;
    protected final IWorldPool pool;
    private final Manifold oldManifold = new Manifold();

    protected Contact(IWorldPool iWorldPool) {
        this.m_nodeA = new ContactEdge();
        this.m_nodeB = new ContactEdge();
        this.m_manifold = new Manifold();
        this.pool = iWorldPool;
    }

    public void init(Fixture fixture, int n, Fixture fixture2, int n2) {
        this.m_flags = 4;
        this.m_fixtureA = fixture;
        this.m_fixtureB = fixture2;
        this.m_indexA = n;
        this.m_indexB = n2;
        this.m_manifold.pointCount = 0;
        this.m_prev = null;
        this.m_next = null;
        this.m_nodeA.contact = null;
        this.m_nodeA.prev = null;
        this.m_nodeA.next = null;
        this.m_nodeA.other = null;
        this.m_nodeB.contact = null;
        this.m_nodeB.prev = null;
        this.m_nodeB.next = null;
        this.m_nodeB.other = null;
        this.m_toiCount = 0.0f;
        this.m_friction = Contact.mixFriction(fixture.m_friction, fixture2.m_friction);
        this.m_restitution = Contact.mixRestitution(fixture.m_restitution, fixture2.m_restitution);
        this.m_tangentSpeed = 0.0f;
    }

    public Manifold getManifold() {
        return this.m_manifold;
    }

    public void getWorldManifold(WorldManifold worldManifold) {
        Body body = this.m_fixtureA.getBody();
        Body body2 = this.m_fixtureB.getBody();
        Shape shape = this.m_fixtureA.getShape();
        Shape shape2 = this.m_fixtureB.getShape();
        worldManifold.initialize(this.m_manifold, body.getTransform(), shape.m_radius, body2.getTransform(), shape2.m_radius);
    }

    public boolean isTouching() {
        return (this.m_flags & 2) == 2;
    }

    public void setEnabled(boolean bl) {
        this.m_flags = bl ? (this.m_flags |= 4) : (this.m_flags &= 0xFFFFFFFB);
    }

    public boolean isEnabled() {
        return (this.m_flags & 4) == 4;
    }

    public Contact getNext() {
        return this.m_next;
    }

    public Fixture getFixtureA() {
        return this.m_fixtureA;
    }

    public int getChildIndexA() {
        return this.m_indexA;
    }

    public Fixture getFixtureB() {
        return this.m_fixtureB;
    }

    public int getChildIndexB() {
        return this.m_indexB;
    }

    public void setFriction(float f) {
        this.m_friction = f;
    }

    public float getFriction() {
        return this.m_friction;
    }

    public void resetFriction() {
        this.m_friction = Contact.mixFriction(this.m_fixtureA.m_friction, this.m_fixtureB.m_friction);
    }

    public void setRestitution(float f) {
        this.m_restitution = f;
    }

    public float getRestitution() {
        return this.m_restitution;
    }

    public void resetRestitution() {
        this.m_restitution = Contact.mixRestitution(this.m_fixtureA.m_restitution, this.m_fixtureB.m_restitution);
    }

    public void setTangentSpeed(float f) {
        this.m_tangentSpeed = f;
    }

    public float getTangentSpeed() {
        return this.m_tangentSpeed;
    }

    public abstract void evaluate(Manifold var1, Transform var2, Transform var3);

    public void flagForFiltering() {
        this.m_flags |= 8;
    }

    public void update(ContactListener contactListener) {
        this.oldManifold.set(this.m_manifold);
        this.m_flags |= 4;
        boolean bl = false;
        boolean bl2 = (this.m_flags & 2) == 2;
        boolean bl3 = this.m_fixtureA.isSensor();
        boolean bl4 = this.m_fixtureB.isSensor();
        boolean bl5 = bl3 || bl4;
        Body body = this.m_fixtureA.getBody();
        Body body2 = this.m_fixtureB.getBody();
        Transform transform = body.getTransform();
        Transform transform2 = body2.getTransform();
        if (bl5) {
            Shape shape = this.m_fixtureA.getShape();
            Shape shape2 = this.m_fixtureB.getShape();
            bl = this.pool.getCollision().testOverlap(shape, this.m_indexA, shape2, this.m_indexB, transform, transform2);
            this.m_manifold.pointCount = 0;
        } else {
            this.evaluate(this.m_manifold, transform, transform2);
            bl = this.m_manifold.pointCount > 0;
            int n = 0;
            while (n < this.m_manifold.pointCount) {
                ManifoldPoint manifoldPoint = this.m_manifold.points[n];
                manifoldPoint.normalImpulse = 0.0f;
                manifoldPoint.tangentImpulse = 0.0f;
                ContactID contactID = manifoldPoint.id;
                int n2 = 0;
                while (n2 < this.oldManifold.pointCount) {
                    ManifoldPoint manifoldPoint2 = this.oldManifold.points[n2];
                    if (manifoldPoint2.id.isEqual(contactID)) {
                        manifoldPoint.normalImpulse = manifoldPoint2.normalImpulse;
                        manifoldPoint.tangentImpulse = manifoldPoint2.tangentImpulse;
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
            if (bl != bl2) {
                body.setAwake(true);
                body2.setAwake(true);
            }
        }
        this.m_flags = bl ? (this.m_flags |= 2) : (this.m_flags &= 0xFFFFFFFD);
        if (contactListener == null) {
            return;
        }
        if (!bl2 && bl) {
            contactListener.beginContact(this);
        }
        if (bl2 && !bl) {
            contactListener.endContact(this);
        }
        if (!bl5 && bl) {
            contactListener.preSolve(this, this.oldManifold);
        }
    }

    public static final float mixFriction(float f, float f2) {
        return MathUtils.sqrt(f * f2);
    }

    public static final float mixRestitution(float f, float f2) {
        return f > f2 ? f : f2;
    }
}

