/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.FrictionJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.pooling.IWorldPool;

public class FrictionJoint
extends Joint {
    private final Vec2 m_localAnchorA;
    private final Vec2 m_localAnchorB;
    private final Vec2 m_linearImpulse;
    private float m_angularImpulse;
    private float m_maxForce;
    private float m_maxTorque;
    private int m_indexA;
    private int m_indexB;
    private final Vec2 m_rA = new Vec2();
    private final Vec2 m_rB = new Vec2();
    private final Vec2 m_localCenterA = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private float m_invMassA;
    private float m_invMassB;
    private float m_invIA;
    private float m_invIB;
    private final Mat22 m_linearMass = new Mat22();
    private float m_angularMass;

    protected FrictionJoint(IWorldPool iWorldPool, FrictionJointDef frictionJointDef) {
        super(iWorldPool, frictionJointDef);
        this.m_localAnchorA = new Vec2(frictionJointDef.localAnchorA);
        this.m_localAnchorB = new Vec2(frictionJointDef.localAnchorB);
        this.m_linearImpulse = new Vec2();
        this.m_angularImpulse = 0.0f;
        this.m_maxForce = frictionJointDef.maxForce;
        this.m_maxTorque = frictionJointDef.maxTorque;
    }

    public Vec2 getLocalAnchorA() {
        return this.m_localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.m_localAnchorB;
    }

    @Override
    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
    }

    @Override
    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
    }

    @Override
    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_linearImpulse).mulLocal(f);
    }

    @Override
    public float getReactionTorque(float f) {
        return f * this.m_angularImpulse;
    }

    public void setMaxForce(float f) {
        assert (f >= 0.0f);
        this.m_maxForce = f;
    }

    public float getMaxForce() {
        return this.m_maxForce;
    }

    public void setMaxTorque(float f) {
        assert (f >= 0.0f);
        this.m_maxTorque = f;
    }

    public float getMaxTorque() {
        return this.m_maxTorque;
    }

    @Override
    public void initVelocityConstraints(SolverData solverData) {
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassA = this.m_bodyA.m_invMass;
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIA = this.m_bodyA.m_invI;
        this.m_invIB = this.m_bodyB.m_invI;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec2 = solverData.velocities[this.m_indexA].v;
        float f2 = solverData.velocities[this.m_indexA].w;
        float f3 = solverData.positions[this.m_indexB].a;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f4 = solverData.velocities[this.m_indexB].w;
        Vec2 vec23 = this.pool.popVec2();
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        rot.set(f);
        rot2.set(f3);
        Rot.mulToOutUnsafe(rot, vec23.set(this.m_localAnchorA).subLocal(this.m_localCenterA), this.m_rA);
        Rot.mulToOutUnsafe(rot2, vec23.set(this.m_localAnchorB).subLocal(this.m_localCenterB), this.m_rB);
        float f5 = this.m_invMassA;
        float f6 = this.m_invMassB;
        float f7 = this.m_invIA;
        float f8 = this.m_invIB;
        Mat22 mat22 = this.pool.popMat22();
        mat22.ex.x = f5 + f6 + f7 * this.m_rA.y * this.m_rA.y + f8 * this.m_rB.y * this.m_rB.y;
        mat22.ey.x = mat22.ex.y = -f7 * this.m_rA.x * this.m_rA.y - f8 * this.m_rB.x * this.m_rB.y;
        mat22.ey.y = f5 + f6 + f7 * this.m_rA.x * this.m_rA.x + f8 * this.m_rB.x * this.m_rB.x;
        mat22.invertToOut(this.m_linearMass);
        this.m_angularMass = f7 + f8;
        if (this.m_angularMass > 0.0f) {
            this.m_angularMass = 1.0f / this.m_angularMass;
        }
        if (solverData.step.warmStarting) {
            this.m_linearImpulse.mulLocal(solverData.step.dtRatio);
            this.m_angularImpulse *= solverData.step.dtRatio;
            Vec2 vec24 = this.pool.popVec2();
            vec24.set(this.m_linearImpulse);
            vec23.set(vec24).mulLocal(f5);
            vec2.subLocal(vec23);
            f2 -= f7 * (Vec2.cross(this.m_rA, vec24) + this.m_angularImpulse);
            vec23.set(vec24).mulLocal(f6);
            vec22.addLocal(vec23);
            f4 += f8 * (Vec2.cross(this.m_rB, vec24) + this.m_angularImpulse);
            this.pool.pushVec2(1);
        } else {
            this.m_linearImpulse.setZero();
            this.m_angularImpulse = 0.0f;
        }
        if (solverData.velocities[this.m_indexA].w != f2) assert (solverData.velocities[this.m_indexA].w != f2);
        solverData.velocities[this.m_indexA].w = f2;
        solverData.velocities[this.m_indexB].w = f4;
        this.pool.pushRot(2);
        this.pool.pushVec2(1);
        this.pool.pushMat22(1);
    }

    @Override
    public void solveVelocityConstraints(SolverData solverData) {
        Vec2 vec2 = solverData.velocities[this.m_indexA].v;
        float f = solverData.velocities[this.m_indexA].w;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f2 = solverData.velocities[this.m_indexB].w;
        float f3 = this.m_invMassA;
        float f4 = this.m_invMassB;
        float f5 = this.m_invIA;
        float f6 = this.m_invIB;
        float f7 = solverData.step.dt;
        float f8 = f2 - f;
        float f9 = -this.m_angularMass * f8;
        float f10 = this.m_angularImpulse;
        float f11 = f7 * this.m_maxTorque;
        this.m_angularImpulse = MathUtils.clamp(this.m_angularImpulse + f9, -f11, f11);
        f9 = this.m_angularImpulse - f10;
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2.crossToOutUnsafe(f -= f5 * f9, this.m_rA, vec24);
        Vec2.crossToOutUnsafe(f2 += f6 * f9, this.m_rB, vec23);
        vec23.addLocal(vec22).subLocal(vec2).subLocal(vec24);
        Vec2 vec25 = this.pool.popVec2();
        Mat22.mulToOutUnsafe(this.m_linearMass, vec23, vec25);
        vec25.negateLocal();
        Vec2 vec26 = this.pool.popVec2();
        vec26.set(this.m_linearImpulse);
        this.m_linearImpulse.addLocal(vec25);
        float f12 = f7 * this.m_maxForce;
        if (this.m_linearImpulse.lengthSquared() > f12 * f12) {
            this.m_linearImpulse.normalize();
            this.m_linearImpulse.mulLocal(f12);
        }
        vec25.set(this.m_linearImpulse).subLocal(vec26);
        vec24.set(vec25).mulLocal(f3);
        vec2.subLocal(vec24);
        f -= f5 * Vec2.cross(this.m_rA, vec25);
        vec24.set(vec25).mulLocal(f4);
        vec22.addLocal(vec24);
        f2 += f6 * Vec2.cross(this.m_rB, vec25);
        if (solverData.velocities[this.m_indexA].w != f) assert (solverData.velocities[this.m_indexA].w != f);
        solverData.velocities[this.m_indexA].w = f;
        solverData.velocities[this.m_indexB].w = f2;
        this.pool.pushVec2(4);
    }

    @Override
    public boolean solvePositionConstraints(SolverData solverData) {
        return true;
    }
}

