/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.MotorJointDef;
import org.jbox2d.pooling.IWorldPool;

public class MotorJoint
extends Joint {
    private final Vec2 m_linearOffset = new Vec2();
    private float m_angularOffset;
    private final Vec2 m_linearImpulse = new Vec2();
    private float m_angularImpulse;
    private float m_maxForce;
    private float m_maxTorque;
    private float m_correctionFactor;
    private int m_indexA;
    private int m_indexB;
    private final Vec2 m_rA = new Vec2();
    private final Vec2 m_rB = new Vec2();
    private final Vec2 m_localCenterA = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private final Vec2 m_linearError = new Vec2();
    private float m_angularError;
    private float m_invMassA;
    private float m_invMassB;
    private float m_invIA;
    private float m_invIB;
    private final Mat22 m_linearMass = new Mat22();
    private float m_angularMass;

    public MotorJoint(IWorldPool iWorldPool, MotorJointDef motorJointDef) {
        super(iWorldPool, motorJointDef);
        this.m_linearOffset.set(motorJointDef.linearOffset);
        this.m_angularOffset = motorJointDef.angularOffset;
        this.m_angularImpulse = 0.0f;
        this.m_maxForce = motorJointDef.maxForce;
        this.m_maxTorque = motorJointDef.maxTorque;
        this.m_correctionFactor = motorJointDef.correctionFactor;
    }

    @Override
    public void getAnchorA(Vec2 vec2) {
        vec2.set(this.m_bodyA.getPosition());
    }

    @Override
    public void getAnchorB(Vec2 vec2) {
        vec2.set(this.m_bodyB.getPosition());
    }

    @Override
    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_linearImpulse).mulLocal(f);
    }

    @Override
    public float getReactionTorque(float f) {
        return this.m_angularImpulse * f;
    }

    public float getCorrectionFactor() {
        return this.m_correctionFactor;
    }

    public void setCorrectionFactor(float f) {
        this.m_correctionFactor = f;
    }

    public void setLinearOffset(Vec2 vec2) {
        if (vec2.x != this.m_linearOffset.x || vec2.y != this.m_linearOffset.y) {
            this.m_bodyA.setAwake(true);
            this.m_bodyB.setAwake(true);
            this.m_linearOffset.set(vec2);
        }
    }

    public void getLinearOffset(Vec2 vec2) {
        vec2.set(this.m_linearOffset);
    }

    public Vec2 getLinearOffset() {
        return this.m_linearOffset;
    }

    public void setAngularOffset(float f) {
        if (f != this.m_angularOffset) {
            this.m_bodyA.setAwake(true);
            this.m_bodyB.setAwake(true);
            this.m_angularOffset = f;
        }
    }

    public float getAngularOffset() {
        return this.m_angularOffset;
    }

    public void setMaxForce(float f) {
        assert (f >= 0.0f);
        this.m_maxForce = f;
    }

    public float getMaxForce() {
        return this.m_maxForce;
    }

    public void setMaxTorque(float f) {
        assert (f >= 0.0f);
        this.m_maxTorque = f;
    }

    public float getMaxTorque() {
        return this.m_maxTorque;
    }

    @Override
    public void initVelocityConstraints(SolverData solverData) {
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassA = this.m_bodyA.m_invMass;
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIA = this.m_bodyA.m_invI;
        this.m_invIB = this.m_bodyB.m_invI;
        Vec2 vec2 = solverData.positions[this.m_indexA].c;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec22 = solverData.velocities[this.m_indexA].v;
        float f2 = solverData.velocities[this.m_indexA].w;
        Vec2 vec23 = solverData.positions[this.m_indexB].c;
        float f3 = solverData.positions[this.m_indexB].a;
        Vec2 vec24 = solverData.velocities[this.m_indexB].v;
        float f4 = solverData.velocities[this.m_indexB].w;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec25 = this.pool.popVec2();
        Mat22 mat22 = this.pool.popMat22();
        rot.set(f);
        rot2.set(f3);
        this.m_rA.x = rot.c * -this.m_localCenterA.x - rot.s * -this.m_localCenterA.y;
        this.m_rA.y = rot.s * -this.m_localCenterA.x + rot.c * -this.m_localCenterA.y;
        this.m_rB.x = rot2.c * -this.m_localCenterB.x - rot2.s * -this.m_localCenterB.y;
        this.m_rB.y = rot2.s * -this.m_localCenterB.x + rot2.c * -this.m_localCenterB.y;
        float f5 = this.m_invMassA;
        float f6 = this.m_invMassB;
        float f7 = this.m_invIA;
        float f8 = this.m_invIB;
        mat22.ex.x = f5 + f6 + f7 * this.m_rA.y * this.m_rA.y + f8 * this.m_rB.y * this.m_rB.y;
        mat22.ey.x = mat22.ex.y = -f7 * this.m_rA.x * this.m_rA.y - f8 * this.m_rB.x * this.m_rB.y;
        mat22.ey.y = f5 + f6 + f7 * this.m_rA.x * this.m_rA.x + f8 * this.m_rB.x * this.m_rB.x;
        mat22.invertToOut(this.m_linearMass);
        this.m_angularMass = f7 + f8;
        if (this.m_angularMass > 0.0f) {
            this.m_angularMass = 1.0f / this.m_angularMass;
        }
        Rot.mulToOutUnsafe(rot, this.m_linearOffset, vec25);
        this.m_linearError.x = vec23.x + this.m_rB.x - vec2.x - this.m_rA.x - vec25.x;
        this.m_linearError.y = vec23.y + this.m_rB.y - vec2.y - this.m_rA.y - vec25.y;
        this.m_angularError = f3 - f - this.m_angularOffset;
        if (solverData.step.warmStarting) {
            this.m_linearImpulse.x *= solverData.step.dtRatio;
            this.m_linearImpulse.y *= solverData.step.dtRatio;
            this.m_angularImpulse *= solverData.step.dtRatio;
            Vec2 vec26 = this.m_linearImpulse;
            vec22.x -= f5 * vec26.x;
            vec22.y -= f5 * vec26.y;
            f2 -= f7 * (this.m_rA.x * vec26.y - this.m_rA.y * vec26.x + this.m_angularImpulse);
            vec24.x += f6 * vec26.x;
            vec24.y += f6 * vec26.y;
            f4 += f8 * (this.m_rB.x * vec26.y - this.m_rB.y * vec26.x + this.m_angularImpulse);
        } else {
            this.m_linearImpulse.setZero();
            this.m_angularImpulse = 0.0f;
        }
        this.pool.pushVec2(1);
        this.pool.pushMat22(1);
        this.pool.pushRot(2);
        solverData.velocities[this.m_indexA].w = f2;
        solverData.velocities[this.m_indexB].w = f4;
    }

    @Override
    public void solveVelocityConstraints(SolverData solverData) {
        Vec2 vec2 = solverData.velocities[this.m_indexA].v;
        float f = solverData.velocities[this.m_indexA].w;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f2 = solverData.velocities[this.m_indexB].w;
        float f3 = this.m_invMassA;
        float f4 = this.m_invMassB;
        float f5 = this.m_invIA;
        float f6 = this.m_invIB;
        float f7 = solverData.step.dt;
        float f8 = solverData.step.inv_dt;
        Vec2 vec23 = this.pool.popVec2();
        float f9 = f2 - f + f8 * this.m_correctionFactor * this.m_angularError;
        float f10 = -this.m_angularMass * f9;
        float f11 = this.m_angularImpulse;
        float f12 = f7 * this.m_maxTorque;
        this.m_angularImpulse = MathUtils.clamp(this.m_angularImpulse + f10, -f12, f12);
        f10 = this.m_angularImpulse - f11;
        Vec2 vec24 = this.pool.popVec2();
        vec24.x = vec22.x + -(f2 += f6 * f10) * this.m_rB.y - vec2.x - -(f -= f5 * f10) * this.m_rA.y + f8 * this.m_correctionFactor * this.m_linearError.x;
        vec24.y = vec22.y + f2 * this.m_rB.x - vec2.y - f * this.m_rA.x + f8 * this.m_correctionFactor * this.m_linearError.y;
        Vec2 vec25 = vec23;
        Mat22.mulToOutUnsafe(this.m_linearMass, vec24, vec25);
        vec25.negateLocal();
        Vec2 vec26 = this.pool.popVec2();
        vec26.set(this.m_linearImpulse);
        this.m_linearImpulse.addLocal(vec25);
        f12 = f7 * this.m_maxForce;
        if (this.m_linearImpulse.lengthSquared() > f12 * f12) {
            this.m_linearImpulse.normalize();
            this.m_linearImpulse.mulLocal(f12);
        }
        vec25.x = this.m_linearImpulse.x - vec26.x;
        vec25.y = this.m_linearImpulse.y - vec26.y;
        vec2.x -= f3 * vec25.x;
        vec2.y -= f3 * vec25.y;
        vec22.x += f4 * vec25.x;
        vec22.y += f4 * vec25.y;
        this.pool.pushVec2(3);
        solverData.velocities[this.m_indexA].w = f -= f5 * (this.m_rA.x * vec25.y - this.m_rA.y * vec25.x);
        solverData.velocities[this.m_indexB].w = f2 += f6 * (this.m_rB.x * vec25.y - this.m_rB.y * vec25.x);
    }

    @Override
    public boolean solvePositionConstraints(SolverData solverData) {
        return true;
    }
}

