/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.particle;

import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.particle.ParticleSystem;

public class ParticleGroup {
    ParticleSystem m_system;
    int m_firstIndex = 0;
    int m_lastIndex = 0;
    int m_groupFlags = 0;
    float m_strength = 1.0f;
    ParticleGroup m_prev;
    ParticleGroup m_next;
    int m_timestamp = -1;
    float m_mass = 0.0f;
    float m_inertia = 0.0f;
    final Vec2 m_center = new Vec2();
    final Vec2 m_linearVelocity = new Vec2();
    float m_angularVelocity = 0.0f;
    final Transform m_transform = new Transform();
    boolean m_destroyAutomatically;
    boolean m_toBeDestroyed;
    boolean m_toBeSplit;
    Object m_userData;

    public ParticleGroup() {
        this.m_transform.setIdentity();
        this.m_destroyAutomatically = true;
        this.m_toBeDestroyed = false;
        this.m_toBeSplit = false;
    }

    public ParticleGroup getNext() {
        return this.m_next;
    }

    public int getParticleCount() {
        return this.m_lastIndex - this.m_firstIndex;
    }

    public int getBufferIndex() {
        return this.m_firstIndex;
    }

    public int getGroupFlags() {
        return this.m_groupFlags;
    }

    public void setGroupFlags(int n) {
        this.m_groupFlags = n;
    }

    public float getMass() {
        this.updateStatistics();
        return this.m_mass;
    }

    public float getInertia() {
        this.updateStatistics();
        return this.m_inertia;
    }

    public Vec2 getCenter() {
        this.updateStatistics();
        return this.m_center;
    }

    public Vec2 getLinearVelocity() {
        this.updateStatistics();
        return this.m_linearVelocity;
    }

    public float getAngularVelocity() {
        this.updateStatistics();
        return this.m_angularVelocity;
    }

    public Transform getTransform() {
        return this.m_transform;
    }

    public Vec2 getPosition() {
        return this.m_transform.p;
    }

    public float getAngle() {
        return this.m_transform.q.getAngle();
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public void setUserData(Object object) {
        this.m_userData = object;
    }

    public void updateStatistics() {
        if (this.m_timestamp != this.m_system.m_timestamp) {
            Vec2 vec2;
            Vec2 vec22;
            float f = this.m_system.getParticleMass();
            this.m_mass = 0.0f;
            this.m_center.setZero();
            this.m_linearVelocity.setZero();
            int n = this.m_firstIndex;
            while (n < this.m_lastIndex) {
                this.m_mass += f;
                vec22 = ((Vec2[])this.m_system.m_positionBuffer.data)[n];
                this.m_center.x += f * vec22.x;
                this.m_center.y += f * vec22.y;
                vec2 = ((Vec2[])this.m_system.m_velocityBuffer.data)[n];
                this.m_linearVelocity.x += f * vec2.x;
                this.m_linearVelocity.y += f * vec2.y;
                ++n;
            }
            if (this.m_mass > 0.0f) {
                this.m_center.x *= 1.0f / this.m_mass;
                this.m_center.y *= 1.0f / this.m_mass;
                this.m_linearVelocity.x *= 1.0f / this.m_mass;
                this.m_linearVelocity.y *= 1.0f / this.m_mass;
            }
            this.m_inertia = 0.0f;
            this.m_angularVelocity = 0.0f;
            n = this.m_firstIndex;
            while (n < this.m_lastIndex) {
                vec22 = ((Vec2[])this.m_system.m_positionBuffer.data)[n];
                vec2 = ((Vec2[])this.m_system.m_velocityBuffer.data)[n];
                float f2 = vec22.x - this.m_center.x;
                float f3 = vec22.y - this.m_center.y;
                float f4 = vec2.x - this.m_linearVelocity.x;
                float f5 = vec2.y - this.m_linearVelocity.y;
                this.m_inertia += f * (f2 * f2 + f3 * f3);
                this.m_angularVelocity += f * (f2 * f5 - f3 * f4);
                ++n;
            }
            if (this.m_inertia > 0.0f) {
                this.m_angularVelocity *= 1.0f / this.m_inertia;
            }
            this.m_timestamp = this.m_system.m_timestamp;
        }
    }
}

