/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics;

import com.bulletphysics.util.ArrayPool;

public class BulletGlobals {
    public static final boolean DEBUG = false;
    public static final float CONVEX_DISTANCE_MARGIN = 0.04f;
    public static final float FLT_EPSILON = 1.1920929E-7f;
    public static final float SIMD_EPSILON = 1.1920929E-7f;
    public static final float SIMD_2_PI = (float)Math.PI * 2;
    public static final float SIMD_PI = (float)Math.PI;
    public static final float SIMD_HALF_PI = 1.5707964f;
    public static final float SIMD_RADS_PER_DEG = (float)Math.PI / 180;
    public static final float SIMD_DEGS_PER_RAD = 57.295776f;
    public static final float SIMD_INFINITY = Float.MAX_VALUE;
    private static ThreadLocal<BulletGlobals> threadLocal = new ThreadLocal<BulletGlobals>(){

        @Override
        protected BulletGlobals initialValue() {
            return new BulletGlobals();
        }
    };
    private float contactBreakingThreshold = 0.02f;
    private float deactivationTime = 2.0f;
    private boolean disableDeactivation = false;

    public static float getContactBreakingThreshold() {
        return BulletGlobals.threadLocal.get().contactBreakingThreshold;
    }

    public static void setContactBreakingThreshold(float f) {
        BulletGlobals.threadLocal.get().contactBreakingThreshold = f;
    }

    public static float getDeactivationTime() {
        return BulletGlobals.threadLocal.get().deactivationTime;
    }

    public static void setDeactivationTime(float f) {
        BulletGlobals.threadLocal.get().deactivationTime = f;
    }

    public static boolean isDeactivationDisabled() {
        return BulletGlobals.threadLocal.get().disableDeactivation;
    }

    public static void setDeactivationDisabled(boolean bl) {
        BulletGlobals.threadLocal.get().disableDeactivation = bl;
    }

    public static void cleanCurrentThread() {
        threadLocal.remove();
        ArrayPool.cleanCurrentThread();
    }
}

