/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.broadphase;

import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.broadphase.BroadphaseProxy;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.broadphase.HashedOverlappingPairCache;
import com.bulletphysics.collision.broadphase.OverlappingPairCache;
import com.bulletphysics.collision.broadphase.SimpleBroadphaseProxy;
import java.util.ArrayList;
import javax.vecmath.Vector3f;

public class SimpleBroadphase
implements BroadphaseInterface {
    private final ArrayList<SimpleBroadphaseProxy> handles = new ArrayList();
    private int maxHandles;
    private OverlappingPairCache pairCache;
    private boolean ownsPairCache;

    public SimpleBroadphase() {
        this(16384, null);
    }

    public SimpleBroadphase(int n) {
        this(n, null);
    }

    public SimpleBroadphase(int n, OverlappingPairCache overlappingPairCache) {
        this.pairCache = overlappingPairCache;
        if (overlappingPairCache == null) {
            this.pairCache = new HashedOverlappingPairCache();
            this.ownsPairCache = true;
        }
    }

    @Override
    public BroadphaseProxy createProxy(Vector3f vector3f, Vector3f vector3f2, BroadphaseNativeType broadphaseNativeType, Object object, short s, short s2, Dispatcher dispatcher, Object object2) {
        assert (vector3f.x <= vector3f2.x && vector3f.y <= vector3f2.y && vector3f.z <= vector3f2.z);
        SimpleBroadphaseProxy simpleBroadphaseProxy = new SimpleBroadphaseProxy(vector3f, vector3f2, broadphaseNativeType, object, s, s2, object2);
        simpleBroadphaseProxy.uniqueId = this.handles.size();
        this.handles.add(simpleBroadphaseProxy);
        return simpleBroadphaseProxy;
    }

    @Override
    public void destroyProxy(BroadphaseProxy broadphaseProxy, Dispatcher dispatcher) {
        this.handles.remove(broadphaseProxy);
        this.pairCache.removeOverlappingPairsContainingProxy(broadphaseProxy, dispatcher);
    }

    @Override
    public void setAabb(BroadphaseProxy broadphaseProxy, Vector3f vector3f, Vector3f vector3f2, Dispatcher dispatcher) {
        SimpleBroadphaseProxy simpleBroadphaseProxy = (SimpleBroadphaseProxy)broadphaseProxy;
        simpleBroadphaseProxy.min.set(vector3f);
        simpleBroadphaseProxy.max.set(vector3f2);
    }

    private static boolean aabbOverlap(SimpleBroadphaseProxy simpleBroadphaseProxy, SimpleBroadphaseProxy simpleBroadphaseProxy2) {
        return simpleBroadphaseProxy.min.x <= simpleBroadphaseProxy2.max.x && simpleBroadphaseProxy2.min.x <= simpleBroadphaseProxy.max.x && simpleBroadphaseProxy.min.y <= simpleBroadphaseProxy2.max.y && simpleBroadphaseProxy2.min.y <= simpleBroadphaseProxy.max.y && simpleBroadphaseProxy.min.z <= simpleBroadphaseProxy2.max.z && simpleBroadphaseProxy2.min.z <= simpleBroadphaseProxy.max.z;
    }

    @Override
    public void calculateOverlappingPairs(Dispatcher dispatcher) {
        for (SimpleBroadphaseProxy simpleBroadphaseProxy : this.handles) {
            for (SimpleBroadphaseProxy simpleBroadphaseProxy2 : this.handles) {
                if (simpleBroadphaseProxy == simpleBroadphaseProxy2) continue;
                if (SimpleBroadphase.aabbOverlap(simpleBroadphaseProxy, simpleBroadphaseProxy2)) {
                    if (this.pairCache.findPair(simpleBroadphaseProxy, simpleBroadphaseProxy2) != null) continue;
                    this.pairCache.addOverlappingPair(simpleBroadphaseProxy, simpleBroadphaseProxy2);
                    continue;
                }
                if (this.pairCache.hasDeferredRemoval() || this.pairCache.findPair(simpleBroadphaseProxy, simpleBroadphaseProxy2) == null) continue;
                this.pairCache.removeOverlappingPair(simpleBroadphaseProxy, simpleBroadphaseProxy2, dispatcher);
            }
        }
    }

    @Override
    public OverlappingPairCache getOverlappingPairCache() {
        return this.pairCache;
    }

    @Override
    public void getBroadphaseAabb(Vector3f vector3f, Vector3f vector3f2) {
        vector3f.set(-1.0E30f, -1.0E30f, -1.0E30f);
        vector3f2.set(1.0E30f, 1.0E30f, 1.0E30f);
    }

    @Override
    public void printStats() {
    }
}

