/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.CollisionAlgorithm;
import com.bulletphysics.collision.broadphase.CollisionAlgorithmConstructionInfo;
import com.bulletphysics.collision.dispatch.CollisionAlgorithmCreateFunc;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.ManifoldResult;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.collision.shapes.StaticPlaneShape;
import com.bulletphysics.linearmath.Transform;
import java.util.ArrayList;
import javax.vecmath.Vector3f;

public class ConvexPlaneCollisionAlgorithm
extends CollisionAlgorithm {
    private boolean ownManifold;
    private PersistentManifold manifoldPtr;
    private boolean isSwapped;

    public void init(PersistentManifold persistentManifold, CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2, boolean bl) {
        CollisionObject collisionObject3;
        super.init(collisionAlgorithmConstructionInfo);
        this.ownManifold = false;
        this.manifoldPtr = persistentManifold;
        this.isSwapped = bl;
        CollisionObject collisionObject4 = bl ? collisionObject2 : collisionObject;
        CollisionObject collisionObject5 = collisionObject3 = bl ? collisionObject : collisionObject2;
        if (this.manifoldPtr == null && this.dispatcher.needsCollision(collisionObject4, collisionObject3)) {
            this.manifoldPtr = this.dispatcher.getNewManifold(collisionObject4, collisionObject3);
            this.ownManifold = true;
        }
    }

    @Override
    public void destroy() {
        if (this.ownManifold) {
            if (this.manifoldPtr != null) {
                this.dispatcher.releaseManifold(this.manifoldPtr);
            }
            this.manifoldPtr = null;
        }
    }

    @Override
    public void processCollision(CollisionObject collisionObject, CollisionObject collisionObject2, ManifoldResult manifoldResult) {
        if (this.manifoldPtr == null) {
            return;
        }
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        CollisionObject collisionObject3 = this.isSwapped ? collisionObject2 : collisionObject;
        CollisionObject collisionObject4 = this.isSwapped ? collisionObject : collisionObject2;
        ConvexShape convexShape = (ConvexShape)collisionObject3.getCollisionShape();
        StaticPlaneShape staticPlaneShape = (StaticPlaneShape)collisionObject4.getCollisionShape();
        boolean bl = false;
        Vector3f vector3f = staticPlaneShape.getPlaneNormal((Vector3f)Pools.VECTORS.get());
        float f = staticPlaneShape.getPlaneConstant();
        Transform transform2 = (Transform)Pools.TRANSFORMS.get();
        collisionObject3.getWorldTransform(transform2);
        transform2.inverse();
        transform2.mul(collisionObject4.getWorldTransform(transform));
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        transform3.inverse(collisionObject4.getWorldTransform(transform));
        transform3.mul(collisionObject3.getWorldTransform(transform));
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.negate(vector3f);
        transform2.basis.transform(vector3f2);
        Vector3f vector3f3 = convexShape.localGetSupportingVertex(vector3f2, (Vector3f)Pools.VECTORS.get());
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get((Object)vector3f3);
        transform3.transform(vector3f4);
        float f2 = vector3f.dot(vector3f4) - f;
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f2.scale(f2, vector3f);
        vector3f5.sub(vector3f4, vector3f2);
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get((Object)vector3f5);
        collisionObject4.getWorldTransform(transform).transform(vector3f6);
        bl = f2 < this.manifoldPtr.getContactBreakingThreshold();
        manifoldResult.setPersistentManifold(this.manifoldPtr);
        if (bl) {
            Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
            collisionObject4.getWorldTransform((Transform)transform).basis.transform(vector3f7);
            Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get((Object)vector3f6);
            manifoldResult.addContactPoint(vector3f7, vector3f8, f2);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f8, vector3f7});
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f3, vector3f4, vector3f5, vector3f6, vector3f});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2, transform3});
        if (this.ownManifold && this.manifoldPtr.getNumContacts() != 0) {
            manifoldResult.refreshContactPoints();
        }
    }

    @Override
    public float calculateTimeOfImpact(CollisionObject collisionObject, CollisionObject collisionObject2, ManifoldResult manifoldResult) {
        return 1.0f;
    }

    @Override
    public void getAllContactManifolds(ArrayList<PersistentManifold> arrayList) {
        if (this.manifoldPtr != null && this.ownManifold) {
            arrayList.add(this.manifoldPtr);
        }
    }

    public static class CreateFunc
    implements CollisionAlgorithmCreateFunc {
        boolean swapped;

        @Override
        public CollisionAlgorithm createCollisionAlgorithm(CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2) {
            ConvexPlaneCollisionAlgorithm convexPlaneCollisionAlgorithm = (ConvexPlaneCollisionAlgorithm)Pools.CONVEX_PLANE_COLLISIONS.get();
            if (!this.swapped) {
                convexPlaneCollisionAlgorithm.init(null, collisionAlgorithmConstructionInfo, collisionObject, collisionObject2, false);
            } else {
                convexPlaneCollisionAlgorithm.init(null, collisionAlgorithmConstructionInfo, collisionObject, collisionObject2, true);
            }
            return convexPlaneCollisionAlgorithm;
        }

        @Override
        public void releaseCollisionAlgorithm(CollisionAlgorithm collisionAlgorithm) {
            Pools.CONVEX_PLANE_COLLISIONS.release((Object[])new ConvexPlaneCollisionAlgorithm[]{(ConvexPlaneCollisionAlgorithm)collisionAlgorithm});
        }
    }
}

