/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.narrowphase.DiscreteCollisionDetectorInterface;
import com.bulletphysics.collision.narrowphase.ManifoldPoint;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Vector3f;

public class ManifoldResult
implements DiscreteCollisionDetectorInterface.Result {
    private PersistentManifold manifoldPtr;
    private final Transform rootTransA = new Transform();
    private final Transform rootTransB = new Transform();
    private CollisionObject body0;
    private CollisionObject body1;
    private int partId0;
    private int partId1;
    private int index0;
    private int index1;

    public ManifoldResult() {
    }

    public ManifoldResult(CollisionObject collisionObject, CollisionObject collisionObject2) {
        this.init(collisionObject, collisionObject2);
    }

    public void init(CollisionObject collisionObject, CollisionObject collisionObject2) {
        this.body0 = collisionObject;
        this.body1 = collisionObject2;
        collisionObject.getWorldTransform(this.rootTransA);
        collisionObject2.getWorldTransform(this.rootTransB);
    }

    public PersistentManifold getPersistentManifold() {
        return this.manifoldPtr;
    }

    public void setPersistentManifold(PersistentManifold persistentManifold) {
        this.manifoldPtr = persistentManifold;
    }

    @Override
    public void setShapeIdentifiers(int n, int n2, int n3, int n4) {
        this.partId0 = n;
        this.partId1 = n3;
        this.index0 = n2;
        this.index1 = n4;
    }

    @Override
    public void addContactPoint(Vector3f vector3f, Vector3f vector3f2, float f) {
        assert (this.manifoldPtr != null);
        if (f > this.manifoldPtr.getContactBreakingThreshold()) {
            return;
        }
        boolean bl = this.manifoldPtr.getBody0() != this.body0;
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.scaleAdd(f, vector3f, vector3f2);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        if (bl) {
            this.rootTransB.invXform(vector3f3, vector3f4);
            this.rootTransA.invXform(vector3f2, vector3f5);
        } else {
            this.rootTransA.invXform(vector3f3, vector3f4);
            this.rootTransB.invXform(vector3f2, vector3f5);
        }
        ManifoldPoint manifoldPoint = (ManifoldPoint)Pools.MANIFOLD_POINTS.get();
        manifoldPoint.init(vector3f4, vector3f5, vector3f, f);
        manifoldPoint.positionWorldOnA.set(vector3f3);
        manifoldPoint.positionWorldOnB.set(vector3f2);
        int n = this.manifoldPtr.getCacheEntry(manifoldPoint);
        manifoldPoint.combinedFriction = ManifoldResult.calculateCombinedFriction(this.body0, this.body1);
        manifoldPoint.combinedRestitution = ManifoldResult.calculateCombinedRestitution(this.body0, this.body1);
        manifoldPoint.partId0 = this.partId0;
        manifoldPoint.partId1 = this.partId1;
        manifoldPoint.index0 = this.index0;
        manifoldPoint.index1 = this.index1;
        if (n >= 0) {
            this.manifoldPtr.replaceContactPoint(manifoldPoint, n);
        } else {
            n = this.manifoldPtr.addManifoldPoint(manifoldPoint);
        }
        Pools.MANIFOLD_POINTS.release((Object[])new ManifoldPoint[]{manifoldPoint});
    }

    private static float calculateCombinedFriction(CollisionObject collisionObject, CollisionObject collisionObject2) {
        float f;
        float f2 = collisionObject.getFriction() * collisionObject2.getFriction();
        if (f2 < -(f = 10.0f)) {
            f2 = -f;
        }
        if (f2 > f) {
            f2 = f;
        }
        return f2;
    }

    private static float calculateCombinedRestitution(CollisionObject collisionObject, CollisionObject collisionObject2) {
        return collisionObject.getRestitution() * collisionObject2.getRestitution();
    }

    public void refreshContactPoints() {
        boolean bl;
        assert (this.manifoldPtr != null);
        if (this.manifoldPtr.getNumContacts() == 0) {
            return;
        }
        boolean bl2 = bl = this.manifoldPtr.getBody0() != this.body0;
        if (bl) {
            this.manifoldPtr.refreshContactPoints(this.rootTransB, this.rootTransA);
        } else {
            this.manifoldPtr.refreshContactPoints(this.rootTransA, this.rootTransB);
        }
    }
}

