/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.linearmath.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;

public class UnionFind {
    private final ArrayList<Element> elements = new ArrayList();

    public void sortIslands() {
        int n = this.elements.size();
        int n2 = 0;
        while (n2 < n) {
            this.elements.get((int)n2).id = this.find(n2);
            this.elements.get((int)n2).sz = n2;
            ++n2;
        }
        Collections.sort(this.elements);
    }

    public void reset(int n) {
        this.allocate(n);
        int n2 = 0;
        while (n2 < n) {
            this.elements.get((int)n2).id = n2;
            this.elements.get((int)n2).sz = 1;
            ++n2;
        }
    }

    public int getNumElements() {
        return this.elements.size();
    }

    public boolean isRoot(int n) {
        return n == this.elements.get((int)n).id;
    }

    public Element getElement(int n) {
        return this.elements.get(n);
    }

    public void allocate(int n) {
        MiscUtil.resize(this.elements, n, Element.class);
    }

    public void free() {
        this.elements.clear();
    }

    public int find(int n, int n2) {
        return this.find(n) == this.find(n2) ? 1 : 0;
    }

    public void unite(int n, int n2) {
        int n3;
        int n4 = this.find(n);
        if (n4 == (n3 = this.find(n2))) {
            return;
        }
        this.elements.get((int)n4).id = n3;
        this.elements.get((int)n3).sz += this.elements.get((int)n4).sz;
    }

    public int find(int n) {
        while (n != this.elements.get((int)n).id) {
            n = this.elements.get((int)n).id = this.elements.get((int)this.elements.get((int)n).id).id;
        }
        return n;
    }

    public static class Element
    implements Comparable<Element> {
        public int id;
        public int sz;

        @Override
        public int compareTo(Element element) {
            return Integer.compare(this.id, element.id);
        }
    }
}

