/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.narrowphase;

import com.bulletphysics.collision.narrowphase.ConvexCast;
import com.bulletphysics.collision.narrowphase.SubsimplexConvexCast;
import com.bulletphysics.collision.narrowphase.VoronoiSimplexSolver;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.collision.shapes.TriangleShape;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Vector3f;

public abstract class TriangleConvexcastCallback
implements TriangleCallback {
    public ConvexShape convexShape;
    public final Transform convexShapeFrom = new Transform();
    public final Transform convexShapeTo = new Transform();
    public final Transform triangleToWorld = new Transform();
    public float hitFraction;
    public float triangleCollisionMargin;

    public TriangleConvexcastCallback(ConvexShape convexShape, Transform transform, Transform transform2, Transform transform3, float f) {
        this.convexShape = convexShape;
        this.convexShapeFrom.set(transform);
        this.convexShapeTo.set(transform2);
        this.triangleToWorld.set(transform3);
        this.hitFraction = 1.0f;
        this.triangleCollisionMargin = f;
    }

    @Override
    public void processTriangle(Vector3f[] vector3fArray, int n, int n2) {
        TriangleShape triangleShape = new TriangleShape(vector3fArray[0], vector3fArray[1], vector3fArray[2]);
        triangleShape.setMargin(this.triangleCollisionMargin);
        VoronoiSimplexSolver voronoiSimplexSolver = new VoronoiSimplexSolver();
        SubsimplexConvexCast subsimplexConvexCast = new SubsimplexConvexCast(this.convexShape, triangleShape, voronoiSimplexSolver);
        ConvexCast.CastResult castResult = new ConvexCast.CastResult();
        castResult.fraction = 1.0f;
        if (subsimplexConvexCast.calcTimeOfImpact(this.convexShapeFrom, this.convexShapeTo, this.triangleToWorld, this.triangleToWorld, castResult) && castResult.normal.lengthSquared() > 1.0E-4f && castResult.fraction < this.hitFraction) {
            castResult.normal.normalize();
            this.reportHit(castResult.normal, castResult.hitPoint, castResult.fraction, n, n2);
        }
    }

    public abstract float reportHit(Vector3f var1, Vector3f var2, float var3, int var4, int var5);
}

