/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.collision.shapes.ScalarType;
import com.bulletphysics.collision.shapes.VertexData;
import java.nio.ByteBuffer;
import javax.vecmath.Tuple3f;

public class ByteBufferVertexData
implements VertexData {
    public ByteBuffer vertexData;
    public int vertexCount;
    public int vertexStride;
    public ScalarType vertexType;
    public ByteBuffer indexData;
    public int indexCount;
    public int indexStride;
    public ScalarType indexType;

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }

    @Override
    public int getIndexCount() {
        return this.indexCount;
    }

    @Override
    public <T extends Tuple3f> T getVertex(int n, T t) {
        int n2 = n * this.vertexStride;
        t.x = this.vertexData.getFloat(n2 + 0);
        t.y = this.vertexData.getFloat(n2 + 4);
        t.z = this.vertexData.getFloat(n2 + 8);
        return t;
    }

    @Override
    public void setVertex(int n, float f, float f2, float f3) {
        int n2 = n * this.vertexStride;
        this.vertexData.putFloat(n2 + 0, f);
        this.vertexData.putFloat(n2 + 4, f2);
        this.vertexData.putFloat(n2 + 8, f3);
    }

    @Override
    public int getIndex(int n) {
        if (this.indexType == ScalarType.SHORT) {
            return this.indexData.getShort(n * this.indexStride) & 0xFFFF;
        }
        if (this.indexType == ScalarType.INTEGER) {
            return this.indexData.getInt(n * this.indexStride);
        }
        throw new IllegalStateException("indicies type must be short or integer");
    }
}

