/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.ConvexInternalShape;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class CapsuleShape
extends ConvexInternalShape {
    protected int upAxis;

    CapsuleShape() {
    }

    public CapsuleShape(float f, float f2) {
        this.upAxis = 1;
        this.implicitShapeDimensions.set(f, 0.5f * f2, f);
    }

    @Override
    public Vector3f localGetSupportingVertexWithoutMargin(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = vector3f2;
        vector3f3.set(0.0f, 0.0f, 0.0f);
        float f = -1.0E30f;
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
        float f2 = vector3f4.lengthSquared();
        if (f2 < 1.0E-4f) {
            vector3f4.set(1.0f, 0.0f, 0.0f);
        } else {
            float f3 = 1.0f / (float)Math.sqrt(f2);
            vector3f4.scale(f3);
        }
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        float f4 = this.getRadius();
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
        vector3f8.set(0.0f, 0.0f, 0.0f);
        VectorUtil.setCoord(vector3f8, this.getUpAxis(), this.getHalfHeight());
        VectorUtil.mul(vector3f6, vector3f4, this.localScaling);
        vector3f6.scale(f4);
        vector3f7.scale(this.getMargin(), vector3f4);
        vector3f5.add(vector3f8, vector3f6);
        vector3f5.sub(vector3f7);
        float f5 = vector3f4.dot(vector3f5);
        if (f5 > f) {
            f = f5;
            vector3f3.set(vector3f5);
        }
        vector3f8.set(0.0f, 0.0f, 0.0f);
        VectorUtil.setCoord(vector3f8, this.getUpAxis(), -this.getHalfHeight());
        VectorUtil.mul(vector3f6, vector3f4, this.localScaling);
        vector3f6.scale(f4);
        vector3f7.scale(this.getMargin(), vector3f4);
        vector3f5.add(vector3f8, vector3f6);
        vector3f5.sub(vector3f7);
        f5 = vector3f4.dot(vector3f5);
        if (f5 > f) {
            f = f5;
            vector3f3.set(vector3f5);
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f7, vector3f8, vector3f5, vector3f4});
        return vector3f2;
    }

    @Override
    public void batchedUnitVectorGetSupportingVertexWithoutMargin(Vector3f[] vector3fArray, Vector3f[] vector3fArray2, int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        transform.setIdentity();
        float f2 = this.getRadius();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.set(f2, f2, f2);
        VectorUtil.setCoord(vector3f2, this.getUpAxis(), f2 + this.getHalfHeight());
        float f3 = 0.04f;
        float f4 = 2.0f * (vector3f2.x + f3);
        float f5 = 2.0f * (vector3f2.y + f3);
        float f6 = 2.0f * (vector3f2.z + f3);
        float f7 = f4 * f4;
        float f8 = f5 * f5;
        float f9 = f6 * f6;
        float f10 = f * 0.08333333f;
        vector3f.x = f10 * (f8 + f9);
        vector3f.y = f10 * (f7 + f9);
        vector3f.z = f10 * (f7 + f8);
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2});
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.CAPSULE_SHAPE_PROXYTYPE;
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.set(this.getRadius(), this.getRadius(), this.getRadius());
        VectorUtil.setCoord(vector3f4, this.upAxis, this.getRadius() + this.getHalfHeight());
        vector3f4.x += this.getMargin();
        vector3f4.y += this.getMargin();
        vector3f4.z += this.getMargin();
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get();
        matrix3f.set(transform.basis);
        MatrixUtil.absolute(matrix3f);
        Vector3f vector3f5 = transform.origin;
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        matrix3f.getRow(0, vector3f3);
        vector3f6.x = vector3f3.dot(vector3f4);
        matrix3f.getRow(1, vector3f3);
        vector3f6.y = vector3f3.dot(vector3f4);
        matrix3f.getRow(2, vector3f3);
        vector3f6.z = vector3f3.dot(vector3f4);
        vector3f.sub(vector3f5, vector3f6);
        vector3f2.add(vector3f5, vector3f6);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f6, vector3f4});
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
    }

    @Override
    public String getName() {
        return "CapsuleShape";
    }

    public int getUpAxis() {
        return this.upAxis;
    }

    public float getRadius() {
        int n = (this.upAxis + 2) % 3;
        return VectorUtil.getCoord(this.implicitShapeDimensions, n);
    }

    public float getHalfHeight() {
        return VectorUtil.getCoord(this.implicitShapeDimensions, this.upAxis);
    }
}

