/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Vector3f;

public interface CollisionShape {
    public void getAabb(Transform var1, Vector3f var2, Vector3f var3);

    default public void getBoundingSphere(Vector3f vector3f, float[] fArray) {
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        transform.setIdentity();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        this.getAabb(transform, vector3f3, vector3f4);
        vector3f2.sub(vector3f4, vector3f3);
        fArray[0] = vector3f2.length() * 0.5f;
        vector3f2.add(vector3f3, vector3f4);
        vector3f.scale(0.5f, vector3f2);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f3, vector3f4});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
    }

    default public float getAngularMotionDisc() {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        float[] fArray = new float[1];
        this.getBoundingSphere(vector3f, fArray);
        fArray[0] = fArray[0] + vector3f.length();
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        return fArray[0];
    }

    default public void calculateTemporalAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2, float f, Vector3f vector3f3, Vector3f vector3f4) {
        this.getAabb(transform, vector3f3, vector3f4);
        float f2 = vector3f4.x;
        float f3 = vector3f4.y;
        float f4 = vector3f4.z;
        float f5 = vector3f3.x;
        float f6 = vector3f3.y;
        float f7 = vector3f3.z;
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
        vector3f5.scale(f);
        if (vector3f5.x > 0.0f) {
            f2 += vector3f5.x;
        } else {
            f5 += vector3f5.x;
        }
        if (vector3f5.y > 0.0f) {
            f3 += vector3f5.y;
        } else {
            f6 += vector3f5.y;
        }
        if (vector3f5.z > 0.0f) {
            f4 += vector3f5.z;
        } else {
            f7 += vector3f5.z;
        }
        float f8 = vector3f2.length() * this.getAngularMotionDisc() * f;
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        vector3f6.set(f8, f8, f8);
        vector3f3.set(f5, f6, f7);
        vector3f4.set(f2, f3, f4);
        vector3f3.sub(vector3f6);
        vector3f4.add(vector3f6);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
    }

    default public boolean isPolyhedral() {
        return this.getShapeType().isPolyhedral();
    }

    default public boolean isConvex() {
        return this.getShapeType().isConvex();
    }

    default public boolean isConcave() {
        return this.getShapeType().isConcave();
    }

    default public boolean isCompound() {
        return this.getShapeType().isCompound();
    }

    default public boolean isInfinite() {
        return this.getShapeType().isInfinite();
    }

    public BroadphaseNativeType getShapeType();

    public void setLocalScaling(Vector3f var1);

    public Vector3f getLocalScaling(Vector3f var1);

    public void calculateLocalInertia(float var1, Vector3f var2);

    public String getName();

    public void setMargin(float var1);

    public float getMargin();
}

