/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.PolyhedralConvexShape;
import com.bulletphysics.linearmath.VectorUtil;
import java.util.ArrayList;
import javax.vecmath.Vector3f;

public class ConvexHullShape
extends PolyhedralConvexShape {
    private final ArrayList<Vector3f> points = new ArrayList();

    public ConvexHullShape() {
    }

    public ConvexHullShape(ArrayList<Vector3f> arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            this.points.add(new Vector3f(arrayList.get(n)));
            ++n;
        }
        this.recalcLocalAabb();
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        this.localScaling.set(vector3f);
        this.recalcLocalAabb();
    }

    public void addPoint(Vector3f vector3f) {
        this.points.add(new Vector3f(vector3f));
        this.recalcLocalAabb();
    }

    public ArrayList<Vector3f> getPoints() {
        return this.points;
    }

    public int getNumPoints() {
        return this.points.size();
    }

    @Override
    public Vector3f localGetSupportingVertexWithoutMargin(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = vector3f2;
        vector3f3.set(0.0f, 0.0f, 0.0f);
        float f = -1.0E30f;
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
        float f2 = vector3f4.lengthSquared();
        if (f2 < 1.0E-4f) {
            vector3f4.set(1.0f, 0.0f, 0.0f);
        } else {
            float f3 = 1.0f / (float)Math.sqrt(f2);
            vector3f4.scale(f3);
        }
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        for (Vector3f vector3f6 : this.points) {
            VectorUtil.mul(vector3f5, vector3f6, this.localScaling);
            float f4 = vector3f4.dot(vector3f5);
            if (!(f4 > f)) continue;
            f = f4;
            vector3f3.set(vector3f5);
        }
        return vector3f2;
    }

    @Override
    public void batchedUnitVectorGetSupportingVertexWithoutMargin(Vector3f[] vector3fArray, Vector3f[] vector3fArray2, int n) {
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = -1.0E30f;
            ++n2;
        }
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        for (Vector3f vector3f2 : this.points) {
            VectorUtil.mul(vector3f, vector3f2, this.localScaling);
            int n3 = 0;
            while (n3 < n) {
                Vector3f vector3f3 = vector3fArray[n3];
                float f = vector3f3.dot(vector3f);
                if (f > fArray[n3]) {
                    vector3fArray2[n3].set(vector3f);
                    fArray[n3] = f;
                }
                ++n3;
            }
        }
    }

    @Override
    public Vector3f localGetSupportingVertex(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = this.localGetSupportingVertexWithoutMargin(vector3f, vector3f2);
        if (this.getMargin() != 0.0f) {
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
            if (vector3f4.lengthSquared() < 1.4210855E-14f) {
                vector3f4.set(-1.0f, -1.0f, -1.0f);
            }
            vector3f4.normalize();
            vector3f3.scaleAdd(this.getMargin(), vector3f4, vector3f3);
        }
        return vector3f2;
    }

    @Override
    public int getNumVertices() {
        return this.points.size();
    }

    @Override
    public int getNumEdges() {
        return this.points.size();
    }

    @Override
    public void getEdge(int n, Vector3f vector3f, Vector3f vector3f2) {
        int n2 = n % this.points.size();
        int n3 = (n + 1) % this.points.size();
        VectorUtil.mul(vector3f, this.points.get(n2), this.localScaling);
        VectorUtil.mul(vector3f2, this.points.get(n3), this.localScaling);
    }

    @Override
    public void getVertex(int n, Vector3f vector3f) {
        VectorUtil.mul(vector3f, this.points.get(n), this.localScaling);
    }

    @Override
    public int getNumPlanes() {
        return 0;
    }

    @Override
    public void getPlane(Vector3f vector3f, Vector3f vector3f2, int n) {
        assert (false);
    }

    @Override
    public boolean isInside(Vector3f vector3f, float f) {
        assert (false);
        return false;
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.CONVEX_HULL_SHAPE_PROXYTYPE;
    }

    @Override
    public String getName() {
        return "Convex";
    }
}

