/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.BvhTriangleMeshShape;
import com.bulletphysics.collision.shapes.ConcaveShape;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class ScaledBvhTriangleMeshShape
extends ConcaveShape {
    protected final Vector3f localScaling = new Vector3f();
    protected BvhTriangleMeshShape bvhTriMeshShape;

    public ScaledBvhTriangleMeshShape(BvhTriangleMeshShape bvhTriangleMeshShape, Vector3f vector3f) {
        this.localScaling.set(vector3f);
        this.bvhTriMeshShape = bvhTriangleMeshShape;
    }

    public BvhTriangleMeshShape getChildShape() {
        return this.bvhTriMeshShape;
    }

    @Override
    public void processAllTriangles(TriangleCallback triangleCallback, Vector3f vector3f, Vector3f vector3f2) {
        ScaledTriangleCallback scaledTriangleCallback = new ScaledTriangleCallback(triangleCallback, this.localScaling);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.set(1.0f / this.localScaling.x, 1.0f / this.localScaling.y, 1.0f / this.localScaling.z);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f4.x = this.localScaling.x >= 0.0f ? vector3f.x * vector3f3.x : vector3f2.x * vector3f3.x;
        vector3f4.y = this.localScaling.y >= 0.0f ? vector3f.y * vector3f3.y : vector3f2.y * vector3f3.y;
        vector3f4.z = this.localScaling.z >= 0.0f ? vector3f.z * vector3f3.z : vector3f2.z * vector3f3.z;
        vector3f5.x = this.localScaling.x <= 0.0f ? vector3f.x * vector3f3.x : vector3f2.x * vector3f3.x;
        vector3f5.y = this.localScaling.y <= 0.0f ? vector3f.y * vector3f3.y : vector3f2.y * vector3f3.y;
        vector3f5.z = this.localScaling.z <= 0.0f ? vector3f.z * vector3f3.z : vector3f2.z * vector3f3.z;
        this.bvhTriMeshShape.processAllTriangles(scaledTriangleCallback, vector3f4, vector3f5);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f5, vector3f3});
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = this.bvhTriMeshShape.getLocalAabbMin((Vector3f)Pools.VECTORS.get());
        Vector3f vector3f4 = this.bvhTriMeshShape.getLocalAabbMax((Vector3f)Pools.VECTORS.get());
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        VectorUtil.mul(vector3f5, vector3f3, this.localScaling);
        VectorUtil.mul(vector3f6, vector3f4, this.localScaling);
        vector3f3.x = this.localScaling.x >= 0.0f ? vector3f5.x : vector3f6.x;
        vector3f3.y = this.localScaling.y >= 0.0f ? vector3f5.y : vector3f6.y;
        vector3f3.z = this.localScaling.z >= 0.0f ? vector3f5.z : vector3f6.z;
        vector3f4.x = this.localScaling.x <= 0.0f ? vector3f5.x : vector3f6.x;
        vector3f4.y = this.localScaling.y <= 0.0f ? vector3f5.y : vector3f6.y;
        vector3f4.z = this.localScaling.z <= 0.0f ? vector3f5.z : vector3f6.z;
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        vector3f7.sub(vector3f4, vector3f3);
        vector3f7.scale(0.5f);
        float f = this.bvhTriMeshShape.getMargin();
        vector3f7.x += f;
        vector3f7.y += f;
        vector3f7.z += f;
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
        vector3f8.add(vector3f4, vector3f3);
        vector3f8.scale(0.5f);
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get((Object)transform.basis);
        MatrixUtil.absolute(matrix3f);
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get((Object)vector3f8);
        transform.transform(vector3f9);
        Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f11 = (Vector3f)Pools.VECTORS.get();
        matrix3f.getRow(0, vector3f11);
        vector3f10.x = vector3f11.dot(vector3f7);
        matrix3f.getRow(1, vector3f11);
        vector3f10.y = vector3f11.dot(vector3f7);
        matrix3f.getRow(2, vector3f11);
        vector3f10.z = vector3f11.dot(vector3f7);
        vector3f.sub(vector3f9, vector3f10);
        vector3f2.add(vector3f9, vector3f10);
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f9, vector3f11, vector3f10, vector3f7, vector3f5, vector3f6, vector3f4, vector3f3});
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.SCALED_TRIANGLE_MESH_SHAPE_PROXYTYPE;
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        this.localScaling.set(vector3f);
    }

    @Override
    public Vector3f getLocalScaling(Vector3f vector3f) {
        vector3f.set(this.localScaling);
        return vector3f;
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
    }

    @Override
    public String getName() {
        return "SCALEDBVHTRIANGLEMESH";
    }

    private static class ScaledTriangleCallback
    implements TriangleCallback {
        private final TriangleCallback originalCallback;
        private final Vector3f localScaling;
        private final Vector3f[] newTriangle = new Vector3f[3];

        public ScaledTriangleCallback(TriangleCallback triangleCallback, Vector3f vector3f) {
            this.originalCallback = triangleCallback;
            this.localScaling = vector3f;
            int n = 0;
            while (n < this.newTriangle.length) {
                this.newTriangle[n] = new Vector3f();
                ++n;
            }
        }

        @Override
        public void processTriangle(Vector3f[] vector3fArray, int n, int n2) {
            VectorUtil.mul(this.newTriangle[0], vector3fArray[0], this.localScaling);
            VectorUtil.mul(this.newTriangle[1], vector3fArray[1], this.localScaling);
            VectorUtil.mul(this.newTriangle[2], vector3fArray[2], this.localScaling);
            this.originalCallback.processTriangle(this.newTriangle, n, n2);
        }
    }
}

