/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.constraintsolver;

import com.bulletphysics.Pools;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.JacobianEntry;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraintType;
import com.bulletphysics.linearmath.QuaternionUtil;
import com.bulletphysics.linearmath.ScalarUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.TransformUtil;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class HingeConstraint
extends TypedConstraint {
    private final JacobianEntry[] jac = new JacobianEntry[]{new JacobianEntry(), new JacobianEntry(), new JacobianEntry()};
    private final JacobianEntry[] jacAng = new JacobianEntry[]{new JacobianEntry(), new JacobianEntry(), new JacobianEntry()};
    private final Transform rbAFrame = new Transform();
    private final Transform rbBFrame = new Transform();
    private float motorTargetVelocity;
    private float maxMotorImpulse;
    private float limitSoftness;
    private float biasFactor;
    private float relaxationFactor;
    private float lowerLimit;
    private float upperLimit;
    private float kHinge;
    private float limitSign;
    private float correction;
    private float accLimitImpulse;
    private boolean angularOnly;
    private boolean enableAngularMotor;
    private boolean solveLimit;

    public HingeConstraint() {
        super(TypedConstraintType.HINGE_CONSTRAINT_TYPE);
        this.enableAngularMotor = false;
    }

    public HingeConstraint(RigidBody rigidBody, RigidBody rigidBody2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        super(TypedConstraintType.HINGE_CONSTRAINT_TYPE, rigidBody, rigidBody2);
        this.angularOnly = false;
        this.enableAngularMotor = false;
        this.rbAFrame.origin.set(vector3f);
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        Transform transform = rigidBody.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get());
        transform.basis.getColumn(0, vector3f5);
        float f = vector3f3.dot(vector3f5);
        if (f >= 0.9999999f) {
            transform.basis.getColumn(2, vector3f5);
            vector3f5.negate();
            transform.basis.getColumn(1, vector3f6);
        } else if (f <= -0.9999999f) {
            transform.basis.getColumn(2, vector3f5);
            transform.basis.getColumn(1, vector3f6);
        } else {
            vector3f6.cross(vector3f3, vector3f5);
            vector3f5.cross(vector3f6, vector3f3);
        }
        this.rbAFrame.basis.setRow(0, vector3f5.x, vector3f6.x, vector3f3.x);
        this.rbAFrame.basis.setRow(1, vector3f5.y, vector3f6.y, vector3f3.y);
        this.rbAFrame.basis.setRow(2, vector3f5.z, vector3f6.z, vector3f3.z);
        Quat4f quat4f = QuaternionUtil.shortestArcQuat(vector3f3, vector3f4, (Quat4f)Pools.QUATS.get());
        Vector3f vector3f7 = QuaternionUtil.quatRotate(quat4f, vector3f5, (Vector3f)Pools.VECTORS.get());
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
        vector3f8.cross(vector3f4, vector3f7);
        this.rbBFrame.origin.set(vector3f2);
        this.rbBFrame.basis.setRow(0, vector3f7.x, vector3f8.x, -vector3f4.x);
        this.rbBFrame.basis.setRow(1, vector3f7.y, vector3f8.y, -vector3f4.y);
        this.rbBFrame.basis.setRow(2, vector3f7.z, vector3f8.z, -vector3f4.z);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f8, vector3f7});
        Pools.QUATS.release((Object[])new Quat4f[]{quat4f});
        this.lowerLimit = 1.0E30f;
        this.upperLimit = -1.0E30f;
        this.biasFactor = 0.3f;
        this.relaxationFactor = 1.0f;
        this.limitSoftness = 0.9f;
        this.solveLimit = false;
    }

    public HingeConstraint(RigidBody rigidBody, Vector3f vector3f, Vector3f vector3f2) {
        super(TypedConstraintType.HINGE_CONSTRAINT_TYPE, rigidBody);
        this.angularOnly = false;
        this.enableAngularMotor = false;
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Transform transform = rigidBody.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get());
        transform.basis.getColumn(0, vector3f3);
        float f = vector3f3.dot(vector3f2);
        if (f > 1.1920929E-7f) {
            vector3f3.scale(f);
            vector3f3.sub(vector3f2);
        } else {
            transform.basis.getColumn(1, vector3f3);
        }
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.cross(vector3f2, vector3f3);
        this.rbAFrame.origin.set(vector3f);
        this.rbAFrame.basis.setRow(0, vector3f3.x, vector3f4.x, vector3f2.x);
        this.rbAFrame.basis.setRow(1, vector3f3.y, vector3f4.y, vector3f2.y);
        this.rbAFrame.basis.setRow(2, vector3f3.z, vector3f4.z, vector3f2.z);
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.negate(vector3f2);
        transform.basis.transform(vector3f5);
        Quat4f quat4f = QuaternionUtil.shortestArcQuat(vector3f2, vector3f5, (Quat4f)Pools.QUATS.get());
        Vector3f vector3f6 = QuaternionUtil.quatRotate(quat4f, vector3f3, (Vector3f)Pools.VECTORS.get());
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        vector3f7.cross(vector3f5, vector3f6);
        this.rbBFrame.origin.set(vector3f);
        transform.transform(this.rbBFrame.origin);
        this.rbBFrame.basis.setRow(0, vector3f6.x, vector3f7.x, vector3f5.x);
        this.rbBFrame.basis.setRow(1, vector3f6.y, vector3f7.y, vector3f5.y);
        this.rbBFrame.basis.setRow(2, vector3f6.z, vector3f7.z, vector3f5.z);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f4, vector3f5, vector3f7, vector3f6});
        Pools.QUATS.release((Object[])new Quat4f[]{quat4f});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
        this.lowerLimit = 1.0E30f;
        this.upperLimit = -1.0E30f;
        this.biasFactor = 0.3f;
        this.relaxationFactor = 1.0f;
        this.limitSoftness = 0.9f;
        this.solveLimit = false;
    }

    public HingeConstraint(RigidBody rigidBody, RigidBody rigidBody2, Transform transform, Transform transform2) {
        super(TypedConstraintType.HINGE_CONSTRAINT_TYPE, rigidBody, rigidBody2);
        this.rbAFrame.set(transform);
        this.rbBFrame.set(transform2);
        this.angularOnly = false;
        this.enableAngularMotor = false;
        this.rbBFrame.basis.m02 *= -1.0f;
        this.rbBFrame.basis.m12 *= -1.0f;
        this.rbBFrame.basis.m22 *= -1.0f;
        this.lowerLimit = 1.0E30f;
        this.upperLimit = -1.0E30f;
        this.biasFactor = 0.3f;
        this.relaxationFactor = 1.0f;
        this.limitSoftness = 0.9f;
        this.solveLimit = false;
    }

    public HingeConstraint(RigidBody rigidBody, Transform transform) {
        super(TypedConstraintType.HINGE_CONSTRAINT_TYPE, rigidBody);
        this.rbAFrame.set(transform);
        this.rbBFrame.set(transform);
        this.angularOnly = false;
        this.enableAngularMotor = false;
        this.rbBFrame.basis.m02 *= -1.0f;
        this.rbBFrame.basis.m12 *= -1.0f;
        this.rbBFrame.basis.m22 *= -1.0f;
        this.rbBFrame.origin.set(this.rbAFrame.origin);
        rigidBody.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get()).transform(this.rbBFrame.origin);
        this.lowerLimit = 1.0E30f;
        this.upperLimit = -1.0E30f;
        this.biasFactor = 0.3f;
        this.relaxationFactor = 1.0f;
        this.limitSoftness = 0.9f;
        this.solveLimit = false;
    }

    @Override
    public void buildJacobian() {
        Vector3f[] vector3fArray;
        Vector3f vector3f;
        Vector3f vector3f2;
        Vector3f vector3f3;
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get();
        Matrix3f matrix3f2 = (Matrix3f)Pools.MATRICES.get();
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        Transform transform = this.rbA.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get());
        Transform transform2 = this.rbB.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get());
        this.appliedImpulse = 0.0f;
        if (!this.angularOnly) {
            vector3f3 = (Vector3f)Pools.VECTORS.get((Object)this.rbAFrame.origin);
            transform.transform(vector3f3);
            vector3f2 = (Vector3f)Pools.VECTORS.get((Object)this.rbBFrame.origin);
            transform2.transform(vector3f2);
            vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.sub(vector3f2, vector3f3);
            vector3fArray = new Vector3f[]{(Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get()};
            if (vector3f.lengthSquared() > 1.1920929E-7f) {
                vector3fArray[0].set(vector3f);
                vector3fArray[0].normalize();
            } else {
                vector3fArray[0].set(1.0f, 0.0f, 0.0f);
            }
            TransformUtil.planeSpace1(vector3fArray[0], vector3fArray[1], vector3fArray[2]);
            int n = 0;
            while (n < 3) {
                matrix3f.transpose(transform.basis);
                matrix3f2.transpose(transform2.basis);
                vector3f5.sub(vector3f3, this.rbA.getCenterOfMassPosition(vector3f7));
                vector3f6.sub(vector3f2, this.rbB.getCenterOfMassPosition(vector3f7));
                this.jac[n].init(matrix3f, matrix3f2, vector3f5, vector3f6, vector3fArray[n], this.rbA.getInvInertiaDiagLocal((Vector3f)Pools.VECTORS.get()), this.rbA.getInvMass(), this.rbB.getInvInertiaDiagLocal((Vector3f)Pools.VECTORS.get()), this.rbB.getInvMass());
                ++n;
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3fArray[0], vector3fArray[1], vector3fArray[2], vector3f, vector3f2, vector3f3});
        }
        vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f2 = (Vector3f)Pools.VECTORS.get();
        this.rbAFrame.basis.getColumn(2, vector3f4);
        TransformUtil.planeSpace1(vector3f4, vector3f3, vector3f2);
        vector3f = (Vector3f)Pools.VECTORS.get((Object)vector3f3);
        transform.basis.transform(vector3f);
        vector3fArray = (Vector3f[])Pools.VECTORS.get((Object)vector3f2);
        transform.basis.transform((Tuple3f)vector3fArray);
        Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
        this.rbAFrame.basis.getColumn(2, vector3f10);
        transform.basis.transform(vector3f10);
        matrix3f.transpose(transform.basis);
        matrix3f2.transpose(transform2.basis);
        this.jacAng[0].init(vector3f, matrix3f, matrix3f2, this.rbA.getInvInertiaDiagLocal(vector3f8), this.rbB.getInvInertiaDiagLocal(vector3f9));
        this.jacAng[1].init((Vector3f)vector3fArray, matrix3f, matrix3f2, this.rbA.getInvInertiaDiagLocal(vector3f8), this.rbB.getInvInertiaDiagLocal(vector3f9));
        this.jacAng[2].init(vector3f10, matrix3f, matrix3f2, this.rbA.getInvInertiaDiagLocal(vector3f8), this.rbB.getInvInertiaDiagLocal(vector3f9));
        float f = this.getHingeAngle();
        this.correction = 0.0f;
        this.limitSign = 0.0f;
        this.solveLimit = false;
        this.accLimitImpulse = 0.0f;
        if (this.lowerLimit < this.upperLimit) {
            if (f <= this.lowerLimit * this.limitSoftness) {
                this.correction = this.lowerLimit - f;
                this.limitSign = 1.0f;
                this.solveLimit = true;
            } else if (f >= this.upperLimit * this.limitSoftness) {
                this.correction = this.upperLimit - f;
                this.limitSign = -1.0f;
                this.solveLimit = true;
            }
        }
        Vector3f vector3f11 = (Vector3f)Pools.VECTORS.get();
        this.rbAFrame.basis.getColumn(2, vector3f11);
        transform.basis.transform(vector3f11);
        this.kHinge = 1.0f / (this.getRigidBodyA().computeAngularImpulseDenominator(vector3f11) + this.getRigidBodyB().computeAngularImpulseDenominator(vector3f11));
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f11, vector3f10, vector3fArray, vector3f, vector3f3, vector3f2, vector3f7, vector3f4, vector3f5, vector3f6, vector3f8, vector3f9});
    }

    @Override
    public void solveConstraint(float f) {
        Vector3f vector3f;
        float f2;
        float f3;
        float f4;
        Vector3f vector3f2;
        float f5;
        float f6;
        Vector3f vector3f3;
        Vector3f vector3f4;
        Vector3f vector3f5;
        Vector3f vector3f6;
        Vector3f vector3f7;
        Vector3f vector3f8;
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f11 = (Vector3f)Pools.VECTORS.get();
        Transform transform = this.rbA.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get());
        Transform transform2 = this.rbB.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get());
        Vector3f vector3f12 = (Vector3f)Pools.VECTORS.get((Object)this.rbAFrame.origin);
        transform.transform(vector3f12);
        Vector3f vector3f13 = (Vector3f)Pools.VECTORS.get((Object)this.rbBFrame.origin);
        transform2.transform(vector3f13);
        float f7 = 0.3f;
        if (!this.angularOnly) {
            vector3f8 = (Vector3f)Pools.VECTORS.get();
            vector3f8.sub(vector3f12, this.rbA.getCenterOfMassPosition(vector3f11));
            vector3f7 = (Vector3f)Pools.VECTORS.get();
            vector3f7.sub(vector3f13, this.rbB.getCenterOfMassPosition(vector3f11));
            vector3f6 = this.rbA.getVelocityInLocalPoint(vector3f8, (Vector3f)Pools.VECTORS.get());
            vector3f5 = this.rbB.getVelocityInLocalPoint(vector3f7, (Vector3f)Pools.VECTORS.get());
            vector3f4 = (Vector3f)Pools.VECTORS.get();
            vector3f4.sub(vector3f6, vector3f5);
            int n = 0;
            while (n < 3) {
                vector3f3 = this.jac[n].linearJointAxis;
                float f8 = 1.0f / this.jac[n].getDiagonal();
                float f9 = vector3f3.dot(vector3f4);
                vector3f9.sub(vector3f12, vector3f13);
                f6 = -vector3f9.dot(vector3f3);
                f5 = f6 * f7 / f * f8 - f9 * f8;
                this.appliedImpulse += f5;
                vector3f2 = (Vector3f)Pools.VECTORS.get();
                vector3f2.scale(f5, vector3f3);
                vector3f9.sub(vector3f12, this.rbA.getCenterOfMassPosition(vector3f11));
                this.rbA.applyImpulse(vector3f2, vector3f9);
                vector3f9.negate(vector3f2);
                vector3f10.sub(vector3f13, this.rbB.getCenterOfMassPosition(vector3f11));
                this.rbB.applyImpulse(vector3f9, vector3f10);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2});
                ++n;
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f8, vector3f7, vector3f6, vector3f5, vector3f4});
        }
        vector3f8 = (Vector3f)Pools.VECTORS.get();
        this.rbAFrame.basis.getColumn(2, vector3f8);
        transform.basis.transform(vector3f8);
        vector3f7 = (Vector3f)Pools.VECTORS.get();
        this.rbBFrame.basis.getColumn(2, vector3f7);
        transform2.basis.transform(vector3f7);
        vector3f6 = this.getRigidBodyA().getAngularVelocity((Vector3f)Pools.VECTORS.get());
        vector3f5 = this.getRigidBodyB().getAngularVelocity((Vector3f)Pools.VECTORS.get());
        vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.scale(vector3f8.dot(vector3f6), vector3f8);
        Vector3f vector3f14 = (Vector3f)Pools.VECTORS.get();
        vector3f14.scale(vector3f7.dot(vector3f5), vector3f7);
        vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.sub(vector3f6, vector3f4);
        Vector3f vector3f15 = (Vector3f)Pools.VECTORS.get();
        vector3f15.sub(vector3f5, vector3f14);
        Vector3f vector3f16 = (Vector3f)Pools.VECTORS.get();
        vector3f16.sub(vector3f3, vector3f15);
        f6 = 1.0f;
        f5 = vector3f16.length();
        if (f5 > 1.0E-5f) {
            vector3f2 = (Vector3f)Pools.VECTORS.get();
            vector3f2.normalize(vector3f16);
            f4 = this.getRigidBodyA().computeAngularImpulseDenominator(vector3f2) + this.getRigidBodyB().computeAngularImpulseDenominator(vector3f2);
            vector3f16.scale(1.0f / f4 * this.relaxationFactor);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2});
        }
        vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.cross(vector3f8, vector3f7);
        vector3f2.negate();
        vector3f2.scale(1.0f / f);
        f4 = vector3f2.length();
        if (f4 > 1.0E-5f) {
            Vector3f vector3f17 = (Vector3f)Pools.VECTORS.get();
            vector3f17.normalize(vector3f2);
            f3 = this.getRigidBodyA().computeAngularImpulseDenominator(vector3f17) + this.getRigidBodyB().computeAngularImpulseDenominator(vector3f17);
            vector3f2.scale(1.0f / f3 * f6);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f17});
        }
        vector3f9.negate(vector3f16);
        vector3f9.add(vector3f2);
        this.rbA.applyTorqueImpulse(vector3f9);
        vector3f9.sub(vector3f16, vector3f2);
        this.rbB.applyTorqueImpulse(vector3f9);
        if (this.solveLimit) {
            vector3f9.sub(vector3f5, vector3f6);
            float f10 = (vector3f9.dot(vector3f8) * this.relaxationFactor + this.correction * (1.0f / f) * this.biasFactor) * this.limitSign;
            f3 = f10 * this.kHinge;
            f2 = this.accLimitImpulse;
            this.accLimitImpulse = Math.max(this.accLimitImpulse + f3, 0.0f);
            f3 = this.accLimitImpulse - f2;
            vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.scale(f3 * this.limitSign, vector3f8);
            this.rbA.applyTorqueImpulse(vector3f);
            vector3f9.negate(vector3f);
            this.rbB.applyTorqueImpulse(vector3f9);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2});
        if (this.enableAngularMotor) {
            Vector3f vector3f18 = (Vector3f)Pools.VECTORS.get();
            vector3f18.set(0.0f, 0.0f, 0.0f);
            Vector3f vector3f19 = (Vector3f)Pools.VECTORS.get();
            vector3f19.sub(vector3f4, vector3f14);
            float f11 = vector3f19.dot(vector3f8);
            f4 = this.motorTargetVelocity;
            float f12 = f4 - f11;
            f3 = this.kHinge * f12;
            f2 = f3 > this.maxMotorImpulse ? this.maxMotorImpulse : f3;
            f2 = f2 < -this.maxMotorImpulse ? -this.maxMotorImpulse : f2;
            vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.scale(f2, vector3f8);
            vector3f9.add(vector3f, vector3f18);
            this.rbA.applyTorqueImpulse(vector3f9);
            vector3f9.negate(vector3f);
            vector3f9.sub(vector3f18);
            this.rbB.applyTorqueImpulse(vector3f9);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f18, vector3f19, vector3f});
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f8, vector3f7, vector3f6, vector3f5, vector3f4, vector3f14, vector3f3, vector3f15, vector3f16});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f9, vector3f10, vector3f11, vector3f12, vector3f13});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
    }

    public void updateRHS(float f) {
    }

    public float getHingeAngle() {
        Transform transform = this.rbA.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get());
        Transform transform2 = this.rbB.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get());
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        this.rbAFrame.basis.getColumn(0, vector3f);
        transform.basis.transform(vector3f);
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        this.rbAFrame.basis.getColumn(1, vector3f2);
        transform.basis.transform(vector3f2);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        this.rbBFrame.basis.getColumn(1, vector3f3);
        transform2.basis.transform(vector3f3);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
        return ScalarUtil.atan2Fast(vector3f3.dot(vector3f), vector3f3.dot(vector3f2));
    }

    public void setAngularOnly(boolean bl) {
        this.angularOnly = bl;
    }

    public void enableAngularMotor(boolean bl, float f, float f2) {
        this.enableAngularMotor = bl;
        this.motorTargetVelocity = f;
        this.maxMotorImpulse = f2;
    }

    public void setLimit(float f, float f2) {
        this.setLimit(f, f2, 0.9f, 0.3f, 1.0f);
    }

    public void setLimit(float f, float f2, float f3, float f4, float f5) {
        this.lowerLimit = f;
        this.upperLimit = f2;
        this.limitSoftness = f3;
        this.biasFactor = f4;
        this.relaxationFactor = f5;
    }

    public float getLowerLimit() {
        return this.lowerLimit;
    }

    public float getUpperLimit() {
        return this.upperLimit;
    }

    public Transform getAFrame(Transform transform) {
        transform.set(this.rbAFrame);
        return transform;
    }

    public Transform getBFrame(Transform transform) {
        transform.set(this.rbBFrame);
        return transform;
    }

    public boolean getSolveLimit() {
        return this.solveLimit;
    }

    public float getLimitSign() {
        return this.limitSign;
    }

    public boolean getAngularOnly() {
        return this.angularOnly;
    }

    public boolean getEnableAngularMotor() {
        return this.enableAngularMotor;
    }

    public float getMotorTargetVelosity() {
        return this.motorTargetVelocity;
    }

    public float getMaxMotorImpulse() {
        return this.maxMotorImpulse;
    }
}

