/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.constraintsolver;

import com.bulletphysics.Pools;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.JacobianEntry;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraintType;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class Point2PointConstraint
extends TypedConstraint {
    private final JacobianEntry[] jac = new JacobianEntry[]{new JacobianEntry(), new JacobianEntry(), new JacobianEntry()};
    private final Vector3f pivotInA = new Vector3f();
    private final Vector3f pivotInB = new Vector3f();
    public ConstraintSetting setting = new ConstraintSetting();

    public Point2PointConstraint() {
        super(TypedConstraintType.POINT2POINT_CONSTRAINT_TYPE);
    }

    public Point2PointConstraint(RigidBody rigidBody, RigidBody rigidBody2, Vector3f vector3f, Vector3f vector3f2) {
        super(TypedConstraintType.POINT2POINT_CONSTRAINT_TYPE, rigidBody, rigidBody2);
        this.pivotInA.set(vector3f);
        this.pivotInB.set(vector3f2);
    }

    public Point2PointConstraint(RigidBody rigidBody, Vector3f vector3f) {
        super(TypedConstraintType.POINT2POINT_CONSTRAINT_TYPE, rigidBody);
        this.pivotInA.set(vector3f);
        this.pivotInB.set(vector3f);
        rigidBody.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get()).transform(this.pivotInB);
    }

    @Override
    public void buildJacobian() {
        this.appliedImpulse = 0.0f;
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.set(0.0f, 0.0f, 0.0f);
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get();
        Matrix3f matrix3f2 = (Matrix3f)Pools.MATRICES.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        Transform transform = this.rbA.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get());
        Transform transform2 = this.rbB.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get());
        int n = 0;
        while (n < 3) {
            VectorUtil.setCoord(vector3f, n, 1.0f);
            matrix3f.transpose(transform.basis);
            matrix3f2.transpose(transform2.basis);
            vector3f2.set(this.pivotInA);
            transform.transform(vector3f2);
            vector3f2.sub(this.rbA.getCenterOfMassPosition(vector3f4));
            vector3f3.set(this.pivotInB);
            transform2.transform(vector3f3);
            vector3f3.sub(this.rbB.getCenterOfMassPosition(vector3f4));
            this.jac[n].init(matrix3f, matrix3f2, vector3f2, vector3f3, vector3f, this.rbA.getInvInertiaDiagLocal(vector3f5), this.rbA.getInvMass(), this.rbB.getInvInertiaDiagLocal(vector3f6), this.rbB.getInvMass());
            VectorUtil.setCoord(vector3f, n, 0.0f);
            ++n;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f3, vector3f4, vector3f, vector3f5, vector3f6});
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f, matrix3f2});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
    }

    @Override
    public void solveConstraint(float f) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Transform transform = this.rbA.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get());
        Transform transform2 = this.rbB.getCenterOfMassTransform((Transform)Pools.TRANSFORMS.get());
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get((Object)this.pivotInA);
        transform.transform(vector3f4);
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get((Object)this.pivotInB);
        transform2.transform(vector3f5);
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        vector3f6.set(0.0f, 0.0f, 0.0f);
        int n = 0;
        while (n < 3) {
            VectorUtil.setCoord(vector3f6, n, 1.0f);
            float f2 = 1.0f / this.jac[n].getDiagonal();
            Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
            vector3f7.sub(vector3f4, this.rbA.getCenterOfMassPosition(vector3f3));
            Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
            vector3f8.sub(vector3f5, this.rbB.getCenterOfMassPosition(vector3f3));
            Vector3f vector3f9 = this.rbA.getVelocityInLocalPoint(vector3f7, (Vector3f)Pools.VECTORS.get());
            Vector3f vector3f10 = this.rbB.getVelocityInLocalPoint(vector3f8, (Vector3f)Pools.VECTORS.get());
            Vector3f vector3f11 = (Vector3f)Pools.VECTORS.get();
            vector3f11.sub(vector3f9, vector3f10);
            float f3 = vector3f6.dot(vector3f11);
            vector3f.sub(vector3f4, vector3f5);
            float f4 = -vector3f.dot(vector3f6);
            float f5 = f4 * this.setting.tau / f * f2 - this.setting.damping * f3 * f2;
            float f6 = this.setting.impulseClamp;
            if (f6 > 0.0f) {
                if (f5 < -f6) {
                    f5 = -f6;
                }
                if (f5 > f6) {
                    f5 = f6;
                }
            }
            this.appliedImpulse += f5;
            Vector3f vector3f12 = (Vector3f)Pools.VECTORS.get();
            vector3f12.scale(f5, vector3f6);
            vector3f.sub(vector3f4, this.rbA.getCenterOfMassPosition(vector3f3));
            this.rbA.applyImpulse(vector3f12, vector3f);
            vector3f.negate(vector3f12);
            vector3f2.sub(vector3f5, this.rbB.getCenterOfMassPosition(vector3f3));
            this.rbB.applyImpulse(vector3f, vector3f2);
            VectorUtil.setCoord(vector3f6, n, 0.0f);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f8, vector3f9, vector3f10, vector3f11, vector3f12});
            ++n;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5, vector3f4, vector3f, vector3f2, vector3f3});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
    }

    public void updateRHS(float f) {
    }

    public void setPivotA(Vector3f vector3f) {
        this.pivotInA.set(vector3f);
    }

    public void setPivotB(Vector3f vector3f) {
        this.pivotInB.set(vector3f);
    }

    public Vector3f getPivotInA(Vector3f vector3f) {
        vector3f.set(this.pivotInA);
        return vector3f;
    }

    public Vector3f getPivotInB(Vector3f vector3f) {
        vector3f.set(this.pivotInB);
        return vector3f;
    }

    public static class ConstraintSetting {
        public float tau = 0.3f;
        public float damping = 1.0f;
        public float impulseClamp = 0.0f;
    }
}

