/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.constraintsolver;

import com.bulletphysics.Pools;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.TransformUtil;
import javax.vecmath.Vector3f;

public class SolverBody {
    public final Vector3f angularVelocity = new Vector3f();
    public float angularFactor;
    public float invMass;
    public float friction;
    public RigidBody originalBody;
    public final Vector3f linearVelocity = new Vector3f();
    public final Vector3f centerOfMassPosition = new Vector3f();
    public final Vector3f pushVelocity = new Vector3f();
    public final Vector3f turnVelocity = new Vector3f();

    public void getVelocityInLocalPoint(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.cross(this.angularVelocity, vector3f);
        vector3f2.add(this.linearVelocity, vector3f3);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
    }

    public void internalApplyImpulse(Vector3f vector3f, Vector3f vector3f2, float f) {
        if (this.invMass != 0.0f) {
            this.linearVelocity.scaleAdd(f, vector3f, this.linearVelocity);
            this.angularVelocity.scaleAdd(f * this.angularFactor, vector3f2, this.angularVelocity);
        }
    }

    public void internalApplyPushImpulse(Vector3f vector3f, Vector3f vector3f2, float f) {
        if (this.invMass != 0.0f) {
            this.pushVelocity.scaleAdd(f, vector3f, this.pushVelocity);
            this.turnVelocity.scaleAdd(f * this.angularFactor, vector3f2, this.turnVelocity);
        }
    }

    public void writebackVelocity() {
        if (this.invMass != 0.0f) {
            this.originalBody.setLinearVelocity(this.linearVelocity);
            this.originalBody.setAngularVelocity(this.angularVelocity);
        }
    }

    public void writebackVelocity(float f) {
        if (this.invMass != 0.0f) {
            this.originalBody.setLinearVelocity(this.linearVelocity);
            this.originalBody.setAngularVelocity(this.angularVelocity);
            Transform transform = (Transform)Pools.TRANSFORMS.get();
            Transform transform2 = this.originalBody.getWorldTransform((Transform)Pools.TRANSFORMS.get());
            TransformUtil.integrateTransform(transform2, this.pushVelocity, this.turnVelocity, f, transform);
            this.originalBody.setWorldTransform(transform);
            Pools.TRANSFORMS.release((Object[])new Transform[]{transform2, transform});
        }
    }

    public void readVelocity() {
        if (this.invMass != 0.0f) {
            this.originalBody.getLinearVelocity(this.linearVelocity);
            this.originalBody.getAngularVelocity(this.angularVelocity);
        }
    }
}

