/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.Pools;
import com.bulletphysics.extras.gimpact.PlaneIntersectionType;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public class BoxCollision {
    public static final float BOX_PLANE_EPSILON = 1.0E-6f;

    public static boolean BT_GREATER(float f, float f2) {
        return Math.abs(f) > f2;
    }

    public static float BT_MAX3(float f, float f2, float f3) {
        return Math.max(f, Math.max(f2, f3));
    }

    public static float BT_MIN3(float f, float f2, float f3) {
        return Math.min(f, Math.min(f2, f3));
    }

    public static boolean TEST_CROSS_EDGE_BOX_MCR(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5, int n, int n2, int n3, int n4) {
        float f;
        float f2 = -VectorUtil.getCoord(vector3f, n);
        float f3 = VectorUtil.getCoord(vector3f, n2);
        float f4 = VectorUtil.getCoord(vector3f3, n3) * f2 + VectorUtil.getCoord(vector3f3, n4) * f3;
        if (f4 > (f = VectorUtil.getCoord(vector3f4, n3) * f2 + VectorUtil.getCoord(vector3f4, n4) * f3)) {
            f4 += f;
            f = f4 - f;
            f4 -= f;
        }
        float f5 = VectorUtil.getCoord(vector3f2, n);
        float f6 = VectorUtil.getCoord(vector3f2, n2);
        float f7 = VectorUtil.getCoord(vector3f5, n3) * f5 + VectorUtil.getCoord(vector3f5, n4) * f6;
        return !(f4 > f7) && !(-f7 > f);
    }

    public static boolean TEST_CROSS_EDGE_BOX_X_AXIS_MCR(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5) {
        return BoxCollision.TEST_CROSS_EDGE_BOX_MCR(vector3f, vector3f2, vector3f3, vector3f4, vector3f5, 2, 1, 1, 2);
    }

    public static boolean TEST_CROSS_EDGE_BOX_Y_AXIS_MCR(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5) {
        return BoxCollision.TEST_CROSS_EDGE_BOX_MCR(vector3f, vector3f2, vector3f3, vector3f4, vector3f5, 0, 2, 2, 0);
    }

    public static boolean TEST_CROSS_EDGE_BOX_Z_AXIS_MCR(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5) {
        return BoxCollision.TEST_CROSS_EDGE_BOX_MCR(vector3f, vector3f2, vector3f3, vector3f4, vector3f5, 1, 0, 0, 1);
    }

    public static float bt_mat3_dot_col(Matrix3f matrix3f, Vector3f vector3f, int n) {
        return vector3f.x * matrix3f.getElement(0, n) + vector3f.y * matrix3f.getElement(1, n) + vector3f.z * matrix3f.getElement(2, n);
    }

    public static boolean compareTransformsEqual(Transform transform, Transform transform2) {
        return transform.equals(transform2);
    }

    public static class AABB {
        public final Vector3f min = new Vector3f();
        public final Vector3f max = new Vector3f();

        public AABB() {
        }

        public AABB(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
            this.calc_from_triangle(vector3f, vector3f2, vector3f3);
        }

        public AABB(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f) {
            this.calc_from_triangle_margin(vector3f, vector3f2, vector3f3, f);
        }

        public AABB(AABB aABB) {
            this.set(aABB);
        }

        public AABB(AABB aABB, float f) {
            this(aABB);
            this.min.x -= f;
            this.min.y -= f;
            this.min.z -= f;
            this.max.x += f;
            this.max.y += f;
            this.max.z += f;
        }

        public void init(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f) {
            this.calc_from_triangle_margin(vector3f, vector3f2, vector3f3, f);
        }

        public void set(AABB aABB) {
            this.min.set(aABB.min);
            this.max.set(aABB.max);
        }

        public void invalidate() {
            this.min.set(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            this.max.set(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        }

        public void increment_margin(float f) {
            this.min.x -= f;
            this.min.y -= f;
            this.min.z -= f;
            this.max.x += f;
            this.max.y += f;
            this.max.z += f;
        }

        public void copy_with_margin(AABB aABB, float f) {
            this.min.x = aABB.min.x - f;
            this.min.y = aABB.min.y - f;
            this.min.z = aABB.min.z - f;
            this.max.x = aABB.max.x + f;
            this.max.y = aABB.max.y + f;
            this.max.z = aABB.max.z + f;
        }

        public void calc_from_triangle(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
            this.min.x = BoxCollision.BT_MIN3(vector3f.x, vector3f2.x, vector3f3.x);
            this.min.y = BoxCollision.BT_MIN3(vector3f.y, vector3f2.y, vector3f3.y);
            this.min.z = BoxCollision.BT_MIN3(vector3f.z, vector3f2.z, vector3f3.z);
            this.max.x = BoxCollision.BT_MAX3(vector3f.x, vector3f2.x, vector3f3.x);
            this.max.y = BoxCollision.BT_MAX3(vector3f.y, vector3f2.y, vector3f3.y);
            this.max.z = BoxCollision.BT_MAX3(vector3f.z, vector3f2.z, vector3f3.z);
        }

        public void calc_from_triangle_margin(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f) {
            this.calc_from_triangle(vector3f, vector3f2, vector3f3);
            this.min.x -= f;
            this.min.y -= f;
            this.min.z -= f;
            this.max.x += f;
            this.max.y += f;
            this.max.z += f;
        }

        public void appy_transform(Transform transform) {
            Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
            vector3f2.add(this.max, this.min);
            vector3f2.scale(0.5f);
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            vector3f3.sub(this.max, vector3f2);
            transform.transform(vector3f2);
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            transform.basis.getRow(0, vector3f);
            vector3f.absolute();
            vector3f4.x = vector3f3.dot(vector3f);
            transform.basis.getRow(1, vector3f);
            vector3f.absolute();
            vector3f4.y = vector3f3.dot(vector3f);
            transform.basis.getRow(2, vector3f);
            vector3f.absolute();
            vector3f4.z = vector3f3.dot(vector3f);
            this.min.sub(vector3f2, vector3f4);
            this.max.add(vector3f2, vector3f4);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3, vector3f4});
        }

        public void appy_transform_trans_cache(BoxBoxTransformCache boxBoxTransformCache) {
            Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
            vector3f2.add(this.max, this.min);
            vector3f2.scale(0.5f);
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            vector3f3.sub(this.max, vector3f2);
            boxBoxTransformCache.transform(vector3f2, vector3f2);
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            boxBoxTransformCache.R1to0.getRow(0, vector3f);
            vector3f.absolute();
            vector3f4.x = vector3f3.dot(vector3f);
            boxBoxTransformCache.R1to0.getRow(1, vector3f);
            vector3f.absolute();
            vector3f4.y = vector3f3.dot(vector3f);
            boxBoxTransformCache.R1to0.getRow(2, vector3f);
            vector3f.absolute();
            vector3f4.z = vector3f3.dot(vector3f);
            this.min.sub(vector3f2, vector3f4);
            this.max.add(vector3f2, vector3f4);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3, vector3f4});
        }

        public void merge(AABB aABB) {
            this.min.x = Math.min(this.min.x, aABB.min.x);
            this.min.y = Math.min(this.min.y, aABB.min.y);
            this.min.z = Math.min(this.min.z, aABB.min.z);
            this.max.x = Math.max(this.max.x, aABB.max.x);
            this.max.y = Math.max(this.max.y, aABB.max.y);
            this.max.z = Math.max(this.max.z, aABB.max.z);
        }

        public void merge_point(Vector3f vector3f) {
            this.min.x = Math.min(this.min.x, vector3f.x);
            this.min.y = Math.min(this.min.y, vector3f.y);
            this.min.z = Math.min(this.min.z, vector3f.z);
            this.max.x = Math.max(this.max.x, vector3f.x);
            this.max.y = Math.max(this.max.y, vector3f.y);
            this.max.z = Math.max(this.max.z, vector3f.z);
        }

        public void get_center_extend(Vector3f vector3f, Vector3f vector3f2) {
            vector3f.add(this.max, this.min);
            vector3f.scale(0.5f);
            vector3f2.sub(this.max, vector3f);
        }

        public void find_intersection(AABB aABB, AABB aABB2) {
            aABB2.min.x = Math.max(aABB.min.x, this.min.x);
            aABB2.min.y = Math.max(aABB.min.y, this.min.y);
            aABB2.min.z = Math.max(aABB.min.z, this.min.z);
            aABB2.max.x = Math.min(aABB.max.x, this.max.x);
            aABB2.max.y = Math.min(aABB.max.y, this.max.y);
            aABB2.max.z = Math.min(aABB.max.z, this.max.z);
        }

        public boolean has_collision(AABB aABB) {
            return !(this.min.x > aABB.max.x || this.max.x < aABB.min.x || this.min.y > aABB.max.y || this.max.y < aABB.min.y || this.min.z > aABB.max.z) && !(this.max.z < aABB.min.z);
        }

        /*
         * Unable to fully structure code
         */
        public boolean collide_ray(Vector3f var1_1, Vector3f var2_2) {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                var3_3 = (Vector3f)Pools.VECTORS.get();
                                var4_4 = (Vector3f)Pools.VECTORS.get();
                                this.get_center_extend(var4_4, var3_3);
                                try {
                                    var5_5 = var1_1.x - var4_4.x;
                                    if (!BoxCollision.BT_GREATER(var5_5, var3_3.x) || !(var5_5 * var2_2.x >= 0.0f)) break block8;
                                }
                                catch (Throwable var9_9) {
                                    Pools.VECTORS.release((Object[])new Vector3f[]{var4_4, var3_3});
                                    throw var9_9;
                                }
                                Pools.VECTORS.release((Object[])new Vector3f[]{var4_4, var3_3});
                                return false;
                            }
                            var6_6 = var1_1.y - var4_4.y;
                            if (!BoxCollision.BT_GREATER(var6_6, var3_3.y) || !(var6_6 * var2_2.y >= 0.0f)) break block9;
                            Pools.VECTORS.release((Object[])new Vector3f[]{var4_4, var3_3});
                            return false;
                        }
                        var7_7 = var1_1.z - var4_4.z;
                        if (!BoxCollision.BT_GREATER(var7_7, var3_3.z) || !(var7_7 * var2_2.z >= 0.0f)) break block10;
                        Pools.VECTORS.release((Object[])new Vector3f[]{var4_4, var3_3});
                        return false;
                    }
                    var8_8 = var2_2.y * var7_7 - var2_2.z * var6_6;
                    if (!(Math.abs(var8_8) > var3_3.y * Math.abs(var2_2.z) + var3_3.z * Math.abs(var2_2.y))) break block11;
                    Pools.VECTORS.release((Object[])new Vector3f[]{var4_4, var3_3});
                    return false;
                }
                var8_8 = var2_2.z * var5_5 - var2_2.x * var7_7;
                if (!(Math.abs(var8_8) > var3_3.x * Math.abs(var2_2.z) + var3_3.z * Math.abs(var2_2.x))) break block12;
                Pools.VECTORS.release((Object[])new Vector3f[]{var4_4, var3_3});
                return false;
            }
            var8_8 = var2_2.x * var6_6 - var2_2.y * var5_5;
            ** if (!(Math.abs((float)var8_8) > var3_3.x * Math.abs((float)var2_2.y) + var3_3.y * Math.abs((float)var2_2.x))) goto lbl43
lbl-1000:
            // 1 sources

            {
                Pools.VECTORS.release((Object[])new Vector3f[]{var4_4, var3_3});
                return false;
            }
            {
            }
lbl43:
            // 1 sources

            Pools.VECTORS.release((Object[])new Vector3f[]{var4_4, var3_3});
            return true;
        }

        public void projection_interval(Vector3f vector3f, float[] fArray, float[] fArray2) {
            Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            this.get_center_extend(vector3f3, vector3f4);
            float f = vector3f.dot(vector3f3);
            vector3f2.absolute(vector3f);
            float f2 = vector3f4.dot(vector3f2);
            fArray[0] = f - f2;
            fArray2[0] = f + f2;
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f3, vector3f4});
        }

        public PlaneIntersectionType plane_classify(Vector4f vector4f) {
            Vector3f vector3f;
            block5: {
                float[] fArray;
                block4: {
                    PlaneIntersectionType planeIntersectionType;
                    vector3f = (Vector3f)Pools.VECTORS.get();
                    try {
                        fArray = new float[1];
                        float[] fArray2 = new float[1];
                        vector3f.set(vector4f.x, vector4f.y, vector4f.z);
                        this.projection_interval(vector3f, fArray, fArray2);
                        if (!(vector4f.w > fArray2[0] + 1.0E-6f)) break block4;
                        planeIntersectionType = PlaneIntersectionType.BACK_PLANE;
                    }
                    catch (Throwable throwable) {
                        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
                        throw throwable;
                    }
                    Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
                    return planeIntersectionType;
                }
                if (!(vector4f.w + 1.0E-6f >= fArray[0])) break block5;
                PlaneIntersectionType planeIntersectionType = PlaneIntersectionType.COLLIDE_PLANE;
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
                return planeIntersectionType;
            }
            PlaneIntersectionType planeIntersectionType = PlaneIntersectionType.FRONT_PLANE;
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
            return planeIntersectionType;
        }

        public boolean overlapping_trans_conservative(AABB aABB, Transform transform) {
            AABB aABB2 = (AABB)Pools.AABBS.get((Object)aABB);
            aABB2.appy_transform(transform);
            Pools.AABBS.release((Object[])new AABB[]{aABB2});
            return this.has_collision(aABB2);
        }

        public boolean overlapping_trans_conservative2(AABB aABB, BoxBoxTransformCache boxBoxTransformCache) {
            AABB aABB2 = (AABB)Pools.AABBS.get((Object)aABB);
            aABB2.appy_transform_trans_cache(boxBoxTransformCache);
            Pools.AABBS.release((Object[])new AABB[]{aABB2});
            return this.has_collision(aABB2);
        }

        /*
         * Exception decompiling
         */
        public boolean overlapping_trans_cache(AABB var1_1, BoxBoxTransformCache var2_2, boolean var3_3) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean collide_plane(Vector4f vector4f) {
            PlaneIntersectionType planeIntersectionType = this.plane_classify(vector4f);
            return planeIntersectionType == PlaneIntersectionType.COLLIDE_PLANE;
        }

        public boolean collide_triangle_exact(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector4f vector4f) {
            if (!this.collide_plane(vector4f)) {
                return false;
            }
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
            this.get_center_extend(vector3f4, vector3f5);
            Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
            vector3f6.sub(vector3f, vector3f4);
            Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
            vector3f7.sub(vector3f2, vector3f4);
            Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
            vector3f8.sub(vector3f3, vector3f4);
            Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
            vector3f9.sub(vector3f7, vector3f6);
            Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
            vector3f10.absolute(vector3f9);
            BoxCollision.TEST_CROSS_EDGE_BOX_X_AXIS_MCR(vector3f9, vector3f10, vector3f6, vector3f8, vector3f5);
            BoxCollision.TEST_CROSS_EDGE_BOX_Y_AXIS_MCR(vector3f9, vector3f10, vector3f6, vector3f8, vector3f5);
            BoxCollision.TEST_CROSS_EDGE_BOX_Z_AXIS_MCR(vector3f9, vector3f10, vector3f6, vector3f8, vector3f5);
            vector3f9.sub(vector3f8, vector3f7);
            vector3f10.absolute(vector3f9);
            BoxCollision.TEST_CROSS_EDGE_BOX_X_AXIS_MCR(vector3f9, vector3f10, vector3f7, vector3f6, vector3f5);
            BoxCollision.TEST_CROSS_EDGE_BOX_Y_AXIS_MCR(vector3f9, vector3f10, vector3f7, vector3f6, vector3f5);
            BoxCollision.TEST_CROSS_EDGE_BOX_Z_AXIS_MCR(vector3f9, vector3f10, vector3f7, vector3f6, vector3f5);
            vector3f9.sub(vector3f6, vector3f8);
            vector3f10.absolute(vector3f9);
            BoxCollision.TEST_CROSS_EDGE_BOX_X_AXIS_MCR(vector3f9, vector3f10, vector3f8, vector3f7, vector3f5);
            BoxCollision.TEST_CROSS_EDGE_BOX_Y_AXIS_MCR(vector3f9, vector3f10, vector3f8, vector3f7, vector3f5);
            BoxCollision.TEST_CROSS_EDGE_BOX_Z_AXIS_MCR(vector3f9, vector3f10, vector3f8, vector3f7, vector3f5);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f7, vector3f8, vector3f9, vector3f10, vector3f4, vector3f5});
            return true;
        }
    }

    public static class BoxBoxTransformCache {
        public final Vector3f T1to0 = new Vector3f();
        public final Matrix3f R1to0 = new Matrix3f();
        public final Matrix3f AR = new Matrix3f();

        public void set(BoxBoxTransformCache boxBoxTransformCache) {
            throw new UnsupportedOperationException();
        }

        public void calc_absolute_matrix() {
            int n = 0;
            while (n < 3) {
                int n2 = 0;
                while (n2 < 3) {
                    this.AR.setElement(n, n2, 1.0E-6f + Math.abs(this.R1to0.getElement(n, n2)));
                    ++n2;
                }
                ++n;
            }
        }

        public void calc_from_homogenic(Transform transform, Transform transform2) {
            Transform transform3 = (Transform)Pools.TRANSFORMS.get();
            transform3.inverse(transform);
            transform3.mul(transform2);
            this.T1to0.set(transform3.origin);
            this.R1to0.set(transform3.basis);
            this.calc_absolute_matrix();
            Pools.TRANSFORMS.release((Object[])new Transform[]{transform3});
        }

        public void calc_from_full_invert(Transform transform, Transform transform2) {
            this.R1to0.invert(transform.basis);
            this.T1to0.negate(transform.origin);
            this.R1to0.transform(this.T1to0);
            Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.set(transform2.origin);
            this.R1to0.transform(vector3f);
            this.T1to0.add(vector3f);
            this.R1to0.mul(transform2.basis);
            this.calc_absolute_matrix();
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        }

        public Vector3f transform(Vector3f vector3f, Vector3f vector3f2) {
            if (vector3f == vector3f2) {
                vector3f = (Vector3f)Pools.VECTORS.get((Object)vector3f);
            }
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            this.R1to0.getRow(0, vector3f3);
            vector3f2.x = vector3f3.dot(vector3f) + this.T1to0.x;
            this.R1to0.getRow(1, vector3f3);
            vector3f2.y = vector3f3.dot(vector3f) + this.T1to0.y;
            this.R1to0.getRow(2, vector3f3);
            vector3f2.z = vector3f3.dot(vector3f) + this.T1to0.z;
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
            return vector3f2;
        }
    }
}

