/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.broadphase.CollisionAlgorithm;
import com.bulletphysics.collision.broadphase.CollisionAlgorithmConstructionInfo;
import com.bulletphysics.collision.dispatch.CollisionAlgorithmCreateFunc;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.ManifoldResult;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.CompoundShape;
import com.bulletphysics.collision.shapes.ConcaveShape;
import com.bulletphysics.collision.shapes.StaticPlaneShape;
import com.bulletphysics.extras.gimpact.BoxCollision;
import com.bulletphysics.extras.gimpact.GIM_ShapeRetriever;
import com.bulletphysics.extras.gimpact.GImpactBvh;
import com.bulletphysics.extras.gimpact.GImpactMeshShape;
import com.bulletphysics.extras.gimpact.GImpactMeshShapePart;
import com.bulletphysics.extras.gimpact.GImpactShapeInterface;
import com.bulletphysics.extras.gimpact.GImpactTriangleCallback;
import com.bulletphysics.extras.gimpact.Pair;
import com.bulletphysics.extras.gimpact.PairSet;
import com.bulletphysics.extras.gimpact.PlaneIntersectionType;
import com.bulletphysics.extras.gimpact.PlaneShape;
import com.bulletphysics.extras.gimpact.PrimitiveTriangle;
import com.bulletphysics.extras.gimpact.ShapeType;
import com.bulletphysics.extras.gimpact.TriangleContact;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import com.bulletphysics.util.IntArrayList;
import gama.core.common.util.PoolUtils;
import java.util.ArrayList;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public class GImpactCollisionAlgorithm
extends CollisionAlgorithm {
    protected CollisionAlgorithm convex_algorithm;
    protected PersistentManifold manifoldPtr;
    protected ManifoldResult resultOut;
    protected int triface0;
    protected int part0;
    protected int triface1;
    protected int part1;
    private final PairSet tmpPairset = new PairSet();

    public void init(CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2) {
        super.init(collisionAlgorithmConstructionInfo);
        this.manifoldPtr = null;
        this.convex_algorithm = null;
    }

    @Override
    public void destroy() {
        this.clearCache();
    }

    @Override
    public void processCollision(CollisionObject collisionObject, CollisionObject collisionObject2, ManifoldResult manifoldResult) {
        this.clearCache();
        this.resultOut = manifoldResult;
        if (collisionObject.getCollisionShape().getShapeType() == BroadphaseNativeType.GIMPACT_SHAPE_PROXYTYPE) {
            GImpactShapeInterface gImpactShapeInterface = (GImpactShapeInterface)collisionObject.getCollisionShape();
            if (collisionObject2.getCollisionShape().getShapeType() == BroadphaseNativeType.GIMPACT_SHAPE_PROXYTYPE) {
                GImpactShapeInterface gImpactShapeInterface2 = (GImpactShapeInterface)collisionObject2.getCollisionShape();
                this.gimpact_vs_gimpact(collisionObject, collisionObject2, gImpactShapeInterface, gImpactShapeInterface2);
            } else {
                this.gimpact_vs_shape(collisionObject, collisionObject2, gImpactShapeInterface, collisionObject2.getCollisionShape(), false);
            }
        } else if (collisionObject2.getCollisionShape().getShapeType() == BroadphaseNativeType.GIMPACT_SHAPE_PROXYTYPE) {
            GImpactShapeInterface gImpactShapeInterface = (GImpactShapeInterface)collisionObject2.getCollisionShape();
            this.gimpact_vs_shape(collisionObject2, collisionObject, gImpactShapeInterface, collisionObject.getCollisionShape(), true);
        }
    }

    public void gimpact_vs_gimpact(CollisionObject collisionObject, CollisionObject collisionObject2, GImpactShapeInterface gImpactShapeInterface, GImpactShapeInterface gImpactShapeInterface2) {
        if (gImpactShapeInterface.getGImpactShapeType() == ShapeType.TRIMESH_SHAPE) {
            GImpactMeshShape gImpactMeshShape = (GImpactMeshShape)gImpactShapeInterface;
            this.part0 = gImpactMeshShape.getMeshPartCount();
            while (this.part0-- != 0) {
                this.gimpact_vs_gimpact(collisionObject, collisionObject2, gImpactMeshShape.getMeshPart(this.part0), gImpactShapeInterface2);
            }
            return;
        }
        if (gImpactShapeInterface2.getGImpactShapeType() == ShapeType.TRIMESH_SHAPE) {
            GImpactMeshShape gImpactMeshShape = (GImpactMeshShape)gImpactShapeInterface2;
            this.part1 = gImpactMeshShape.getMeshPartCount();
            while (this.part1-- != 0) {
                this.gimpact_vs_gimpact(collisionObject, collisionObject2, gImpactShapeInterface, gImpactMeshShape.getMeshPart(this.part1));
            }
            return;
        }
        Transform transform = collisionObject.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        Transform transform2 = collisionObject2.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        PairSet pairSet = this.tmpPairset;
        pairSet.clear();
        this.gimpact_vs_gimpact_find_pairs(transform, transform2, gImpactShapeInterface, gImpactShapeInterface2, pairSet);
        if (pairSet.size() == 0) {
            return;
        }
        if (gImpactShapeInterface.getGImpactShapeType() == ShapeType.TRIMESH_SHAPE_PART && gImpactShapeInterface2.getGImpactShapeType() == ShapeType.TRIMESH_SHAPE_PART) {
            GImpactMeshShapePart gImpactMeshShapePart = (GImpactMeshShapePart)gImpactShapeInterface;
            GImpactMeshShapePart gImpactMeshShapePart2 = (GImpactMeshShapePart)gImpactShapeInterface2;
            this.collide_sat_triangles(collisionObject, collisionObject2, gImpactMeshShapePart, gImpactMeshShapePart2, pairSet, pairSet.size());
            return;
        }
        gImpactShapeInterface.lockChildShapes();
        gImpactShapeInterface2.lockChildShapes();
        GIM_ShapeRetriever gIM_ShapeRetriever = new GIM_ShapeRetriever(gImpactShapeInterface);
        GIM_ShapeRetriever gIM_ShapeRetriever2 = new GIM_ShapeRetriever(gImpactShapeInterface2);
        boolean bl = gImpactShapeInterface.childrenHasTransform();
        boolean bl2 = gImpactShapeInterface2.childrenHasTransform();
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        int n = pairSet.size();
        while (n-- != 0) {
            Pair pair = pairSet.get(n);
            this.triface0 = pair.index1;
            this.triface1 = pair.index2;
            CollisionShape collisionShape = gIM_ShapeRetriever.getChildShape(this.triface0);
            CollisionShape collisionShape2 = gIM_ShapeRetriever2.getChildShape(this.triface1);
            if (bl) {
                transform3.mul(transform, gImpactShapeInterface.getChildTransform(this.triface0));
                collisionObject.setWorldTransform(transform3);
            }
            if (bl2) {
                transform3.mul(transform2, gImpactShapeInterface2.getChildTransform(this.triface1));
                collisionObject2.setWorldTransform(transform3);
            }
            this.convex_vs_convex_collision(collisionObject, collisionObject2, collisionShape, collisionShape2);
            if (bl) {
                collisionObject.setWorldTransform(transform);
            }
            if (!bl2) continue;
            collisionObject2.setWorldTransform(transform2);
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform3, transform, transform2});
        gImpactShapeInterface.unlockChildShapes();
        gImpactShapeInterface2.unlockChildShapes();
    }

    public void gimpact_vs_shape(CollisionObject collisionObject, CollisionObject collisionObject2, GImpactShapeInterface gImpactShapeInterface, CollisionShape collisionShape, boolean bl) {
        if (gImpactShapeInterface.getGImpactShapeType() == ShapeType.TRIMESH_SHAPE) {
            GImpactMeshShape gImpactMeshShape = (GImpactMeshShape)gImpactShapeInterface;
            this.part0 = gImpactMeshShape.getMeshPartCount();
            while (this.part0-- != 0) {
                this.gimpact_vs_shape(collisionObject, collisionObject2, gImpactMeshShape.getMeshPart(this.part0), collisionShape, bl);
            }
            return;
        }
        if (gImpactShapeInterface.getGImpactShapeType() == ShapeType.TRIMESH_SHAPE_PART && collisionShape.getShapeType() == BroadphaseNativeType.STATIC_PLANE_PROXYTYPE) {
            GImpactMeshShapePart gImpactMeshShapePart = (GImpactMeshShapePart)gImpactShapeInterface;
            StaticPlaneShape staticPlaneShape = (StaticPlaneShape)collisionShape;
            this.gimpacttrimeshpart_vs_plane_collision(collisionObject, collisionObject2, gImpactMeshShapePart, staticPlaneShape, bl);
            return;
        }
        if (collisionShape.isCompound()) {
            CompoundShape compoundShape = (CompoundShape)collisionShape;
            this.gimpact_vs_compoundshape(collisionObject, collisionObject2, gImpactShapeInterface, compoundShape, bl);
            return;
        }
        if (collisionShape.isConcave()) {
            ConcaveShape concaveShape = (ConcaveShape)collisionShape;
            this.gimpact_vs_concave(collisionObject, collisionObject2, gImpactShapeInterface, concaveShape, bl);
            return;
        }
        Transform transform = collisionObject.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        Transform transform2 = collisionObject2.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        IntArrayList intArrayList = new IntArrayList();
        this.gimpact_vs_shape_find_pairs(transform, transform2, gImpactShapeInterface, collisionShape, intArrayList);
        if (intArrayList.size() == 0) {
            return;
        }
        gImpactShapeInterface.lockChildShapes();
        GIM_ShapeRetriever gIM_ShapeRetriever = new GIM_ShapeRetriever(gImpactShapeInterface);
        boolean bl2 = gImpactShapeInterface.childrenHasTransform();
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        int n = intArrayList.size();
        while (n-- != 0) {
            int n2 = intArrayList.get(n);
            if (bl) {
                this.triface1 = n2;
            } else {
                this.triface0 = n2;
            }
            CollisionShape collisionShape2 = gIM_ShapeRetriever.getChildShape(n2);
            if (bl2) {
                transform3.mul(transform, gImpactShapeInterface.getChildTransform(n2));
                collisionObject.setWorldTransform(transform3);
            }
            if (bl) {
                this.shape_vs_shape_collision(collisionObject2, collisionObject, collisionShape, collisionShape2);
            } else {
                this.shape_vs_shape_collision(collisionObject, collisionObject2, collisionShape2, collisionShape);
            }
            if (!bl2) continue;
            collisionObject.setWorldTransform(transform);
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform3, transform, transform2});
        gImpactShapeInterface.unlockChildShapes();
    }

    public void gimpact_vs_compoundshape(CollisionObject collisionObject, CollisionObject collisionObject2, GImpactShapeInterface gImpactShapeInterface, CompoundShape compoundShape, boolean bl) {
        Transform transform = collisionObject2.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        Transform transform2 = (Transform)Pools.TRANSFORMS.get();
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        int n = compoundShape.getNumChildShapes();
        while (n-- != 0) {
            CollisionShape collisionShape = compoundShape.getChildShape(n);
            transform2.mul(transform, compoundShape.getChildTransform(n, transform3));
            collisionObject2.setWorldTransform(transform2);
            this.gimpact_vs_shape(collisionObject, collisionObject2, gImpactShapeInterface, collisionShape, bl);
            collisionObject2.setWorldTransform(transform);
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform2, transform3, transform});
    }

    public void gimpact_vs_concave(CollisionObject collisionObject, CollisionObject collisionObject2, GImpactShapeInterface gImpactShapeInterface, ConcaveShape concaveShape, boolean bl) {
        GImpactTriangleCallback gImpactTriangleCallback = new GImpactTriangleCallback();
        gImpactTriangleCallback.algorithm = this;
        gImpactTriangleCallback.body0 = collisionObject;
        gImpactTriangleCallback.body1 = collisionObject2;
        gImpactTriangleCallback.gimpactshape0 = gImpactShapeInterface;
        gImpactTriangleCallback.swapped = bl;
        gImpactTriangleCallback.margin = concaveShape.getMargin();
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        collisionObject2.getWorldTransform(transform);
        transform.inverse();
        Transform transform2 = collisionObject.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        transform.mul(transform2);
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        gImpactShapeInterface.getAabb(transform, vector3f, vector3f2);
        concaveShape.processAllTriangles(gImpactTriangleCallback, vector3f, vector3f2);
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
    }

    protected PersistentManifold newContactManifold(CollisionObject collisionObject, CollisionObject collisionObject2) {
        this.manifoldPtr = this.dispatcher.getNewManifold(collisionObject, collisionObject2);
        return this.manifoldPtr;
    }

    protected void destroyConvexAlgorithm() {
        if (this.convex_algorithm != null) {
            this.dispatcher.freeCollisionAlgorithm(this.convex_algorithm);
            this.convex_algorithm = null;
        }
    }

    protected void destroyContactManifolds() {
        if (this.manifoldPtr == null) {
            return;
        }
        this.dispatcher.releaseManifold(this.manifoldPtr);
        this.manifoldPtr = null;
    }

    protected void clearCache() {
        this.destroyContactManifolds();
        this.destroyConvexAlgorithm();
        this.triface0 = -1;
        this.part0 = -1;
        this.triface1 = -1;
        this.part1 = -1;
    }

    protected PersistentManifold getLastManifold() {
        return this.manifoldPtr;
    }

    protected void checkManifold(CollisionObject collisionObject, CollisionObject collisionObject2) {
        if (this.getLastManifold() == null) {
            this.newContactManifold(collisionObject, collisionObject2);
        }
        this.resultOut.setPersistentManifold(this.getLastManifold());
    }

    protected CollisionAlgorithm newAlgorithm(CollisionObject collisionObject, CollisionObject collisionObject2) {
        this.checkManifold(collisionObject, collisionObject2);
        CollisionAlgorithm collisionAlgorithm = this.dispatcher.findAlgorithm(collisionObject, collisionObject2, this.getLastManifold());
        return collisionAlgorithm;
    }

    protected void checkConvexAlgorithm(CollisionObject collisionObject, CollisionObject collisionObject2) {
        if (this.convex_algorithm != null) {
            return;
        }
        this.convex_algorithm = this.newAlgorithm(collisionObject, collisionObject2);
    }

    protected void addContactPoint(CollisionObject collisionObject, CollisionObject collisionObject2, Vector3f vector3f, Vector3f vector3f2, float f) {
        this.resultOut.setShapeIdentifiers(this.part0, this.triface0, this.part1, this.triface1);
        this.checkManifold(collisionObject, collisionObject2);
        this.resultOut.addContactPoint(vector3f2, vector3f, f);
    }

    void collide_sat_triangles(CollisionObject collisionObject, CollisionObject collisionObject2, GImpactMeshShapePart gImpactMeshShapePart, GImpactMeshShapePart gImpactMeshShapePart2, PairSet pairSet, int n) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Transform transform = collisionObject.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        Transform transform2 = collisionObject2.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        PrimitiveTriangle primitiveTriangle = (PrimitiveTriangle)Pools.TRIANGLES.get();
        PrimitiveTriangle primitiveTriangle2 = (PrimitiveTriangle)Pools.TRIANGLES.get();
        TriangleContact triangleContact = (TriangleContact)Pools.CONTACTS.get();
        gImpactMeshShapePart.lockChildShapes();
        gImpactMeshShapePart2.lockChildShapes();
        int n2 = 0;
        while (n-- != 0) {
            Pair pair = pairSet.get(n2++);
            this.triface0 = pair.index1;
            this.triface1 = pair.index2;
            gImpactMeshShapePart.getPrimitiveTriangle(this.triface0, primitiveTriangle);
            gImpactMeshShapePart2.getPrimitiveTriangle(this.triface1, primitiveTriangle2);
            primitiveTriangle.applyTransform(transform);
            primitiveTriangle2.applyTransform(transform2);
            primitiveTriangle.buildTriPlane();
            primitiveTriangle2.buildTriPlane();
            if (!primitiveTriangle.overlap_test_conservative(primitiveTriangle2) || !primitiveTriangle.find_triangle_collision_clip_method(primitiveTriangle2, triangleContact)) continue;
            int n3 = triangleContact.point_count;
            while (n3-- != 0) {
                vector3f.x = triangleContact.separating_normal.x;
                vector3f.y = triangleContact.separating_normal.y;
                vector3f.z = triangleContact.separating_normal.z;
                this.addContactPoint(collisionObject, collisionObject2, triangleContact.points[n3], vector3f, -triangleContact.penetration_depth);
            }
        }
        Pools.CONTACTS.release((Object[])new TriangleContact[]{triangleContact});
        Pools.TRIANGLES.release((Object[])new PrimitiveTriangle[]{primitiveTriangle, primitiveTriangle2});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        gImpactMeshShapePart.unlockChildShapes();
        gImpactMeshShapePart2.unlockChildShapes();
    }

    protected void shape_vs_shape_collision(CollisionObject collisionObject, CollisionObject collisionObject2, CollisionShape collisionShape, CollisionShape collisionShape2) {
        CollisionShape collisionShape3 = collisionObject.getCollisionShape();
        CollisionShape collisionShape4 = collisionObject2.getCollisionShape();
        collisionObject.internalSetTemporaryCollisionShape(collisionShape);
        collisionObject2.internalSetTemporaryCollisionShape(collisionShape2);
        CollisionAlgorithm collisionAlgorithm = this.newAlgorithm(collisionObject, collisionObject2);
        this.resultOut.setShapeIdentifiers(this.part0, this.triface0, this.part1, this.triface1);
        collisionAlgorithm.processCollision(collisionObject, collisionObject2, this.resultOut);
        this.dispatcher.freeCollisionAlgorithm(collisionAlgorithm);
        collisionObject.internalSetTemporaryCollisionShape(collisionShape3);
        collisionObject2.internalSetTemporaryCollisionShape(collisionShape4);
    }

    protected void convex_vs_convex_collision(CollisionObject collisionObject, CollisionObject collisionObject2, CollisionShape collisionShape, CollisionShape collisionShape2) {
        CollisionShape collisionShape3 = collisionObject.getCollisionShape();
        CollisionShape collisionShape4 = collisionObject2.getCollisionShape();
        collisionObject.internalSetTemporaryCollisionShape(collisionShape);
        collisionObject2.internalSetTemporaryCollisionShape(collisionShape2);
        this.resultOut.setShapeIdentifiers(this.part0, this.triface0, this.part1, this.triface1);
        this.checkConvexAlgorithm(collisionObject, collisionObject2);
        this.convex_algorithm.processCollision(collisionObject, collisionObject2, this.resultOut);
        collisionObject.internalSetTemporaryCollisionShape(collisionShape3);
        collisionObject2.internalSetTemporaryCollisionShape(collisionShape4);
    }

    void gimpact_vs_gimpact_find_pairs(Transform transform, Transform transform2, GImpactShapeInterface gImpactShapeInterface, GImpactShapeInterface gImpactShapeInterface2, PairSet pairSet) {
        if (gImpactShapeInterface.hasBoxSet() && gImpactShapeInterface2.hasBoxSet()) {
            GImpactBvh.find_collision(gImpactShapeInterface.getBoxSet(), transform, gImpactShapeInterface2.getBoxSet(), transform2, pairSet);
        } else {
            BoxCollision.AABB aABB = (BoxCollision.AABB)Pools.AABBS.get();
            BoxCollision.AABB aABB2 = (BoxCollision.AABB)Pools.AABBS.get();
            int n = gImpactShapeInterface.getNumChildShapes();
            while (n-- != 0) {
                gImpactShapeInterface.getChildAabb(n, transform, aABB.min, aABB.max);
                int n2 = gImpactShapeInterface2.getNumChildShapes();
                while (n2-- != 0) {
                    gImpactShapeInterface2.getChildAabb(n, transform2, aABB2.min, aABB2.max);
                    if (!aABB2.has_collision(aABB)) continue;
                    pairSet.push_pair(n, n2);
                }
            }
            Pools.AABBS.release((Object[])new BoxCollision.AABB[]{aABB, aABB2});
        }
    }

    protected void gimpact_vs_shape_find_pairs(Transform transform, Transform transform2, GImpactShapeInterface gImpactShapeInterface, CollisionShape collisionShape, IntArrayList intArrayList) {
        BoxCollision.AABB aABB = (BoxCollision.AABB)Pools.AABBS.get();
        if (gImpactShapeInterface.hasBoxSet()) {
            Transform transform3 = (Transform)Pools.TRANSFORMS.get();
            transform3.inverse(transform);
            transform3.mul(transform2);
            collisionShape.getAabb(transform3, aABB.min, aABB.max);
            gImpactShapeInterface.getBoxSet().boxQuery(aABB, intArrayList);
            Pools.TRANSFORMS.release((Object[])new Transform[]{transform3});
        } else {
            collisionShape.getAabb(transform2, aABB.min, aABB.max);
            BoxCollision.AABB aABB2 = (BoxCollision.AABB)Pools.AABBS.get();
            int n = gImpactShapeInterface.getNumChildShapes();
            while (n-- != 0) {
                gImpactShapeInterface.getChildAabb(n, transform, aABB2.min, aABB2.max);
                if (!aABB.has_collision(aABB2)) continue;
                intArrayList.add(n);
            }
            Pools.AABBS.release((Object[])new BoxCollision.AABB[]{aABB2});
        }
        Pools.AABBS.release((Object[])new BoxCollision.AABB[]{aABB});
    }

    protected void gimpacttrimeshpart_vs_plane_collision(CollisionObject collisionObject, CollisionObject collisionObject2, GImpactMeshShapePart gImpactMeshShapePart, StaticPlaneShape staticPlaneShape, boolean bl) {
        Transform transform = collisionObject.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        Transform transform2 = collisionObject2.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        StaticPlaneShape staticPlaneShape2 = staticPlaneShape;
        Vector4f vector4f = (Vector4f)Pools.VECTORS4.get();
        PlaneShape.get_plane_equation_transformed(staticPlaneShape2, transform2, vector4f);
        BoxCollision.AABB aABB = (BoxCollision.AABB)Pools.AABBS.get();
        gImpactMeshShapePart.getAabb(transform, aABB.min, aABB.max);
        aABB.increment_margin(staticPlaneShape2.getMargin());
        if (aABB.plane_classify(vector4f) != PlaneIntersectionType.COLLIDE_PLANE) {
            return;
        }
        gImpactMeshShapePart.lockChildShapes();
        float f = gImpactMeshShapePart.getMargin() + staticPlaneShape2.getMargin();
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        int n = gImpactMeshShapePart.getVertexCount();
        while (n-- != 0) {
            gImpactMeshShapePart.getVertex(n, vector3f);
            transform.transform(vector3f);
            float f2 = VectorUtil.dot3(vector3f, vector4f) - vector4f.w - f;
            if (!(f2 < 0.0f)) continue;
            if (bl) {
                vector3f2.set(-vector4f.x, -vector4f.y, -vector4f.z);
                this.addContactPoint(collisionObject2, collisionObject, vector3f, vector3f2, f2);
                continue;
            }
            vector3f2.set(vector4f.x, vector4f.y, vector4f.z);
            this.addContactPoint(collisionObject, collisionObject2, vector3f, vector3f2, f2);
        }
        gImpactMeshShapePart.unlockChildShapes();
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
        Pools.AABBS.release((Object[])new BoxCollision.AABB[]{aABB});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
        Pools.VECTORS4.release((Object[])new Vector4f[]{vector4f});
    }

    public void setFace0(int n) {
        this.triface0 = n;
    }

    public int getFace0() {
        return this.triface0;
    }

    public void setFace1(int n) {
        this.triface1 = n;
    }

    public int getFace1() {
        return this.triface1;
    }

    public void setPart0(int n) {
        this.part0 = n;
    }

    public int getPart0() {
        return this.part0;
    }

    public void setPart1(int n) {
        this.part1 = n;
    }

    public int getPart1() {
        return this.part1;
    }

    @Override
    public float calculateTimeOfImpact(CollisionObject collisionObject, CollisionObject collisionObject2, ManifoldResult manifoldResult) {
        return 1.0f;
    }

    @Override
    public void getAllContactManifolds(ArrayList<PersistentManifold> arrayList) {
        if (this.manifoldPtr != null) {
            arrayList.add(this.manifoldPtr);
        }
    }

    public static void registerAlgorithm(CollisionDispatcher collisionDispatcher) {
        CreateFunc createFunc = new CreateFunc();
        int n = 0;
        while (n < BroadphaseNativeType.MAX_BROADPHASE_COLLISION_TYPES.ordinal()) {
            collisionDispatcher.registerCollisionCreateFunc(BroadphaseNativeType.GIMPACT_SHAPE_PROXYTYPE.ordinal(), n, createFunc);
            ++n;
        }
        n = 0;
        while (n < BroadphaseNativeType.MAX_BROADPHASE_COLLISION_TYPES.ordinal()) {
            collisionDispatcher.registerCollisionCreateFunc(n, BroadphaseNativeType.GIMPACT_SHAPE_PROXYTYPE.ordinal(), createFunc);
            ++n;
        }
    }

    public static class CreateFunc
    implements CollisionAlgorithmCreateFunc {
        private static final PoolUtils.ObjectPool<GImpactCollisionAlgorithm> POOL = PoolUtils.create((String)"GImpactCollisionAlgorithms", (boolean)true, () -> new GImpactCollisionAlgorithm(), null, null);

        @Override
        public CollisionAlgorithm createCollisionAlgorithm(CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2) {
            GImpactCollisionAlgorithm gImpactCollisionAlgorithm = (GImpactCollisionAlgorithm)POOL.get();
            gImpactCollisionAlgorithm.init(collisionAlgorithmConstructionInfo, collisionObject, collisionObject2);
            return gImpactCollisionAlgorithm;
        }

        @Override
        public void releaseCollisionAlgorithm(CollisionAlgorithm collisionAlgorithm) {
            POOL.release((Object[])new GImpactCollisionAlgorithm[]{(GImpactCollisionAlgorithm)collisionAlgorithm});
        }
    }
}

