/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.StridingMeshInterface;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.extras.gimpact.BoxCollision;
import com.bulletphysics.extras.gimpact.GImpactMassUtil;
import com.bulletphysics.extras.gimpact.GImpactShapeInterface;
import com.bulletphysics.extras.gimpact.PrimitiveManagerBase;
import com.bulletphysics.extras.gimpact.PrimitiveTriangle;
import com.bulletphysics.extras.gimpact.ShapeType;
import com.bulletphysics.extras.gimpact.TetrahedronShapeEx;
import com.bulletphysics.extras.gimpact.TriangleShapeEx;
import com.bulletphysics.extras.gimpact.TrimeshPrimitiveManager;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.util.IntArrayList;
import javax.vecmath.Vector3f;

public class GImpactMeshShapePart
extends GImpactShapeInterface {
    TrimeshPrimitiveManager primitive_manager = new TrimeshPrimitiveManager();
    private final IntArrayList collided = new IntArrayList();

    public GImpactMeshShapePart() {
        this.box_set.setPrimitiveManager(this.primitive_manager);
    }

    public GImpactMeshShapePart(StridingMeshInterface stridingMeshInterface, int n) {
        this.primitive_manager.meshInterface = stridingMeshInterface;
        this.primitive_manager.part = n;
        this.box_set.setPrimitiveManager(this.primitive_manager);
    }

    @Override
    public boolean childrenHasTransform() {
        return false;
    }

    @Override
    public void lockChildShapes() {
        TrimeshPrimitiveManager trimeshPrimitiveManager = (TrimeshPrimitiveManager)this.box_set.getPrimitiveManager();
        trimeshPrimitiveManager.lock();
    }

    @Override
    public void unlockChildShapes() {
        TrimeshPrimitiveManager trimeshPrimitiveManager = (TrimeshPrimitiveManager)this.box_set.getPrimitiveManager();
        trimeshPrimitiveManager.unlock();
    }

    @Override
    public int getNumChildShapes() {
        return this.primitive_manager.get_primitive_count();
    }

    @Override
    public CollisionShape getChildShape(int n) {
        assert (false);
        return null;
    }

    @Override
    public Transform getChildTransform(int n) {
        assert (false);
        return null;
    }

    @Override
    public void setChildTransform(int n, Transform transform) {
        assert (false);
    }

    @Override
    PrimitiveManagerBase getPrimitiveManager() {
        return this.primitive_manager;
    }

    TrimeshPrimitiveManager getTrimeshPrimitiveManager() {
        return this.primitive_manager;
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        this.lockChildShapes();
        vector3f.set(0.0f, 0.0f, 0.0f);
        int n = this.getVertexCount();
        float f2 = f / (float)n;
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        while (n-- != 0) {
            this.getVertex(n, vector3f2);
            GImpactMassUtil.get_point_inertia(vector3f2, f2, vector3f2);
            vector3f.add(vector3f2);
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2});
        this.unlockChildShapes();
    }

    @Override
    public String getName() {
        return "GImpactMeshShapePart";
    }

    @Override
    ShapeType getGImpactShapeType() {
        return ShapeType.TRIMESH_SHAPE_PART;
    }

    @Override
    public boolean needsRetrieveTriangles() {
        return true;
    }

    @Override
    public boolean needsRetrieveTetrahedrons() {
        return false;
    }

    @Override
    public void getBulletTriangle(int n, TriangleShapeEx triangleShapeEx) {
        this.primitive_manager.get_bullet_triangle(n, triangleShapeEx);
    }

    @Override
    void getBulletTetrahedron(int n, TetrahedronShapeEx tetrahedronShapeEx) {
        assert (false);
    }

    public int getVertexCount() {
        return this.primitive_manager.get_vertex_count();
    }

    public void getVertex(int n, Vector3f vector3f) {
        this.primitive_manager.get_vertex(n, vector3f);
    }

    @Override
    public void setMargin(float f) {
        this.primitive_manager.margin = f;
        this.postUpdate();
    }

    @Override
    public float getMargin() {
        return this.primitive_manager.margin;
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        this.primitive_manager.scale.set(vector3f);
        this.postUpdate();
    }

    @Override
    public Vector3f getLocalScaling(Vector3f vector3f) {
        vector3f.set(this.primitive_manager.scale);
        return vector3f;
    }

    public int getPart() {
        return this.primitive_manager.part;
    }

    @Override
    public void processAllTriangles(TriangleCallback triangleCallback, Vector3f vector3f, Vector3f vector3f2) {
        this.lockChildShapes();
        BoxCollision.AABB aABB = (BoxCollision.AABB)Pools.AABBS.get();
        aABB.min.set(vector3f);
        aABB.max.set(vector3f2);
        this.collided.clear();
        this.box_set.boxQuery(aABB, this.collided);
        if (this.collided.size() == 0) {
            this.unlockChildShapes();
            return;
        }
        int n = this.getPart();
        PrimitiveTriangle primitiveTriangle = (PrimitiveTriangle)Pools.TRIANGLES.get();
        int n2 = this.collided.size();
        while (n2-- != 0) {
            this.getPrimitiveTriangle(this.collided.get(n2), primitiveTriangle);
            triangleCallback.processTriangle(primitiveTriangle.vertices, n, this.collided.get(n2));
        }
        Pools.TRIANGLES.release((Object[])new PrimitiveTriangle[]{primitiveTriangle});
        Pools.AABBS.release((Object[])new BoxCollision.AABB[]{aABB});
        this.unlockChildShapes();
    }
}

