/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.dispatch.CollisionWorld;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.ConcaveShape;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.extras.gimpact.BoxCollision;
import com.bulletphysics.extras.gimpact.GImpactBvh;
import com.bulletphysics.extras.gimpact.PrimitiveManagerBase;
import com.bulletphysics.extras.gimpact.PrimitiveTriangle;
import com.bulletphysics.extras.gimpact.ShapeType;
import com.bulletphysics.extras.gimpact.TetrahedronShapeEx;
import com.bulletphysics.extras.gimpact.TriangleShapeEx;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Vector3f;

public abstract class GImpactShapeInterface
extends ConcaveShape {
    protected BoxCollision.AABB localAABB = new BoxCollision.AABB();
    protected boolean needs_update;
    protected final Vector3f localScaling = new Vector3f();
    GImpactBvh box_set = new GImpactBvh();

    public GImpactShapeInterface() {
        this.localAABB.invalidate();
        this.needs_update = true;
        this.localScaling.set(1.0f, 1.0f, 1.0f);
    }

    public void updateBound() {
        if (!this.needs_update) {
            return;
        }
        this.calcLocalAABB();
        this.needs_update = false;
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        BoxCollision.AABB aABB = (BoxCollision.AABB)Pools.AABBS.get((Object)this.localAABB);
        aABB.appy_transform(transform);
        vector3f.set(aABB.min);
        vector3f2.set(aABB.max);
    }

    public void postUpdate() {
        this.needs_update = true;
    }

    public BoxCollision.AABB getLocalBox(BoxCollision.AABB aABB) {
        aABB.set(this.localAABB);
        return aABB;
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.GIMPACT_SHAPE_PROXYTYPE;
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        this.localScaling.set(vector3f);
        this.postUpdate();
    }

    @Override
    public Vector3f getLocalScaling(Vector3f vector3f) {
        vector3f.set(this.localScaling);
        return vector3f;
    }

    @Override
    public void setMargin(float f) {
        this.collisionMargin = f;
        int n = this.getNumChildShapes();
        while (n-- != 0) {
            CollisionShape collisionShape = this.getChildShape(n);
            collisionShape.setMargin(f);
        }
        this.needs_update = true;
    }

    abstract ShapeType getGImpactShapeType();

    GImpactBvh getBoxSet() {
        return this.box_set;
    }

    public boolean hasBoxSet() {
        return this.box_set.getNodeCount() != 0;
    }

    abstract PrimitiveManagerBase getPrimitiveManager();

    public abstract int getNumChildShapes();

    public abstract boolean childrenHasTransform();

    public abstract boolean needsRetrieveTriangles();

    public abstract boolean needsRetrieveTetrahedrons();

    public abstract void getBulletTriangle(int var1, TriangleShapeEx var2);

    abstract void getBulletTetrahedron(int var1, TetrahedronShapeEx var2);

    public void lockChildShapes() {
    }

    public void unlockChildShapes() {
    }

    void getPrimitiveTriangle(int n, PrimitiveTriangle primitiveTriangle) {
        this.getPrimitiveManager().get_primitive_triangle(n, primitiveTriangle);
    }

    protected void calcLocalAABB() {
        this.lockChildShapes();
        if (this.box_set.getNodeCount() == 0) {
            this.box_set.buildSet();
        } else {
            this.box_set.update();
        }
        this.unlockChildShapes();
        this.box_set.getGlobalBox(this.localAABB);
    }

    public void getChildAabb(int n, Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        BoxCollision.AABB aABB = (BoxCollision.AABB)Pools.AABBS.get();
        this.getPrimitiveManager().get_primitive_box(n, aABB);
        aABB.appy_transform(transform);
        vector3f.set(aABB.min);
        vector3f2.set(aABB.max);
    }

    public abstract CollisionShape getChildShape(int var1);

    public abstract Transform getChildTransform(int var1);

    public abstract void setChildTransform(int var1, Transform var2);

    public void rayTest(Vector3f vector3f, Vector3f vector3f2, CollisionWorld.RayResultCallback rayResultCallback) {
    }

    @Override
    public void processAllTriangles(TriangleCallback triangleCallback, Vector3f vector3f, Vector3f vector3f2) {
    }
}

