/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.linearmath;

import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;

public class DefaultMotionState
implements MotionState {
    public final Transform graphicsWorldTrans = new Transform();
    public final Transform centerOfMassOffset = new Transform();
    public final Transform startWorldTrans = new Transform();

    public DefaultMotionState() {
        this.graphicsWorldTrans.setIdentity();
        this.centerOfMassOffset.setIdentity();
        this.startWorldTrans.setIdentity();
    }

    public DefaultMotionState(Transform transform) {
        this.graphicsWorldTrans.set(transform);
        this.centerOfMassOffset.setIdentity();
        this.startWorldTrans.set(transform);
    }

    public DefaultMotionState(Transform transform, Transform transform2) {
        this.graphicsWorldTrans.set(transform);
        this.centerOfMassOffset.set(transform2);
        this.startWorldTrans.set(transform);
    }

    @Override
    public Transform getWorldTransform(Transform transform) {
        transform.inverse(this.centerOfMassOffset);
        transform.mul(this.graphicsWorldTrans);
        return transform;
    }

    @Override
    public void setWorldTransform(Transform transform) {
        this.graphicsWorldTrans.set(transform);
        this.graphicsWorldTrans.mul(this.centerOfMassOffset);
    }
}

