/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.linearmath;

import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public class VectorUtil {
    public static int maxAxis(Vector3f vector3f) {
        int n = -1;
        float f = -1.0E30f;
        if (vector3f.x > f) {
            n = 0;
            f = vector3f.x;
        }
        if (vector3f.y > f) {
            n = 1;
            f = vector3f.y;
        }
        if (vector3f.z > f) {
            n = 2;
            f = vector3f.z;
        }
        return n;
    }

    public static int maxAxis4(Vector4f vector4f) {
        int n = -1;
        float f = -1.0E30f;
        if (vector4f.x > f) {
            n = 0;
            f = vector4f.x;
        }
        if (vector4f.y > f) {
            n = 1;
            f = vector4f.y;
        }
        if (vector4f.z > f) {
            n = 2;
            f = vector4f.z;
        }
        if (vector4f.w > f) {
            n = 3;
            f = vector4f.w;
        }
        return n;
    }

    public static int closestAxis4(Vector4f vector4f) {
        Vector4f vector4f2 = new Vector4f(vector4f);
        vector4f2.absolute();
        return VectorUtil.maxAxis4(vector4f2);
    }

    public static float getCoord(Vector3f vector3f, int n) {
        switch (n) {
            case 0: {
                return vector3f.x;
            }
            case 1: {
                return vector3f.y;
            }
            case 2: {
                return vector3f.z;
            }
        }
        throw new InternalError();
    }

    public static void setCoord(Vector3f vector3f, int n, float f) {
        switch (n) {
            case 0: {
                vector3f.x = f;
                break;
            }
            case 1: {
                vector3f.y = f;
                break;
            }
            case 2: {
                vector3f.z = f;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    public static void mulCoord(Vector3f vector3f, int n, float f) {
        switch (n) {
            case 0: {
                vector3f.x *= f;
                break;
            }
            case 1: {
                vector3f.y *= f;
                break;
            }
            case 2: {
                vector3f.z *= f;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    public static void setInterpolate3(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f) {
        float f2 = 1.0f - f;
        vector3f.x = f2 * vector3f2.x + f * vector3f3.x;
        vector3f.y = f2 * vector3f2.y + f * vector3f3.y;
        vector3f.z = f2 * vector3f2.z + f * vector3f3.z;
    }

    public static void add(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f.x = vector3f2.x + vector3f3.x;
        vector3f.y = vector3f2.y + vector3f3.y;
        vector3f.z = vector3f2.z + vector3f3.z;
    }

    public static void add(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        vector3f.x = vector3f2.x + vector3f3.x + vector3f4.x;
        vector3f.y = vector3f2.y + vector3f3.y + vector3f4.y;
        vector3f.z = vector3f2.z + vector3f3.z + vector3f4.z;
    }

    public static void add(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5) {
        vector3f.x = vector3f2.x + vector3f3.x + vector3f4.x + vector3f5.x;
        vector3f.y = vector3f2.y + vector3f3.y + vector3f4.y + vector3f5.y;
        vector3f.z = vector3f2.z + vector3f3.z + vector3f4.z + vector3f5.z;
    }

    public static void mul(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f.x = vector3f2.x * vector3f3.x;
        vector3f.y = vector3f2.y * vector3f3.y;
        vector3f.z = vector3f2.z * vector3f3.z;
    }

    public static void div(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f.x = vector3f2.x / vector3f3.x;
        vector3f.y = vector3f2.y / vector3f3.y;
        vector3f.z = vector3f2.z / vector3f3.z;
    }

    public static void setMin(Vector3f vector3f, Vector3f vector3f2) {
        vector3f.x = Math.min(vector3f.x, vector3f2.x);
        vector3f.y = Math.min(vector3f.y, vector3f2.y);
        vector3f.z = Math.min(vector3f.z, vector3f2.z);
    }

    public static void setMax(Vector3f vector3f, Vector3f vector3f2) {
        vector3f.x = Math.max(vector3f.x, vector3f2.x);
        vector3f.y = Math.max(vector3f.y, vector3f2.y);
        vector3f.z = Math.max(vector3f.z, vector3f2.z);
    }

    public static float dot3(Vector4f vector4f, Vector3f vector3f) {
        return vector4f.x * vector3f.x + vector4f.y * vector3f.y + vector4f.z * vector3f.z;
    }

    public static float dot3(Vector4f vector4f, Vector4f vector4f2) {
        return vector4f.x * vector4f2.x + vector4f.y * vector4f2.y + vector4f.z * vector4f2.z;
    }

    public static float dot3(Vector3f vector3f, Vector4f vector4f) {
        return vector3f.x * vector4f.x + vector3f.y * vector4f.y + vector3f.z * vector4f.z;
    }

    public static float lengthSquared3(Vector4f vector4f) {
        return vector4f.x * vector4f.x + vector4f.y * vector4f.y + vector4f.z * vector4f.z;
    }

    public static void normalize3(Vector4f vector4f) {
        float f = (float)(1.0 / Math.sqrt(vector4f.x * vector4f.x + vector4f.y * vector4f.y + vector4f.z * vector4f.z));
        vector4f.x *= f;
        vector4f.y *= f;
        vector4f.z *= f;
    }

    public static void cross3(Vector3f vector3f, Vector4f vector4f, Vector4f vector4f2) {
        float f = vector4f.y * vector4f2.z - vector4f.z * vector4f2.y;
        float f2 = vector4f2.x * vector4f.z - vector4f2.z * vector4f.x;
        vector3f.z = vector4f.x * vector4f2.y - vector4f.y * vector4f2.x;
        vector3f.x = f;
        vector3f.y = f2;
    }
}

