/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.util;

public class FloatArrayList {
    private float[] array = new float[16];
    private int size;

    public void add(float f) {
        if (this.size == this.array.length) {
            this.expand();
        }
        this.array[this.size++] = f;
    }

    private void expand() {
        float[] fArray = new float[this.array.length << 1];
        System.arraycopy(this.array, 0, fArray, 0, this.array.length);
        this.array = fArray;
    }

    public float remove(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        float f = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.size - n - 1);
        --this.size;
        return f;
    }

    public float get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[n];
    }

    public void set(int n, float f) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.array[n] = f;
    }

    public int size() {
        return this.size;
    }
}

