/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics;

import com.jme3.system.JmeSystem;
import com.jme3.system.Platform;
import gama.dev.DEBUG;
import gama.extension.physics.NativeUtils;

public class NativeLoader {
    public static final boolean LOAD_NATIVE_BULLET_LIBRARY = true;
    public static Boolean NATIVE_BULLET_LIBRARY_LOADED;
    public static final String NATIVE_LIBRARY_LOCATION = "/lib/native/";
    public static final String MAC_NATIVE_LIBRARY_NAME = "MacOSX64ReleaseDp_libbulletjme.dylib";
    public static final String MAC_ARM_NATIVE_LIBRARY_NAME = "MacOSX_ARM64ReleaseDp_libbulletjme.dylib";
    public static final String WIN_NATIVE_LIBRARY_NAME = "Windows64ReleaseDp_bulletjme.dll";
    public static final String LIN_NATIVE_LIBRARY_NAME = "Linux64ReleaseDp_libbulletjme.so";

    static {
        DEBUG.ON();
        NATIVE_BULLET_LIBRARY_LOADED = null;
    }

    public static boolean loadNativeLibrary() {
        if (NATIVE_BULLET_LIBRARY_LOADED == null) {
            NATIVE_BULLET_LIBRARY_LOADED = false;
            DEBUG.TIMER_WITH_EXCEPTIONS((String)"GAMA", (String)"Native Bullet library", (String)"loaded in", () -> {
                try {
                    Platform platform = JmeSystem.getPlatform();
                    String string = switch (platform) {
                        case Platform.Windows64 -> WIN_NATIVE_LIBRARY_NAME;
                        case Platform.Linux64 -> LIN_NATIVE_LIBRARY_NAME;
                        case Platform.MacOSX64 -> MAC_NATIVE_LIBRARY_NAME;
                        case Platform.MacOSX_ARM64 -> MAC_ARM_NATIVE_LIBRARY_NAME;
                        default -> throw new RuntimeException("Platform " + String.valueOf(platform) + " is not supported");
                    };
                    NativeUtils.loadLibraryFromJar(NATIVE_LIBRARY_LOCATION + string);
                    NATIVE_BULLET_LIBRARY_LOADED = true;
                }
                catch (Throwable throwable) {
                    NATIVE_BULLET_LIBRARY_LOADED = false;
                    DEBUG.ERR((Object)(">> Impossible to load Bullet native library because " + throwable.getMessage()));
                    DEBUG.ERR((Object)">> GAMA will fall back to JBullet instead");
                }
            });
        }
        return NATIVE_BULLET_LIBRARY_LOADED;
    }
}

