/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.box2d_version;

import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.matrix.IField;
import gama.dev.DEBUG;
import gama.extension.physics.box2d_version.IBox2DPhysicalEntity;
import gama.extension.physics.common.IShapeConverter;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.locationtech.jts.geom.LineString;

public class Box2DShapeConverter
implements IShapeConverter<Shape, Vec2>,
IBox2DPhysicalEntity {
    final float scale;

    static {
        DEBUG.ON();
    }

    Box2DShapeConverter(float f) {
        this.scale = f;
    }

    @Override
    public void computeTranslation(IAgent iAgent, IShape.Type type, float f, Vec2 vec2, Vec2 vec22) {
    }

    @Override
    public Shape convertShape(IShape iShape, IShape.Type type, float f) {
        switch (type) {
            case BOX: 
            case CONE: 
            case CUBE: 
            case SQUARE: 
            case PLAN: 
            case PYRAMID: {
                PolygonShape polygonShape = new PolygonShape();
                polygonShape.setAsBox(this.toBox2D(iShape.getWidth().floatValue() / 2.0f), this.toBox2D(iShape.getHeight().floatValue() / 2.0f));
                return polygonShape;
            }
            case LINECYLINDER: {
                LineString lineString = (LineString)iShape.getInnerGeometry();
                EdgeShape edgeShape = new EdgeShape();
                edgeShape.set((Vec2)this.toVector((GamaPoint)lineString.getCoordinateN(0)), (Vec2)this.toVector((GamaPoint)lineString.getCoordinateN(1)));
                return edgeShape;
            }
            case CIRCLE: 
            case CYLINDER: 
            case POINT: 
            case SPHERE: {
                CircleShape circleShape = new CircleShape();
                double d = iShape.getWidth().floatValue() / 2.0f;
                circleShape.setRadius(this.toBox2D(d));
                return circleShape;
            }
        }
        GamaPoint[] gamaPointArray = GeometryUtils.getPointsOf((IShape)iShape);
        switch (gamaPointArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                return this.convertShape(iShape, IShape.Type.POINT, f);
            }
            case 2: {
                EdgeShape edgeShape = new EdgeShape();
                edgeShape.set((Vec2)this.toVector(gamaPointArray[0]), (Vec2)this.toVector(gamaPointArray[1]));
                return edgeShape;
            }
        }
        PolygonShape polygonShape = new PolygonShape();
        Vec2[] vec2Array = new Vec2[gamaPointArray.length];
        int n = 0;
        while (n < gamaPointArray.length) {
            vec2Array[n] = this.toVector(gamaPointArray[n]);
            ++n;
        }
        polygonShape.set(vec2Array, vec2Array.length);
        return polygonShape;
    }

    @Override
    public Shape convertTerrain(IScope iScope, IField iField, Double d, Double d2, float f) {
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsBox(d.floatValue(), d2.floatValue());
        return polygonShape;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public GamaPoint toGamaPoint(Vec2 vec2) {
        return null;
    }
}

