/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.gaml;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.IList;
import gama.core.util.matrix.IField;
import gama.extension.physics.NativeLoader;
import gama.extension.physics.box2d_version.Box2DPhysicalWorld;
import gama.extension.physics.common.IPhysicalConstants;
import gama.extension.physics.common.IPhysicalWorld;
import gama.extension.physics.java_version.BulletPhysicalWorld;
import gama.extension.physics.native_version.NativeBulletPhysicalWorld;
import gama.gaml.species.ISpecies;
import java.util.Collection;

@GamlAnnotations.species(name="physical_world", skills={"static_body"})
@GamlAnnotations.doc(value="The base species for models that act as a 3D physical world. Can register and manage agents provided with either the 'static_body' or 'dynamic_body' skill. Inherits from 'static_body', so it can also act as a physical body itself (with a 'mass', 'friction', 'gravity'), of course without motion -- in this case, it needs to register itself as a physical agent using the 'register' action")
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="gravity", type=7, init="{0,0,-9.80665}", doc={@GamlAnnotations.doc(value="Defines the value of gravity in this world. The default value is set to -9.80665 on the z-axis, that is 9.80665 m/s2 towards the 'bottom' of the world. Can be set to any direction and intensity and applies to all the bodies present in the physical world")}), @GamlAnnotations.variable(name="automated_registration", type=3, init="true", doc={@GamlAnnotations.doc(value="If set to true (the default), makes the world automatically register and unregister agents provided with either the 'static_body' or 'dynamic_body' skill. Otherwise, they must be registered using the 'register' action, which can be useful when only some agents need to be considered as 'physical agents'. Note that, in any case, the world needs to manually register itself if it is supposed to act as a physical body. ")}), @GamlAnnotations.variable(name="max_substeps", type=1, init="0", doc={@GamlAnnotations.doc(value="If equal to 0 (the default), makes the simulation engine be stepped alongside the simulation (no substeps allowed). Otherwise, sets the maximum number of physical simulation substeps that may occur within one GAMA simulation step")}), @GamlAnnotations.variable(name="terrain", type=31, doc={@GamlAnnotations.doc(value="This attribute is a matrix of float that can be used to represent a 3D terrain. The shape of the world, in that case, should be a box, where thedimension on the z-axis is used to scale the z-values of the DEM. The world needs to be register itself as a physical object")}), @GamlAnnotations.variable(name="use_native", type=3, doc={@GamlAnnotations.doc(value="This attribute allows to manually switch between the Java version of the Bullet library (JBullet, a modified version of https://github.com/stephengold/jbullet, which corresponds to version 2.72 of the original library) and the native Bullet library (Libbulletjme, https://github.com/stephengold/Libbulletjme, which is kept up-to-date with the 3.x branch of the original library).The native version is the default one unless the libraries cannot be loaded, making JBullet the default")}), @GamlAnnotations.variable(name="library", type=4, doc={@GamlAnnotations.doc(value="This attribute allows to manually switch between two physics library, named 'bullet' and 'box2D'. The Bullet library, which comes in two flavors (see 'use_native') and the Box2D libray in its Java version (https://github.com/jbox2d/jbox2d). Bullet is the default library but models in 2D should better use Box2D")}), @GamlAnnotations.variable(name="accurate_collision_detection", type=3, init="false", doc={@GamlAnnotations.doc(value="Enables or not a better (but slower) collision detection ")})})
public class PhysicalSimulationAgent
extends SimulationAgent
implements IPhysicalConstants {
    final BodyPopulationListener populationListener = new BodyPopulationListener();
    Boolean ccd = false;
    Boolean automatedRegistration = true;
    final GamaPoint gravity = new GamaPoint(0.0, 0.0, -9.81);
    IField terrain;
    IPhysicalWorld gateway;
    Boolean useNativeLibrary = NativeLoader.NATIVE_BULLET_LIBRARY_LOADED;
    String libraryToUse = "bullet";
    private final Collector.AsOrderedSet<IAgent> registeredAgents = Collector.getOrderedSet();
    private int maxSubSteps;

    public PhysicalSimulationAgent(IPopulation<? extends IAgent> iPopulation, int n) throws GamaRuntimeException {
        super(iPopulation, n);
    }

    @GamlAnnotations.action(doc={@GamlAnnotations.doc(value="An action that allows to register agents in this physical world. Unregistered agents will not be governed by the physical laws of this world. If the world is to play a role in the physical world,then it needs to register itself (i.e. do register([self]);")}, name="register", args={@GamlAnnotations.arg(doc={@GamlAnnotations.doc(value="the list or container of agents to register in this physical world")}, name="bodies", type=16)})
    public Object primRegister(IScope iScope) {
        IList iList = iScope.getListArg("bodies");
        if (iList == null) {
            return null;
        }
        for (IAgent iAgent : iList) {
            this.registerAgent(iScope, iAgent);
        }
        return iList;
    }

    private void registerAgent(IScope iScope, IAgent iAgent) {
        if (this.registeredAgents.add((Object)iAgent)) {
            this.getGateway().registerAgent(iAgent);
        }
    }

    private void unregisterAgent(IScope iScope, IAgent iAgent) {
        if (this.registeredAgents.remove((Object)iAgent)) {
            this.getGateway().unregisterAgent(iAgent);
        }
    }

    public void updateAgent(IScope iScope, IAgent iAgent) {
        this.getGateway().updateAgentShape(iAgent);
    }

    @GamlAnnotations.getter(value="terrain")
    public IField getTerrain() {
        return this.terrain;
    }

    @GamlAnnotations.setter(value="terrain")
    public void setTerrain(IField iField) {
        this.terrain = iField;
    }

    @GamlAnnotations.getter(value="accurate_collision_detection", initializer=true)
    public Boolean getCCD(IScope iScope) {
        return this.ccd;
    }

    @GamlAnnotations.setter(value="accurate_collision_detection")
    public void setCCD(IScope iScope, Boolean bl) {
        this.ccd = bl;
        if (this.gateway != null) {
            this.gateway.setCCD(bl);
        }
    }

    @GamlAnnotations.getter(value="automated_registration", initializer=true)
    public Boolean getAutomatedRegistration(IScope iScope) {
        return this.automatedRegistration;
    }

    @GamlAnnotations.setter(value="automated_registration")
    public void setAutomatedRegistration(IScope iScope, Boolean bl) {
        this.automatedRegistration = bl;
    }

    @GamlAnnotations.getter(value="use_native")
    public Boolean usesNativeLibrary(IScope iScope) {
        if (this.useNativeLibrary == null) {
            this.useNativeLibrary = NativeLoader.loadNativeLibrary();
        }
        return this.useNativeLibrary;
    }

    @GamlAnnotations.setter(value="use_native")
    public void useNativeLibrary(IScope iScope, Boolean bl) {
        this.useNativeLibrary = bl != false && NativeLoader.loadNativeLibrary();
    }

    @GamlAnnotations.getter(value="library", initializer=true)
    public String libraryToUse(IScope iScope) {
        return this.libraryToUse;
    }

    @GamlAnnotations.setter(value="library")
    public void libraryToUse(IScope iScope, String string) {
        this.libraryToUse = string;
    }

    @GamlAnnotations.getter(value="max_substeps", initializer=true)
    public int getMaxSubSteps(IScope iScope) {
        return this.maxSubSteps;
    }

    @GamlAnnotations.setter(value="max_substeps")
    public void setMaxSubSteps(IScope iScope, int n) {
        this.maxSubSteps = n;
    }

    @GamlAnnotations.getter(value="gravity", initializer=true)
    public GamaPoint getGravity(IScope iScope) {
        return this.gravity;
    }

    @GamlAnnotations.setter(value="gravity")
    public void setGravity(IScope iScope, GamaPoint gamaPoint) {
        this.gravity.setLocation(gamaPoint);
        if (this.gateway != null) {
            this.gateway.setGravity(gamaPoint);
        }
    }

    public void dispose() {
        this.getGateway().dispose();
        this.registeredAgents.clear();
        super.dispose();
    }

    protected void registerMicropopulation(IScope iScope, ISpecies iSpecies, IPopulation<? extends IAgent> iPopulation) {
        if (iSpecies.implementsSkill("dynamic_body").booleanValue() || iSpecies.implementsSkill("static_body").booleanValue()) {
            iPopulation.addListener((IPopulation.Listener)this.populationListener);
        }
        super.registerMicropopulation(iScope, iSpecies, iPopulation);
    }

    public boolean doStep(IScope iScope) {
        if (super.doStep(iScope)) {
            Double d = this.getTimeStep(iScope);
            this.getGateway().doStep(d, this.maxSubSteps);
            return true;
        }
        return false;
    }

    IPhysicalWorld getGateway() {
        if (this.gateway == null) {
            boolean bl = "bullet".equals(this.libraryToUse);
            this.gateway = bl ? (this.useNativeLibrary.booleanValue() ? new NativeBulletPhysicalWorld(this) : new BulletPhysicalWorld(this)) : new Box2DPhysicalWorld(this);
        }
        return this.gateway;
    }

    class BodyPopulationListener
    implements IPopulation.Listener {
        BodyPopulationListener() {
        }

        public void notifyAgentRemoved(IScope iScope, IPopulation<? extends IAgent> iPopulation, IAgent iAgent) {
            PhysicalSimulationAgent.this.unregisterAgent(iScope, iAgent);
        }

        public void notifyAgentAdded(IScope iScope, IPopulation<? extends IAgent> iPopulation, IAgent iAgent) {
            if (PhysicalSimulationAgent.this.automatedRegistration.booleanValue()) {
                PhysicalSimulationAgent.this.registerAgent(iScope, iAgent);
            }
        }

        public void notifyAgentsAdded(IScope iScope, IPopulation<? extends IAgent> iPopulation, Collection<? extends IAgent> collection) {
            if (iScope.interrupted()) {
                return;
            }
            if (PhysicalSimulationAgent.this.automatedRegistration.booleanValue()) {
                for (IAgent iAgent : collection) {
                    PhysicalSimulationAgent.this.registerAgent(iScope, iAgent);
                }
            }
        }

        public void notifyAgentsRemoved(IScope iScope, IPopulation<? extends IAgent> iPopulation, Collection<? extends IAgent> collection) {
            if (iScope.interrupted()) {
                return;
            }
            for (IAgent iAgent : collection) {
                PhysicalSimulationAgent.this.unregisterAgent(iScope, iAgent);
            }
        }

        public void notifyPopulationCleared(IScope iScope, IPopulation<? extends IAgent> iPopulation) {
            if (iScope.interrupted()) {
                return;
            }
            for (IAgent iAgent : iPopulation) {
                PhysicalSimulationAgent.this.unregisterAgent(iScope, iAgent);
            }
        }
    }
}

