/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.java_version;

import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.Transform;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.util.GamaPair;
import gama.extension.physics.common.AbstractBodyWrapper;
import gama.extension.physics.common.IBody;
import gama.extension.physics.java_version.BulletPhysicalWorld;
import gama.extension.physics.java_version.IBulletPhysicalEntity;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class BulletBodyWrapper
extends AbstractBodyWrapper<DiscreteDynamicsWorld, RigidBody, CollisionShape, Vector3f>
implements IBulletPhysicalEntity {
    private final Transform temp = new Transform();
    private final Vector3f vtemp = new Vector3f();
    private final Vector3f vtemp2 = new Vector3f();
    final AxisAngle4f axisAngleTransfer = new AxisAngle4f();
    Quat4f quatTransfer = new Quat4f();

    public BulletBodyWrapper(IAgent iAgent, BulletPhysicalWorld bulletPhysicalWorld) {
        super(iAgent, bulletPhysicalWorld);
        ((RigidBody)this.body).setUserPointer(this);
    }

    @Override
    public RigidBody createAndInitializeBody(CollisionShape collisionShape, DiscreteDynamicsWorld discreteDynamicsWorld) {
        Transform transform = new Transform();
        transform.setIdentity();
        GamaPoint gamaPoint = this.agent.getLocation();
        transform.origin.set((float)gamaPoint.getX(), (float)gamaPoint.getY(), (float)gamaPoint.getZ() + ((Vector3f)this.aabbTranslation).getZ());
        DefaultMotionState defaultMotionState = new DefaultMotionState(transform);
        RigidBodyConstructionInfo rigidBodyConstructionInfo = new RigidBodyConstructionInfo(0.0f, defaultMotionState, collisionShape);
        IBody iBody = (IBody)this.agent.getAttribute("%%rigid_body%%");
        if (iBody != null) {
            float f;
            rigidBodyConstructionInfo.mass = f = iBody.getMass();
            if (f != 0.0f) {
                collisionShape.calculateLocalInertia(f, rigidBodyConstructionInfo.localInertia);
            }
            rigidBodyConstructionInfo.friction = iBody.getFriction();
            rigidBodyConstructionInfo.restitution = iBody.getRestitution();
            rigidBodyConstructionInfo.angularDamping = iBody.getAngularDamping();
            rigidBodyConstructionInfo.linearDamping = iBody.getLinearDamping();
        }
        RigidBody rigidBody = new RigidBody(rigidBodyConstructionInfo);
        if (!this.isStatic) {
            rigidBody.setActivationState(4);
        }
        if (iBody != null) {
            GamaPoint gamaPoint2 = new GamaPoint();
            rigidBody.setLinearVelocity((Vector3f)this.toVector(iBody.getLinearVelocity(gamaPoint2)));
            rigidBody.setAngularVelocity((Vector3f)this.toVector(iBody.getAngularVelocity(gamaPoint2)));
        }
        rigidBody.setCollisionFlags(8);
        return rigidBody;
    }

    @Override
    public void setCCD(boolean bl) {
        if (bl) {
            ((RigidBody)this.body).getAabb(this.vtemp, this.vtemp2);
            this.vtemp2.sub(this.vtemp);
            float f = Math.max(Math.max(this.vtemp2.x, this.vtemp2.y), this.vtemp2.z);
            ((RigidBody)this.body).setCcdMotionThreshold(f / 4.0f);
            ((RigidBody)this.body).setCcdSweptSphereRadius(f / 2.0f);
        } else {
            ((RigidBody)this.body).setCcdMotionThreshold(0.0f);
        }
    }

    @Override
    public void setFriction(Double d) {
        ((RigidBody)this.body).setFriction(this.clamp(d));
    }

    @Override
    public void setRestitution(Double d) {
        ((RigidBody)this.body).setRestitution(this.clamp(d));
    }

    @Override
    public void setDamping(Double d) {
        ((RigidBody)this.body).setDamping(this.clamp(d), this.getAngularDamping());
    }

    @Override
    public void setAngularDamping(Double d) {
        ((RigidBody)this.body).setDamping(this.getLinearDamping(), this.clamp(d));
    }

    @Override
    public void setAngularVelocity(GamaPoint gamaPoint) {
        ((RigidBody)this.body).setAngularVelocity((Vector3f)this.toVector(gamaPoint));
    }

    @Override
    public void setLinearVelocity(GamaPoint gamaPoint) {
        ((RigidBody)this.body).setLinearVelocity((Vector3f)this.toVector(gamaPoint));
    }

    @Override
    public void setLocation(GamaPoint gamaPoint) {
        ((RigidBody)this.body).getWorldTransform(this.temp);
        this.temp.origin.set((float)gamaPoint.x, (float)gamaPoint.y, (float)gamaPoint.z + ((Vector3f)this.aabbTranslation).z);
        ((RigidBody)this.body).setWorldTransform(this.temp);
    }

    @Override
    public void applyImpulse(GamaPoint gamaPoint) {
        ((RigidBody)this.body).applyCentralImpulse((Vector3f)this.toVector(gamaPoint));
    }

    @Override
    public void applyTorque(GamaPoint gamaPoint) {
        ((RigidBody)this.body).applyTorque((Vector3f)this.toVector(gamaPoint));
    }

    @Override
    public void applyForce(GamaPoint gamaPoint) {
        ((RigidBody)this.body).applyCentralForce((Vector3f)this.toVector(gamaPoint));
    }

    @Override
    public float getMass() {
        float f = ((RigidBody)this.body).getInvMass();
        return f == 0.0f ? 0.0f : 1.0f / f;
    }

    @Override
    public void setMass(Double d) {
        ((RigidBody)this.body).getCollisionShape().calculateLocalInertia(d.floatValue(), this.vtemp);
        ((RigidBody)this.body).setMassProps(d.floatValue(), this.vtemp);
    }

    @Override
    public GamaPoint getAngularVelocity(GamaPoint gamaPoint) {
        ((RigidBody)this.body).getAngularVelocity(this.vtemp);
        return this.toGamaPoint(this.vtemp, gamaPoint);
    }

    @Override
    public GamaPoint getLinearVelocity(GamaPoint gamaPoint) {
        ((RigidBody)this.body).getLinearVelocity(this.vtemp);
        return this.toGamaPoint(this.vtemp, gamaPoint);
    }

    @Override
    public IShape getAABB() {
        ((RigidBody)this.body).getAabb(this.vtemp, this.vtemp2);
        return GamaGeometryType.buildBox((double)(this.vtemp2.x - this.vtemp.x), (double)(this.vtemp2.y - this.vtemp.y), (double)(this.vtemp2.z - this.vtemp.z), (GamaPoint)new GamaPoint((double)(this.vtemp.x + (this.vtemp2.x - this.vtemp.x) / 2.0f), (double)(this.vtemp.y + (this.vtemp2.y - this.vtemp.y) / 2.0f), (double)(this.vtemp.z + (this.vtemp2.z - this.vtemp.z) / 2.0f + ((Vector3f)this.visualTranslation).z)));
    }

    @Override
    public float getContactDamping() {
        return 0.0f;
    }

    @Override
    public void setContactDamping(Double d) {
    }

    @Override
    public float getFriction() {
        return ((RigidBody)this.body).getFriction();
    }

    @Override
    public float getRestitution() {
        return ((RigidBody)this.body).getRestitution();
    }

    @Override
    public float getLinearDamping() {
        return ((RigidBody)this.body).getLinearDamping();
    }

    @Override
    public float getAngularDamping() {
        return ((RigidBody)this.body).getAngularDamping();
    }

    @Override
    public void clearForces() {
        ((RigidBody)this.body).clearForces();
    }

    @Override
    public void transferLocationAndRotationToAgent() {
        Vector3f vector3f = ((RigidBody)this.body).getWorldTransform((Transform)this.temp).origin;
        this.agent.setLocation(new GamaPoint((double)vector3f.x, (double)vector3f.y, (double)(vector3f.z - ((Vector3f)this.aabbTranslation).z)));
        this.temp.getRotation(this.quatTransfer);
        this.axisAngleTransfer.set(this.quatTransfer);
        GamaPair gamaPair = (GamaPair)this.agent.getAttribute("rotation");
        if (gamaPair == null) {
            gamaPair = new GamaPair((Object)0.0, (Object)new GamaPoint(0.0, 0.0, 1.0), (IType)Types.FLOAT, (IType)Types.POINT);
            this.agent.setAttribute("rotation", (Object)gamaPair);
        }
        gamaPair.key = Math.toDegrees(this.axisAngleTransfer.angle);
        ((GamaPoint)gamaPair.value).setLocation((double)this.axisAngleTransfer.x, (double)this.axisAngleTransfer.y, (double)this.axisAngleTransfer.z);
    }
}

