/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.java_version;

import com.bulletphysics.collision.shapes.BU_Simplex1to4;
import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.ConeShapeZ;
import com.bulletphysics.collision.shapes.ConvexHullShape;
import com.bulletphysics.collision.shapes.ConvexInternalShape;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.collision.shapes.CylinderShape;
import com.bulletphysics.collision.shapes.CylinderShapeX;
import com.bulletphysics.collision.shapes.CylinderShapeZ;
import com.bulletphysics.collision.shapes.SphereShape;
import com.bulletphysics.collision.shapes.TriangleShape;
import com.bulletphysics.collision.shapes.UniformScalingShape;
import com.bulletphysics.dom.HeightfieldTerrainShape;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.matrix.IField;
import gama.extension.physics.common.IShapeConverter;
import gama.extension.physics.java_version.IBulletPhysicalEntity;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Vector3f;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;

public class BulletShapeConverter
implements IShapeConverter<CollisionShape, Vector3f>,
IBulletPhysicalEntity {
    static Map<IShape.Type, ConvexShape> shapes = new HashMap<IShape.Type, ConvexShape>();
    static Map<IShape.Type, Vector3f> translations = new HashMap<IShape.Type, Vector3f>();

    static {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.5f);
        Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f vector3f3 = new Vector3f(1.0f, 1.0f, 1.0f);
        ConvexInternalShape convexInternalShape = new SphereShape(1.0f);
        shapes.put(IShape.Type.SPHERE, convexInternalShape);
        shapes.put(IShape.Type.CIRCLE, convexInternalShape);
        shapes.put(IShape.Type.POINT, convexInternalShape);
        translations.put(IShape.Type.SPHERE, vector3f2);
        translations.put(IShape.Type.POINT, vector3f2);
        translations.put(IShape.Type.CIRCLE, vector3f2);
        convexInternalShape = new BoxShape(vector3f3);
        shapes.put(IShape.Type.CUBE, convexInternalShape);
        translations.put(IShape.Type.CUBE, vector3f);
    }

    @Override
    public void computeTranslation(IAgent iAgent, IShape.Type type, float f, Vector3f vector3f, Vector3f vector3f2) {
        if (type == IShape.Type.LINECYLINDER) {
            vector3f.set(0.0f, 0.0f, 0.0f);
            vector3f2.set(0.0f, 0.0f, -f);
        } else if (shapes.containsKey(type)) {
            vector3f.scale(f, translations.get(type));
            vector3f2.set(0.0f, 0.0f, -vector3f.z);
        } else {
            vector3f.set(0.0f, 0.0f, f / 2.0f);
            vector3f2.set(0.0f, 0.0f, -f / 2.0f);
        }
    }

    @Override
    public CollisionShape convertShape(IShape iShape, IShape.Type type, float f) {
        switch (type) {
            case BOX: 
            case SQUARE: 
            case PLAN: {
                return new BoxShape(new Vector3f(iShape.getWidth().floatValue() / 2.0f, iShape.getHeight().floatValue() / 2.0f, f / 2.0f));
            }
            case CONE: {
                return new ConeShapeZ(iShape.getWidth().floatValue() / 2.0f, f);
            }
            case LINECYLINDER: {
                LineString lineString = (LineString)iShape.getInnerGeometry();
                LineSegment lineSegment = new LineSegment(lineString.getCoordinateN(0), lineString.getCoordinateN(1));
                if (lineSegment.isVertical()) {
                    return new CylinderShape(new Vector3f(f, (float)lineSegment.getLength() / 2.0f, f));
                }
                return new CylinderShapeX(new Vector3f((float)lineSegment.getLength() / 2.0f, f, f));
            }
            case CYLINDER: {
                return new CylinderShapeZ(new Vector3f(iShape.getWidth().floatValue() / 2.0f, iShape.getHeight().floatValue() / 2.0f, f / 2.0f));
            }
            case PYRAMID: {
                break;
            }
            case CIRCLE: 
            case POINT: 
            case SPHERE: {
                return new UniformScalingShape(shapes.get(type), f);
            }
            case CUBE: {
                return new UniformScalingShape(shapes.get(type), f / 2.0f);
            }
            default: {
                GamaPoint[] gamaPointArray = GeometryUtils.getPointsOf((IShape)iShape);
                switch (gamaPointArray.length) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return this.convertShape(iShape, IShape.Type.POINT, f);
                    }
                    case 2: {
                        return new BU_Simplex1to4((Vector3f)this.toVector(gamaPointArray[0]), (Vector3f)this.toVector(gamaPointArray[1]));
                    }
                    case 3: {
                        return new TriangleShape((Vector3f)this.toVector(gamaPointArray[0]), (Vector3f)this.toVector(gamaPointArray[1]), (Vector3f)this.toVector(gamaPointArray[2]));
                    }
                    case 4: {
                        return new BU_Simplex1to4((Vector3f)this.toVector(gamaPointArray[0]), (Vector3f)this.toVector(gamaPointArray[1]), (Vector3f)this.toVector(gamaPointArray[2]), (Vector3f)this.toVector(gamaPointArray[3]));
                    }
                }
                ConvexHullShape convexHullShape = new ConvexHullShape();
                GamaPoint[] gamaPointArray2 = gamaPointArray;
                int n = gamaPointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GamaPoint gamaPoint = gamaPointArray2[n2];
                    convexHullShape.addPoint((Vector3f)this.toVector(gamaPoint));
                    ++n2;
                }
                return convexHullShape;
            }
        }
        return null;
    }

    @Override
    public CollisionShape convertTerrain(IScope iScope, IField iField, Double d, Double d2, float f) {
        double[] dArray = iField.getMinMax();
        float f2 = (float)dArray[1];
        float f3 = (float)dArray[0];
        GamaPoint gamaPoint = iField.getDimensions();
        float[] fArray = this.toFloats(iField.getMatrix());
        float f4 = f2 == f3 ? 1.0f : f / (f2 - f3);
        HeightfieldTerrainShape heightfieldTerrainShape = new HeightfieldTerrainShape((int)gamaPoint.x, (int)gamaPoint.y, fArray, f4, f3, f2, 2, false);
        heightfieldTerrainShape.setLocalScaling(new Vector3f(d.floatValue() / (float)gamaPoint.x, d2.floatValue() / (float)gamaPoint.y, 1.0f));
        return heightfieldTerrainShape;
    }
}

