/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.native_version;

import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.util.GamaPair;
import gama.extension.physics.common.AbstractBodyWrapper;
import gama.extension.physics.common.IBody;
import gama.extension.physics.common.IShapeConverter;
import gama.extension.physics.native_version.INativeBulletPhysicalEntity;
import gama.extension.physics.native_version.NativeBulletPhysicalWorld;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.logging.Level;

public class NativeBulletBodyWrapper
extends AbstractBodyWrapper<PhysicsSpace, PhysicsRigidBody, CollisionShape, Vector3f>
implements INativeBulletPhysicalEntity {
    Quaternion quatTransfer = new Quaternion();

    static {
        CollisionShape.logger.setLevel(Level.OFF);
        NativePhysicsObject.loggerN.setLevel(Level.OFF);
        PhysicsSpace.logger.setLevel(Level.OFF);
        PhysicsCollisionObject.logger.setLevel(Level.OFF);
        PhysicsRigidBody.logger2.setLevel(Level.OFF);
    }

    public NativeBulletBodyWrapper(IAgent iAgent, NativeBulletPhysicalWorld nativeBulletPhysicalWorld) {
        super(iAgent, nativeBulletPhysicalWorld);
        this.setLocation(iAgent.getLocation());
        iAgent.setAttribute("%%rigid_body%%", (Object)this);
        ((PhysicsRigidBody)this.body).setUserObject((Object)this);
    }

    @Override
    public PhysicsRigidBody createAndInitializeBody(CollisionShape collisionShape, PhysicsSpace physicsSpace) {
        PhysicsRigidBody physicsRigidBody = new PhysicsRigidBody(collisionShape);
        IBody iBody = (IBody)this.agent.getAttribute("%%rigid_body%%");
        if (iBody != null) {
            physicsRigidBody.setMass(iBody.getMass());
            physicsRigidBody.setFriction(iBody.getFriction());
            physicsRigidBody.setRestitution(iBody.getRestitution());
            physicsRigidBody.setAngularDamping(iBody.getAngularDamping());
            physicsRigidBody.setContactDamping(iBody.getContactDamping());
            physicsRigidBody.setLinearDamping(iBody.getLinearDamping());
            GamaPoint gamaPoint = new GamaPoint();
            physicsRigidBody.setLinearVelocity(this.toVector(iBody.getLinearVelocity(gamaPoint)));
            physicsRigidBody.setAngularVelocity(this.toVector(iBody.getAngularVelocity(gamaPoint)));
        }
        physicsRigidBody.setEnableSleep(false);
        return physicsRigidBody;
    }

    @Override
    public void setCCD(boolean bl) {
        if (bl) {
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            BoundingBox boundingBox = new BoundingBox();
            ((PhysicsRigidBody)this.body).boundingBox(boundingBox);
            boundingBox.getMax(vector3f2);
            boundingBox.getMax(vector3f);
            float f = Math.max(Math.max(vector3f2.x, vector3f2.y), vector3f2.z);
            ((PhysicsRigidBody)this.body).setCcdSweptSphereRadius(f / 2.0f);
            ((PhysicsRigidBody)this.body).setCcdMotionThreshold(f / 4.0f);
        } else {
            ((PhysicsRigidBody)this.body).setCcdMotionThreshold(0.0f);
        }
    }

    @Override
    public void setFriction(Double d) {
        ((PhysicsRigidBody)this.body).setFriction(this.clamp(d));
    }

    @Override
    public void setRestitution(Double d) {
        ((PhysicsRigidBody)this.body).setRestitution(this.clamp(d));
    }

    @Override
    public void setDamping(Double d) {
        ((PhysicsRigidBody)this.body).setLinearDamping(this.clamp(d));
    }

    @Override
    public void setAngularDamping(Double d) {
        ((PhysicsRigidBody)this.body).setAngularDamping(this.clamp(d));
    }

    @Override
    public void setContactDamping(Double d) {
        ((PhysicsRigidBody)this.body).setContactDamping(this.clamp(d));
    }

    @Override
    public void setAngularVelocity(GamaPoint gamaPoint) {
        ((PhysicsRigidBody)this.body).setAngularVelocity(this.toVector(gamaPoint));
    }

    @Override
    public void setLinearVelocity(GamaPoint gamaPoint) {
        ((PhysicsRigidBody)this.body).setLinearVelocity(this.toVector(gamaPoint));
    }

    @Override
    public void setLocation(GamaPoint gamaPoint) {
        ((PhysicsRigidBody)this.body).setPhysicsLocation(this.toVector(gamaPoint).addLocal((Vector3f)this.aabbTranslation));
    }

    @Override
    public void applyImpulse(GamaPoint gamaPoint) {
        ((PhysicsRigidBody)this.body).applyCentralImpulse(this.toVector(gamaPoint));
    }

    @Override
    public void applyTorque(GamaPoint gamaPoint) {
        ((PhysicsRigidBody)this.body).applyTorque(this.toVector(gamaPoint));
    }

    @Override
    public void applyForce(GamaPoint gamaPoint) {
        ((PhysicsRigidBody)this.body).applyCentralForce(this.toVector(gamaPoint));
    }

    @Override
    public void setMass(Double d) {
        ((PhysicsRigidBody)this.body).setMass(d.floatValue());
    }

    @Override
    public void transferLocationAndRotationToAgent() {
        float f;
        float f2;
        float f3;
        double d;
        Vector3f vector3f = ((PhysicsRigidBody)this.body).getPhysicsLocation(null);
        this.agent.setLocation(new GamaPoint((double)vector3f.x, (double)vector3f.y, (double)(vector3f.z - ((Vector3f)this.aabbTranslation).z)));
        ((PhysicsRigidBody)this.body).getPhysicsRotation(this.quatTransfer);
        GamaPair gamaPair = (GamaPair)this.agent.getAttribute("rotation");
        if (gamaPair == null) {
            gamaPair = new GamaPair((Object)0.0, (Object)new GamaPoint(0.0, 0.0, 1.0), (IType)Types.FLOAT, (IType)Types.POINT);
            this.agent.setAttribute("rotation", (Object)gamaPair);
        }
        if ((d = (double)((f3 = this.quatTransfer.getX()) * f3 + (f2 = this.quatTransfer.getY()) * f2 + (f = this.quatTransfer.getZ()) * f)) > 1.0E-6) {
            d = Math.sqrt(d);
            double d2 = 1.0 / d;
            ((GamaPoint)gamaPair.value).setLocation((double)f3 * d2, (double)f2 * d2, (double)f * d2);
            gamaPair.key = Math.toDegrees(2.0 * Math.atan2(d, this.quatTransfer.getW()));
        }
    }

    @Override
    public IShape getAABB() {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        BoundingBox boundingBox = new BoundingBox();
        ((PhysicsRigidBody)this.body).boundingBox(boundingBox);
        boundingBox.getMax(vector3f2);
        boundingBox.getMin(vector3f);
        return GamaGeometryType.buildBox((double)(vector3f2.x - vector3f.x), (double)(vector3f2.y - vector3f.y), (double)(vector3f2.z - vector3f.z), (GamaPoint)new GamaPoint((double)(vector3f.x + (vector3f2.x - vector3f.x) / 2.0f), (double)(vector3f.y + (vector3f2.y - vector3f.y) / 2.0f), (double)(vector3f.z + (vector3f2.z - vector3f.z) / 2.0f + ((Vector3f)this.visualTranslation).z)));
    }

    public Vector3f getTranslation() {
        return (Vector3f)this.aabbTranslation;
    }

    @Override
    public float getMass() {
        return ((PhysicsRigidBody)this.body).getMass();
    }

    @Override
    public float getFriction() {
        return ((PhysicsRigidBody)this.body).getFriction();
    }

    @Override
    public float getRestitution() {
        return ((PhysicsRigidBody)this.body).getRestitution();
    }

    @Override
    public float getLinearDamping() {
        return ((PhysicsRigidBody)this.body).getLinearDamping();
    }

    @Override
    public float getAngularDamping() {
        return ((PhysicsRigidBody)this.body).getAngularDamping();
    }

    @Override
    public GamaPoint getAngularVelocity(GamaPoint gamaPoint) {
        Vector3f vector3f = new Vector3f();
        ((PhysicsRigidBody)this.body).getAngularVelocity(vector3f);
        return this.toGamaPoint(vector3f, gamaPoint);
    }

    @Override
    public GamaPoint getLinearVelocity(GamaPoint gamaPoint) {
        GamaPoint gamaPoint2 = gamaPoint == null ? new GamaPoint() : gamaPoint;
        Vector3f vector3f = new Vector3f();
        ((PhysicsRigidBody)this.body).getLinearVelocity(vector3f);
        gamaPoint2.setLocation((double)vector3f.x, (double)vector3f.y, (double)vector3f.z);
        return gamaPoint2;
    }

    @Override
    public void clearForces() {
        ((PhysicsRigidBody)this.body).clearForces();
    }

    public void updateShape(IShapeConverter<CollisionShape, Vector3f> iShapeConverter) {
        CollisionShape collisionShape = iShapeConverter.convertAndTranslate(this.agent, (Vector3f)this.aabbTranslation, (Vector3f)this.visualTranslation);
        ((PhysicsRigidBody)this.body).setCollisionShape(collisionShape);
    }

    @Override
    public float getContactDamping() {
        return ((PhysicsRigidBody)this.body).getContactDamping();
    }
}

