/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.native_version;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PersistentManifolds;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Vector3f;
import gama.core.common.interfaces.GeneralSynchronizer;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.dev.DEBUG;
import gama.extension.physics.common.AbstractPhysicalWorld;
import gama.extension.physics.common.IBody;
import gama.extension.physics.common.IShapeConverter;
import gama.extension.physics.gaml.PhysicalSimulationAgent;
import gama.extension.physics.native_version.INativeBulletPhysicalEntity;
import gama.extension.physics.native_version.NativeBulletBodyWrapper;
import gama.extension.physics.native_version.NativeBulletShapeConverter;

public class NativeBulletPhysicalWorld
extends AbstractPhysicalWorld<PhysicsSpace, CollisionShape, Vector3f>
implements INativeBulletPhysicalEntity,
Runnable {
    volatile Double timeStep = 1.0;
    volatile int maxSubSteps;
    volatile boolean doInit = true;
    volatile boolean doUpdate = true;
    volatile boolean continueStep = false;
    Thread thread = new Thread(this);
    volatile GeneralSynchronizer semaphore = GeneralSynchronizer.withInitialAndMaxPermits((int)1, (int)1);

    static {
        DEBUG.OFF();
    }

    @Override
    public void run() {
        if (this.doInit) {
            this.world = new GamaPhysicsSpace(PhysicsSpace.BroadphaseType.DBVT);
            ((PhysicsSpace)this.world).setForceUpdateAllAabbs(false);
            ((PhysicsSpace)this.world).useDeterministicDispatch(true);
            this.setGravity(this.simulation.getGravity(this.simulation.getScope()));
            this.setCCD(this.simulation.getCCD(this.simulation.getScope()));
            this.doInit = false;
        }
        while (this.doUpdate) {
            this.semaphore.acquire();
            PhysicsSpace physicsSpace = (PhysicsSpace)this.getWorld();
            if (physicsSpace != null) {
                physicsSpace.update(this.timeStep.floatValue(), this.maxSubSteps, false, false, true);
            }
            this.continueStep = true;
        }
    }

    public NativeBulletPhysicalWorld(PhysicalSimulationAgent physicalSimulationAgent) {
        super(physicalSimulationAgent);
        this.semaphore.acquire();
    }

    @Override
    public void updateEngine(Double d, int n) {
        this.timeStep = d;
        this.maxSubSteps = n;
        this.continueStep = false;
        this.semaphore.release();
        while (!this.continueStep) {
            Thread.yield();
        }
    }

    @Override
    protected IShapeConverter<CollisionShape, Vector3f> createShapeConverter() {
        return new NativeBulletShapeConverter();
    }

    @Override
    public PhysicsSpace createWorld() {
        if (this.world != null) {
            return (PhysicsSpace)this.world;
        }
        if (this.thread.getState() == Thread.State.NEW) {
            this.thread.start();
        }
        while (this.doInit) {
            Thread.yield();
        }
        return (PhysicsSpace)this.world;
    }

    @Override
    public void registerAgent(IAgent iAgent) {
        PhysicsSpace physicsSpace = (PhysicsSpace)this.getWorld();
        if (physicsSpace != null) {
            NativeBulletBodyWrapper nativeBulletBodyWrapper = new NativeBulletBodyWrapper(iAgent, this);
            physicsSpace.addCollisionObject((PhysicsCollisionObject)nativeBulletBodyWrapper.getBody());
            nativeBulletBodyWrapper.setCCD(this.simulation.getCCD(this.simulation.getScope()));
        }
    }

    @Override
    public void unregisterAgent(IAgent iAgent) {
        Object object = iAgent.getAttribute("%%rigid_body%%");
        PhysicsSpace physicsSpace = (PhysicsSpace)this.getWorld();
        if (physicsSpace != null && object instanceof NativeBulletBodyWrapper) {
            NativeBulletBodyWrapper nativeBulletBodyWrapper = (NativeBulletBodyWrapper)object;
            physicsSpace.remove(nativeBulletBodyWrapper.getBody());
        }
    }

    @Override
    public void setCCD(boolean bl) {
        if (this.world != null) {
            ((PhysicsSpace)this.world).getRigidBodyList().forEach(physicsRigidBody -> {
                if (physicsRigidBody.isStatic()) {
                    return;
                }
                Object object = physicsRigidBody.getUserObject();
                if (object instanceof IBody) {
                    ((IBody)object).setCCD(bl);
                }
            });
        }
    }

    @Override
    public void setGravity(GamaPoint gamaPoint) {
        PhysicsSpace physicsSpace = (PhysicsSpace)this.getWorld();
        if (physicsSpace != null) {
            physicsSpace.setGravity(this.toVector(gamaPoint));
        }
    }

    @Override
    public void dispose() {
        if (this.world == null) {
            return;
        }
        this.doUpdate = false;
        this.semaphore.release();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.world = null;
        System.gc();
    }

    @Override
    public void updatePositionsAndRotations() {
        PhysicsSpace physicsSpace = (PhysicsSpace)this.getWorld();
        if (physicsSpace == null) {
            return;
        }
        for (PhysicsRigidBody physicsRigidBody : physicsSpace.getRigidBodyList()) {
            NativeBulletBodyWrapper nativeBulletBodyWrapper = (NativeBulletBodyWrapper)physicsRigidBody.getUserObject();
            if (!physicsRigidBody.isActive() || physicsRigidBody.isStatic()) continue;
            nativeBulletBodyWrapper.transferLocationAndRotationToAgent();
        }
    }

    @Override
    protected void updateAgentsShape() {
        for (IAgent iAgent : this.updatableAgents) {
            NativeBulletBodyWrapper nativeBulletBodyWrapper = (NativeBulletBodyWrapper)iAgent.getAttribute("%%rigid_body%%");
            if (nativeBulletBodyWrapper == null) {
                return;
            }
            nativeBulletBodyWrapper.updateShape(this.getShapeConverter());
        }
        this.updatableAgents.clear();
    }

    class GamaPhysicsSpace
    extends PhysicsSpace {
        public GamaPhysicsSpace(PhysicsSpace.BroadphaseType broadphaseType) {
            super(broadphaseType);
        }

        public void onContactStarted(long l) {
            int n = PersistentManifolds.countPoints((long)l);
            if (n == 0) {
                return;
            }
            long l2 = PersistentManifolds.getBodyAId((long)l);
            PhysicsCollisionObject physicsCollisionObject = PhysicsCollisionObject.findInstance((long)l2);
            long l3 = PersistentManifolds.getBodyBId((long)l);
            PhysicsCollisionObject physicsCollisionObject2 = PhysicsCollisionObject.findInstance((long)l3);
            int n2 = 0;
            while (n2 < n) {
                long l4 = PersistentManifolds.getPointId((long)l, (int)n2);
                NativeBulletPhysicalWorld.this.contactListener.onContactProcessed(physicsCollisionObject, physicsCollisionObject2, l4);
                ++n2;
            }
        }
    }
}

