/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.broadphase;

import java.util.Arrays;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.PairCallback;
import org.jbox2d.callbacks.TreeCallback;
import org.jbox2d.callbacks.TreeRayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.broadphase.BroadPhase;
import org.jbox2d.collision.broadphase.BroadPhaseStrategy;
import org.jbox2d.common.Vec2;

public class DefaultBroadPhaseBuffer
implements TreeCallback,
BroadPhase {
    private final BroadPhaseStrategy m_tree;
    private int m_proxyCount = 0;
    private int[] m_moveBuffer;
    private int m_moveCapacity;
    private int m_moveCount;
    private long[] m_pairBuffer = new long[this.m_pairCapacity];
    private int m_pairCapacity = 16;
    private int m_pairCount = 0;
    private int m_queryProxyId;

    public DefaultBroadPhaseBuffer(BroadPhaseStrategy broadPhaseStrategy) {
        int n = 0;
        while (n < this.m_pairCapacity) {
            this.m_pairBuffer[n] = 0L;
            ++n;
        }
        this.m_moveCapacity = 16;
        this.m_moveCount = 0;
        this.m_moveBuffer = new int[this.m_moveCapacity];
        this.m_tree = broadPhaseStrategy;
        this.m_queryProxyId = -1;
    }

    @Override
    public final int createProxy(AABB aABB, Object object) {
        int n = this.m_tree.createProxy(aABB, object);
        ++this.m_proxyCount;
        this.bufferMove(n);
        return n;
    }

    @Override
    public final void destroyProxy(int n) {
        this.unbufferMove(n);
        --this.m_proxyCount;
        this.m_tree.destroyProxy(n);
    }

    @Override
    public final void moveProxy(int n, AABB aABB, Vec2 vec2) {
        boolean bl = this.m_tree.moveProxy(n, aABB, vec2);
        if (bl) {
            this.bufferMove(n);
        }
    }

    @Override
    public void touchProxy(int n) {
        this.bufferMove(n);
    }

    @Override
    public Object getUserData(int n) {
        return this.m_tree.getUserData(n);
    }

    @Override
    public AABB getFatAABB(int n) {
        return this.m_tree.getFatAABB(n);
    }

    @Override
    public boolean testOverlap(int n, int n2) {
        AABB aABB = this.m_tree.getFatAABB(n);
        AABB aABB2 = this.m_tree.getFatAABB(n2);
        if (aABB2.lowerBound.x - aABB.upperBound.x > 0.0f || aABB2.lowerBound.y - aABB.upperBound.y > 0.0f) {
            return false;
        }
        return !(aABB.lowerBound.x - aABB2.upperBound.x > 0.0f) && !(aABB.lowerBound.y - aABB2.upperBound.y > 0.0f);
    }

    @Override
    public final int getProxyCount() {
        return this.m_proxyCount;
    }

    @Override
    public void drawTree(DebugDraw debugDraw) {
        this.m_tree.drawTree(debugDraw);
    }

    @Override
    public final void updatePairs(PairCallback pairCallback) {
        this.m_pairCount = 0;
        int n = 0;
        while (n < this.m_moveCount) {
            this.m_queryProxyId = this.m_moveBuffer[n];
            if (this.m_queryProxyId != -1) {
                AABB aABB = this.m_tree.getFatAABB(this.m_queryProxyId);
                this.m_tree.query(this, aABB);
            }
            ++n;
        }
        this.m_moveCount = 0;
        Arrays.sort(this.m_pairBuffer, 0, this.m_pairCount);
        n = 0;
        block1: while (n < this.m_pairCount) {
            long l = this.m_pairBuffer[n];
            Object object = this.m_tree.getUserData((int)(l >> 32));
            Object object2 = this.m_tree.getUserData((int)l);
            pairCallback.addPair(object, object2);
            ++n;
            while (n < this.m_pairCount) {
                long l2 = this.m_pairBuffer[n];
                if (l2 != l) continue block1;
                ++n;
            }
        }
    }

    @Override
    public final void query(TreeCallback treeCallback, AABB aABB) {
        this.m_tree.query(treeCallback, aABB);
    }

    @Override
    public final void raycast(TreeRayCastCallback treeRayCastCallback, RayCastInput rayCastInput) {
        this.m_tree.raycast(treeRayCastCallback, rayCastInput);
    }

    @Override
    public final int getTreeHeight() {
        return this.m_tree.getHeight();
    }

    @Override
    public int getTreeBalance() {
        return this.m_tree.getMaxBalance();
    }

    @Override
    public float getTreeQuality() {
        return this.m_tree.getAreaRatio();
    }

    protected final void bufferMove(int n) {
        if (this.m_moveCount == this.m_moveCapacity) {
            int[] nArray = this.m_moveBuffer;
            this.m_moveCapacity *= 2;
            this.m_moveBuffer = new int[this.m_moveCapacity];
            System.arraycopy(nArray, 0, this.m_moveBuffer, 0, nArray.length);
        }
        this.m_moveBuffer[this.m_moveCount] = n;
        ++this.m_moveCount;
    }

    protected final void unbufferMove(int n) {
        int n2 = 0;
        while (n2 < this.m_moveCount) {
            if (this.m_moveBuffer[n2] == n) {
                this.m_moveBuffer[n2] = -1;
            }
            ++n2;
        }
    }

    @Override
    public final boolean treeCallback(int n) {
        if (n == this.m_queryProxyId) {
            return true;
        }
        if (this.m_pairCount == this.m_pairCapacity) {
            long[] lArray = this.m_pairBuffer;
            this.m_pairCapacity *= 2;
            this.m_pairBuffer = new long[this.m_pairCapacity];
            System.arraycopy(lArray, 0, this.m_pairBuffer, 0, lArray.length);
            int n2 = lArray.length;
            while (n2 < this.m_pairCapacity) {
                this.m_pairBuffer[n2] = 0L;
                ++n2;
            }
        }
        this.m_pairBuffer[this.m_pairCount] = n < this.m_queryProxyId ? (long)n << 32 | (long)this.m_queryProxyId : (long)this.m_queryProxyId << 32 | (long)n;
        ++this.m_pairCount;
        return true;
    }
}

