/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import java.util.Objects;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;

public class Mat33
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final Mat33 IDENTITY = new Mat33(new Vec3(1.0f, 0.0f, 0.0f), new Vec3(0.0f, 1.0f, 0.0f), new Vec3(0.0f, 0.0f, 1.0f));
    public final Vec3 ex;
    public final Vec3 ey;
    public final Vec3 ez;

    public Mat33() {
        this.ex = new Vec3();
        this.ey = new Vec3();
        this.ez = new Vec3();
    }

    public Mat33(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.ex = new Vec3(f, f2, f3);
        this.ey = new Vec3(f4, f5, f6);
        this.ez = new Vec3(f7, f8, f9);
    }

    public Mat33(Vec3 vec3, Vec3 vec32, Vec3 vec33) {
        this.ex = vec3.clone();
        this.ey = vec32.clone();
        this.ez = vec33.clone();
    }

    public void setZero() {
        this.ex.setZero();
        this.ey.setZero();
        this.ez.setZero();
    }

    public void set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.ex.x = f;
        this.ex.y = f2;
        this.ex.z = f3;
        this.ey.x = f4;
        this.ey.y = f5;
        this.ey.z = f6;
        this.ez.x = f4;
        this.ez.y = f5;
        this.ez.z = f6;
    }

    public void set(Mat33 mat33) {
        Vec3 vec3 = mat33.ex;
        this.ex.x = vec3.x;
        this.ex.y = vec3.y;
        this.ex.z = vec3.z;
        Vec3 vec32 = mat33.ey;
        this.ey.x = vec32.x;
        this.ey.y = vec32.y;
        this.ey.z = vec32.z;
        Vec3 vec33 = mat33.ez;
        this.ez.x = vec33.x;
        this.ez.y = vec33.y;
        this.ez.z = vec33.z;
    }

    public void setIdentity() {
        this.ex.x = 1.0f;
        this.ex.y = 0.0f;
        this.ex.z = 0.0f;
        this.ey.x = 0.0f;
        this.ey.y = 1.0f;
        this.ey.z = 0.0f;
        this.ez.x = 0.0f;
        this.ez.y = 0.0f;
        this.ez.z = 1.0f;
    }

    public static final Vec3 mul(Mat33 mat33, Vec3 vec3) {
        return new Vec3(vec3.x * mat33.ex.x + vec3.y * mat33.ey.x + vec3.z + mat33.ez.x, vec3.x * mat33.ex.y + vec3.y * mat33.ey.y + vec3.z * mat33.ez.y, vec3.x * mat33.ex.z + vec3.y * mat33.ey.z + vec3.z * mat33.ez.z);
    }

    public static final Vec2 mul22(Mat33 mat33, Vec2 vec2) {
        return new Vec2(mat33.ex.x * vec2.x + mat33.ey.x * vec2.y, mat33.ex.y * vec2.x + mat33.ey.y * vec2.y);
    }

    public static final void mul22ToOut(Mat33 mat33, Vec2 vec2, Vec2 vec22) {
        float f = mat33.ex.x * vec2.x + mat33.ey.x * vec2.y;
        vec22.y = mat33.ex.y * vec2.x + mat33.ey.y * vec2.y;
        vec22.x = f;
    }

    public static final void mul22ToOutUnsafe(Mat33 mat33, Vec2 vec2, Vec2 vec22) {
        assert (vec2 != vec22);
        vec22.y = mat33.ex.y * vec2.x + mat33.ey.y * vec2.y;
        vec22.x = mat33.ex.x * vec2.x + mat33.ey.x * vec2.y;
    }

    public static final void mulToOut(Mat33 mat33, Vec3 vec3, Vec3 vec32) {
        float f = vec3.x * mat33.ex.y + vec3.y * mat33.ey.y + vec3.z * mat33.ez.y;
        float f2 = vec3.x * mat33.ex.z + vec3.y * mat33.ey.z + vec3.z * mat33.ez.z;
        vec32.x = vec3.x * mat33.ex.x + vec3.y * mat33.ey.x + vec3.z * mat33.ez.x;
        vec32.y = f;
        vec32.z = f2;
    }

    public static final void mulToOutUnsafe(Mat33 mat33, Vec3 vec3, Vec3 vec32) {
        assert (vec32 != vec3);
        vec32.x = vec3.x * mat33.ex.x + vec3.y * mat33.ey.x + vec3.z * mat33.ez.x;
        vec32.y = vec3.x * mat33.ex.y + vec3.y * mat33.ey.y + vec3.z * mat33.ez.y;
        vec32.z = vec3.x * mat33.ex.z + vec3.y * mat33.ey.z + vec3.z * mat33.ez.z;
    }

    public final Vec2 solve22(Vec2 vec2) {
        Vec2 vec22 = new Vec2();
        this.solve22ToOut(vec2, vec22);
        return vec22;
    }

    public final void solve22ToOut(Vec2 vec2, Vec2 vec22) {
        float f = this.ex.x;
        float f2 = this.ey.y;
        float f3 = this.ey.x;
        float f4 = this.ex.y;
        float f5 = f * f2 - f3 * f4;
        if (f5 != 0.0f) {
            f5 = 1.0f / f5;
        }
        vec22.x = f5 * (f2 * vec2.x - f3 * vec2.y);
        vec22.y = f5 * (f * vec2.y - f4 * vec2.x);
    }

    public final Vec3 solve33(Vec3 vec3) {
        Vec3 vec32 = new Vec3();
        this.solve33ToOut(vec3, vec32);
        return vec32;
    }

    public final void solve33ToOut(Vec3 vec3, Vec3 vec32) {
        assert (vec3 != vec32);
        Vec3.crossToOutUnsafe(this.ey, this.ez, vec32);
        float f = Vec3.dot(this.ex, vec32);
        if (f != 0.0f) {
            f = 1.0f / f;
        }
        Vec3.crossToOutUnsafe(this.ey, this.ez, vec32);
        float f2 = f * Vec3.dot(vec3, vec32);
        Vec3.crossToOutUnsafe(vec3, this.ez, vec32);
        float f3 = f * Vec3.dot(this.ex, vec32);
        Vec3.crossToOutUnsafe(this.ey, vec3, vec32);
        float f4 = f * Vec3.dot(this.ex, vec32);
        vec32.x = f2;
        vec32.y = f3;
        vec32.z = f4;
    }

    public void getInverse22(Mat33 mat33) {
        float f = this.ex.x;
        float f2 = this.ey.y;
        float f3 = this.ey.x;
        float f4 = this.ex.y;
        float f5 = f * f2 - f3 * f4;
        if (f5 != 0.0f) {
            f5 = 1.0f / f5;
        }
        mat33.ex.x = f5 * f2;
        mat33.ey.x = -f5 * f3;
        mat33.ex.z = 0.0f;
        mat33.ex.y = -f5 * f4;
        mat33.ey.y = f5 * f;
        mat33.ey.z = 0.0f;
        mat33.ez.x = 0.0f;
        mat33.ez.y = 0.0f;
        mat33.ez.z = 0.0f;
    }

    public void getSymInverse33(Mat33 mat33) {
        float f = this.ey.y * this.ez.z - this.ey.z * this.ez.y;
        float f2 = this.ey.z * this.ez.x - this.ey.x * this.ez.z;
        float f3 = this.ey.x * this.ez.y - this.ey.y * this.ez.x;
        float f4 = this.ex.x * f + this.ex.y * f2 + this.ex.z * f3;
        if (f4 != 0.0f) {
            f4 = 1.0f / f4;
        }
        float f5 = this.ex.x;
        float f6 = this.ey.x;
        float f7 = this.ez.x;
        float f8 = this.ey.y;
        float f9 = this.ez.y;
        float f10 = this.ez.z;
        mat33.ex.x = f4 * (f8 * f10 - f9 * f9);
        mat33.ex.y = f4 * (f7 * f9 - f6 * f10);
        mat33.ex.z = f4 * (f6 * f9 - f7 * f8);
        mat33.ey.x = mat33.ex.y;
        mat33.ey.y = f4 * (f5 * f10 - f7 * f7);
        mat33.ey.z = f4 * (f7 * f6 - f5 * f9);
        mat33.ez.x = mat33.ex.z;
        mat33.ez.y = mat33.ey.z;
        mat33.ez.z = f4 * (f5 * f8 - f6 * f6);
    }

    public static final void setScaleTransform(float f, Mat33 mat33) {
        mat33.ex.x = f;
        mat33.ey.y = f;
    }

    public int hashCode() {
        return Objects.hash(this.ex, this.ey, this.ez);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Mat33 mat33 = (Mat33)object;
        if (!Objects.equals(this.ex, mat33.ex)) {
            return false;
        }
        if (!Objects.equals(this.ey, mat33.ey)) {
            return false;
        }
        return Objects.equals(this.ez, mat33.ez);
    }
}

