/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import org.jbox2d.common.MathUtils;

public class Vec2
implements Serializable {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;

    public Vec2() {
        this(0.0f, 0.0f);
    }

    public Vec2(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public Vec2(Vec2 vec2) {
        this(vec2.x, vec2.y);
    }

    public final void setZero() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public final Vec2 set(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public final Vec2 set(Vec2 vec2) {
        this.x = vec2.x;
        this.y = vec2.y;
        return this;
    }

    public final Vec2 add(Vec2 vec2) {
        return new Vec2(this.x + vec2.x, this.y + vec2.y);
    }

    public final Vec2 sub(Vec2 vec2) {
        return new Vec2(this.x - vec2.x, this.y - vec2.y);
    }

    public final Vec2 mul(float f) {
        return new Vec2(this.x * f, this.y * f);
    }

    public final Vec2 negate() {
        return new Vec2(-this.x, -this.y);
    }

    public final Vec2 negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public final Vec2 addLocal(Vec2 vec2) {
        this.x += vec2.x;
        this.y += vec2.y;
        return this;
    }

    public final Vec2 addLocal(float f, float f2) {
        this.x += f;
        this.y += f2;
        return this;
    }

    public final Vec2 subLocal(Vec2 vec2) {
        this.x -= vec2.x;
        this.y -= vec2.y;
        return this;
    }

    public final Vec2 mulLocal(float f) {
        this.x *= f;
        this.y *= f;
        return this;
    }

    public final Vec2 skew() {
        return new Vec2(-this.y, this.x);
    }

    public final void skew(Vec2 vec2) {
        vec2.x = -this.y;
        vec2.y = this.x;
    }

    public final float length() {
        return MathUtils.sqrt(this.x * this.x + this.y * this.y);
    }

    public final float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public final float normalize() {
        float f = this.length();
        if (f < 1.1920929E-7f) {
            return 0.0f;
        }
        float f2 = 1.0f / f;
        this.x *= f2;
        this.y *= f2;
        return f;
    }

    public final boolean isValid() {
        return !Float.isNaN(this.x) && !Float.isInfinite(this.x) && !Float.isNaN(this.y) && !Float.isInfinite(this.y);
    }

    public final Vec2 abs() {
        return new Vec2(MathUtils.abs(this.x), MathUtils.abs(this.y));
    }

    public final void absLocal() {
        this.x = MathUtils.abs(this.x);
        this.y = MathUtils.abs(this.y);
    }

    public final Vec2 clone() {
        return new Vec2(this.x, this.y);
    }

    public final String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public static final Vec2 abs(Vec2 vec2) {
        return new Vec2(MathUtils.abs(vec2.x), MathUtils.abs(vec2.y));
    }

    public static final void absToOut(Vec2 vec2, Vec2 vec22) {
        vec22.x = MathUtils.abs(vec2.x);
        vec22.y = MathUtils.abs(vec2.y);
    }

    public static final float dot(Vec2 vec2, Vec2 vec22) {
        return vec2.x * vec22.x + vec2.y * vec22.y;
    }

    public static final float cross(Vec2 vec2, Vec2 vec22) {
        return vec2.x * vec22.y - vec2.y * vec22.x;
    }

    public static final Vec2 cross(Vec2 vec2, float f) {
        return new Vec2(f * vec2.y, -f * vec2.x);
    }

    public static final void crossToOut(Vec2 vec2, float f, Vec2 vec22) {
        float f2 = -f * vec2.x;
        vec22.x = f * vec2.y;
        vec22.y = f2;
    }

    public static final void crossToOutUnsafe(Vec2 vec2, float f, Vec2 vec22) {
        assert (vec22 != vec2);
        vec22.x = f * vec2.y;
        vec22.y = -f * vec2.x;
    }

    public static final Vec2 cross(float f, Vec2 vec2) {
        return new Vec2(-f * vec2.y, f * vec2.x);
    }

    public static final void crossToOut(float f, Vec2 vec2, Vec2 vec22) {
        float f2 = f * vec2.x;
        vec22.x = -f * vec2.y;
        vec22.y = f2;
    }

    public static final void crossToOutUnsafe(float f, Vec2 vec2, Vec2 vec22) {
        assert (vec22 != vec2);
        vec22.x = -f * vec2.y;
        vec22.y = f * vec2.x;
    }

    public static final void negateToOut(Vec2 vec2, Vec2 vec22) {
        vec22.x = -vec2.x;
        vec22.y = -vec2.y;
    }

    public static final Vec2 min(Vec2 vec2, Vec2 vec22) {
        return new Vec2(vec2.x < vec22.x ? vec2.x : vec22.x, vec2.y < vec22.y ? vec2.y : vec22.y);
    }

    public static final Vec2 max(Vec2 vec2, Vec2 vec22) {
        return new Vec2(vec2.x > vec22.x ? vec2.x : vec22.x, vec2.y > vec22.y ? vec2.y : vec22.y);
    }

    public static final void minToOut(Vec2 vec2, Vec2 vec22, Vec2 vec23) {
        vec23.x = vec2.x < vec22.x ? vec2.x : vec22.x;
        vec23.y = vec2.y < vec22.y ? vec2.y : vec22.y;
    }

    public static final void maxToOut(Vec2 vec2, Vec2 vec22, Vec2 vec23) {
        vec23.x = vec2.x > vec22.x ? vec2.x : vec22.x;
        vec23.y = vec2.y > vec22.y ? vec2.y : vec22.y;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.x);
        n = 31 * n + Float.floatToIntBits(this.y);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vec2 vec2 = (Vec2)object;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(vec2.x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(vec2.y);
    }
}

