/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.pooling.IWorldPool;

public class PulleyJoint
extends Joint {
    public static final float MIN_PULLEY_LENGTH = 2.0f;
    private final Vec2 m_groundAnchorA = new Vec2();
    private final Vec2 m_groundAnchorB = new Vec2();
    private float m_lengthA;
    private float m_lengthB;
    private final Vec2 m_localAnchorA = new Vec2();
    private final Vec2 m_localAnchorB = new Vec2();
    private float m_constant;
    private float m_ratio;
    private float m_impulse;
    private int m_indexA;
    private int m_indexB;
    private final Vec2 m_uA = new Vec2();
    private final Vec2 m_uB = new Vec2();
    private final Vec2 m_rA = new Vec2();
    private final Vec2 m_rB = new Vec2();
    private final Vec2 m_localCenterA = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private float m_invMassA;
    private float m_invMassB;
    private float m_invIA;
    private float m_invIB;
    private float m_mass;

    protected PulleyJoint(IWorldPool iWorldPool, PulleyJointDef pulleyJointDef) {
        super(iWorldPool, pulleyJointDef);
        this.m_groundAnchorA.set(pulleyJointDef.groundAnchorA);
        this.m_groundAnchorB.set(pulleyJointDef.groundAnchorB);
        this.m_localAnchorA.set(pulleyJointDef.localAnchorA);
        this.m_localAnchorB.set(pulleyJointDef.localAnchorB);
        assert (pulleyJointDef.ratio != 0.0f);
        this.m_ratio = pulleyJointDef.ratio;
        this.m_lengthA = pulleyJointDef.lengthA;
        this.m_lengthB = pulleyJointDef.lengthB;
        this.m_constant = pulleyJointDef.lengthA + this.m_ratio * pulleyJointDef.lengthB;
        this.m_impulse = 0.0f;
    }

    public float getLengthA() {
        return this.m_lengthA;
    }

    public float getLengthB() {
        return this.m_lengthB;
    }

    public float getCurrentLengthA() {
        Vec2 vec2 = this.pool.popVec2();
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
        vec2.subLocal(this.m_groundAnchorA);
        float f = vec2.length();
        this.pool.pushVec2(1);
        return f;
    }

    public float getCurrentLengthB() {
        Vec2 vec2 = this.pool.popVec2();
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
        vec2.subLocal(this.m_groundAnchorB);
        float f = vec2.length();
        this.pool.pushVec2(1);
        return f;
    }

    public Vec2 getLocalAnchorA() {
        return this.m_localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.m_localAnchorB;
    }

    @Override
    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
    }

    @Override
    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
    }

    @Override
    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_uB).mulLocal(this.m_impulse).mulLocal(f);
    }

    @Override
    public float getReactionTorque(float f) {
        return 0.0f;
    }

    public Vec2 getGroundAnchorA() {
        return this.m_groundAnchorA;
    }

    public Vec2 getGroundAnchorB() {
        return this.m_groundAnchorB;
    }

    public float getLength1() {
        Vec2 vec2 = this.pool.popVec2();
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
        vec2.subLocal(this.m_groundAnchorA);
        float f = vec2.length();
        this.pool.pushVec2(1);
        return f;
    }

    public float getLength2() {
        Vec2 vec2 = this.pool.popVec2();
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
        vec2.subLocal(this.m_groundAnchorB);
        float f = vec2.length();
        this.pool.pushVec2(1);
        return f;
    }

    public float getRatio() {
        return this.m_ratio;
    }

    @Override
    public void initVelocityConstraints(SolverData solverData) {
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassA = this.m_bodyA.m_invMass;
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIA = this.m_bodyA.m_invI;
        this.m_invIB = this.m_bodyB.m_invI;
        Vec2 vec2 = solverData.positions[this.m_indexA].c;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec22 = solverData.velocities[this.m_indexA].v;
        float f2 = solverData.velocities[this.m_indexA].w;
        Vec2 vec23 = solverData.positions[this.m_indexB].c;
        float f3 = solverData.positions[this.m_indexB].a;
        Vec2 vec24 = solverData.velocities[this.m_indexB].v;
        float f4 = solverData.velocities[this.m_indexB].w;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec25 = this.pool.popVec2();
        rot.set(f);
        rot2.set(f3);
        Rot.mulToOutUnsafe(rot, vec25.set(this.m_localAnchorA).subLocal(this.m_localCenterA), this.m_rA);
        Rot.mulToOutUnsafe(rot2, vec25.set(this.m_localAnchorB).subLocal(this.m_localCenterB), this.m_rB);
        this.m_uA.set(vec2).addLocal(this.m_rA).subLocal(this.m_groundAnchorA);
        this.m_uB.set(vec23).addLocal(this.m_rB).subLocal(this.m_groundAnchorB);
        float f5 = this.m_uA.length();
        float f6 = this.m_uB.length();
        if (f5 > 10.0f * Settings.linearSlop) {
            this.m_uA.mulLocal(1.0f / f5);
        } else {
            this.m_uA.setZero();
        }
        if (f6 > 10.0f * Settings.linearSlop) {
            this.m_uB.mulLocal(1.0f / f6);
        } else {
            this.m_uB.setZero();
        }
        float f7 = Vec2.cross(this.m_rA, this.m_uA);
        float f8 = Vec2.cross(this.m_rB, this.m_uB);
        float f9 = this.m_invMassA + this.m_invIA * f7 * f7;
        float f10 = this.m_invMassB + this.m_invIB * f8 * f8;
        this.m_mass = f9 + this.m_ratio * this.m_ratio * f10;
        if (this.m_mass > 0.0f) {
            this.m_mass = 1.0f / this.m_mass;
        }
        if (solverData.step.warmStarting) {
            this.m_impulse *= solverData.step.dtRatio;
            Vec2 vec26 = this.pool.popVec2();
            Vec2 vec27 = this.pool.popVec2();
            vec26.set(this.m_uA).mulLocal(-this.m_impulse);
            vec27.set(this.m_uB).mulLocal(-this.m_ratio * this.m_impulse);
            vec22.x += this.m_invMassA * vec26.x;
            vec22.y += this.m_invMassA * vec26.y;
            f2 += this.m_invIA * Vec2.cross(this.m_rA, vec26);
            vec24.x += this.m_invMassB * vec27.x;
            vec24.y += this.m_invMassB * vec27.y;
            f4 += this.m_invIB * Vec2.cross(this.m_rB, vec27);
            this.pool.pushVec2(2);
        } else {
            this.m_impulse = 0.0f;
        }
        solverData.velocities[this.m_indexA].w = f2;
        solverData.velocities[this.m_indexB].w = f4;
        this.pool.pushVec2(1);
        this.pool.pushRot(2);
    }

    @Override
    public void solveVelocityConstraints(SolverData solverData) {
        Vec2 vec2 = solverData.velocities[this.m_indexA].v;
        float f = solverData.velocities[this.m_indexA].w;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f2 = solverData.velocities[this.m_indexB].w;
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        Vec2 vec26 = this.pool.popVec2();
        Vec2.crossToOutUnsafe(f, this.m_rA, vec23);
        vec23.addLocal(vec2);
        Vec2.crossToOutUnsafe(f2, this.m_rB, vec24);
        vec24.addLocal(vec22);
        float f3 = -Vec2.dot(this.m_uA, vec23) - this.m_ratio * Vec2.dot(this.m_uB, vec24);
        float f4 = -this.m_mass * f3;
        this.m_impulse += f4;
        vec25.set(this.m_uA).mulLocal(-f4);
        vec26.set(this.m_uB).mulLocal(-this.m_ratio * f4);
        vec2.x += this.m_invMassA * vec25.x;
        vec2.y += this.m_invMassA * vec25.y;
        vec22.x += this.m_invMassB * vec26.x;
        vec22.y += this.m_invMassB * vec26.y;
        solverData.velocities[this.m_indexA].w = f += this.m_invIA * Vec2.cross(this.m_rA, vec25);
        solverData.velocities[this.m_indexB].w = f2 += this.m_invIB * Vec2.cross(this.m_rB, vec26);
        this.pool.pushVec2(4);
    }

    @Override
    public boolean solvePositionConstraints(SolverData solverData) {
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        Vec2 vec26 = this.pool.popVec2();
        Vec2 vec27 = this.pool.popVec2();
        Vec2 vec28 = solverData.positions[this.m_indexA].c;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec29 = solverData.positions[this.m_indexB].c;
        float f2 = solverData.positions[this.m_indexB].a;
        rot.set(f);
        rot2.set(f2);
        Rot.mulToOutUnsafe(rot, vec25.set(this.m_localAnchorA).subLocal(this.m_localCenterA), vec2);
        Rot.mulToOutUnsafe(rot2, vec25.set(this.m_localAnchorB).subLocal(this.m_localCenterB), vec22);
        vec23.set(vec28).addLocal(vec2).subLocal(this.m_groundAnchorA);
        vec24.set(vec29).addLocal(vec22).subLocal(this.m_groundAnchorB);
        float f3 = vec23.length();
        float f4 = vec24.length();
        if (f3 > 10.0f * Settings.linearSlop) {
            vec23.mulLocal(1.0f / f3);
        } else {
            vec23.setZero();
        }
        if (f4 > 10.0f * Settings.linearSlop) {
            vec24.mulLocal(1.0f / f4);
        } else {
            vec24.setZero();
        }
        float f5 = Vec2.cross(vec2, vec23);
        float f6 = Vec2.cross(vec22, vec24);
        float f7 = this.m_invMassA + this.m_invIA * f5 * f5;
        float f8 = this.m_invMassB + this.m_invIB * f6 * f6;
        float f9 = f7 + this.m_ratio * this.m_ratio * f8;
        if (f9 > 0.0f) {
            f9 = 1.0f / f9;
        }
        float f10 = this.m_constant - f3 - this.m_ratio * f4;
        float f11 = MathUtils.abs(f10);
        float f12 = -f9 * f10;
        vec26.set(vec23).mulLocal(-f12);
        vec27.set(vec24).mulLocal(-this.m_ratio * f12);
        vec28.x += this.m_invMassA * vec26.x;
        vec28.y += this.m_invMassA * vec26.y;
        vec29.x += this.m_invMassB * vec27.x;
        vec29.y += this.m_invMassB * vec27.y;
        solverData.positions[this.m_indexA].a = f += this.m_invIA * Vec2.cross(vec2, vec26);
        solverData.positions[this.m_indexB].a = f2 += this.m_invIB * Vec2.cross(vec22, vec27);
        this.pool.pushRot(2);
        this.pool.pushVec2(7);
        return f11 < Settings.linearSlop;
    }
}

