/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.RopeJointDef;
import org.jbox2d.pooling.IWorldPool;

public class RopeJoint
extends Joint {
    private final Vec2 m_localAnchorA = new Vec2();
    private final Vec2 m_localAnchorB = new Vec2();
    private float m_maxLength;
    private float m_length;
    private float m_impulse;
    private int m_indexA;
    private int m_indexB;
    private final Vec2 m_u = new Vec2();
    private final Vec2 m_rA = new Vec2();
    private final Vec2 m_rB = new Vec2();
    private final Vec2 m_localCenterA = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private float m_invMassA;
    private float m_invMassB;
    private float m_invIA;
    private float m_invIB;
    private float m_mass;
    private LimitState m_state;

    protected RopeJoint(IWorldPool iWorldPool, RopeJointDef ropeJointDef) {
        super(iWorldPool, ropeJointDef);
        this.m_localAnchorA.set(ropeJointDef.localAnchorA);
        this.m_localAnchorB.set(ropeJointDef.localAnchorB);
        this.m_maxLength = ropeJointDef.maxLength;
        this.m_mass = 0.0f;
        this.m_impulse = 0.0f;
        this.m_state = LimitState.INACTIVE;
        this.m_length = 0.0f;
    }

    @Override
    public void initVelocityConstraints(SolverData solverData) {
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassA = this.m_bodyA.m_invMass;
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIA = this.m_bodyA.m_invI;
        this.m_invIB = this.m_bodyB.m_invI;
        Vec2 vec2 = solverData.positions[this.m_indexA].c;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec22 = solverData.velocities[this.m_indexA].v;
        float f2 = solverData.velocities[this.m_indexA].w;
        Vec2 vec23 = solverData.positions[this.m_indexB].c;
        float f3 = solverData.positions[this.m_indexB].a;
        Vec2 vec24 = solverData.velocities[this.m_indexB].v;
        float f4 = solverData.velocities[this.m_indexB].w;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec25 = this.pool.popVec2();
        rot.set(f);
        rot2.set(f3);
        Rot.mulToOutUnsafe(rot, vec25.set(this.m_localAnchorA).subLocal(this.m_localCenterA), this.m_rA);
        Rot.mulToOutUnsafe(rot2, vec25.set(this.m_localAnchorB).subLocal(this.m_localCenterB), this.m_rB);
        this.m_u.set(vec23).addLocal(this.m_rB).subLocal(vec2).subLocal(this.m_rA);
        this.m_length = this.m_u.length();
        float f5 = this.m_length - this.m_maxLength;
        this.m_state = f5 > 0.0f ? LimitState.AT_UPPER : LimitState.INACTIVE;
        if (!(this.m_length > Settings.linearSlop)) {
            this.m_u.setZero();
            this.m_mass = 0.0f;
            this.m_impulse = 0.0f;
            this.pool.pushRot(2);
            this.pool.pushVec2(1);
            return;
        }
        this.m_u.mulLocal(1.0f / this.m_length);
        float f6 = Vec2.cross(this.m_rA, this.m_u);
        float f7 = Vec2.cross(this.m_rB, this.m_u);
        float f8 = this.m_invMassA + this.m_invIA * f6 * f6 + this.m_invMassB + this.m_invIB * f7 * f7;
        float f9 = this.m_mass = f8 != 0.0f ? 1.0f / f8 : 0.0f;
        if (solverData.step.warmStarting) {
            this.m_impulse *= solverData.step.dtRatio;
            float f10 = this.m_impulse * this.m_u.x;
            float f11 = this.m_impulse * this.m_u.y;
            vec22.x -= this.m_invMassA * f10;
            vec22.y -= this.m_invMassA * f11;
            f2 -= this.m_invIA * (this.m_rA.x * f11 - this.m_rA.y * f10);
            vec24.x += this.m_invMassB * f10;
            vec24.y += this.m_invMassB * f11;
            f4 += this.m_invIB * (this.m_rB.x * f11 - this.m_rB.y * f10);
        } else {
            this.m_impulse = 0.0f;
        }
        this.pool.pushRot(2);
        this.pool.pushVec2(1);
        solverData.velocities[this.m_indexA].w = f2;
        solverData.velocities[this.m_indexB].w = f4;
    }

    @Override
    public void solveVelocityConstraints(SolverData solverData) {
        Vec2 vec2 = solverData.velocities[this.m_indexA].v;
        float f = solverData.velocities[this.m_indexA].w;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f2 = solverData.velocities[this.m_indexB].w;
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        Vec2.crossToOutUnsafe(f, this.m_rA, vec23);
        vec23.addLocal(vec2);
        Vec2.crossToOutUnsafe(f2, this.m_rB, vec24);
        vec24.addLocal(vec22);
        float f3 = this.m_length - this.m_maxLength;
        float f4 = Vec2.dot(this.m_u, vec25.set(vec24).subLocal(vec23));
        if (f3 < 0.0f) {
            f4 += solverData.step.inv_dt * f3;
        }
        float f5 = -this.m_mass * f4;
        float f6 = this.m_impulse;
        this.m_impulse = MathUtils.min(0.0f, this.m_impulse + f5);
        f5 = this.m_impulse - f6;
        float f7 = f5 * this.m_u.x;
        float f8 = f5 * this.m_u.y;
        vec2.x -= this.m_invMassA * f7;
        vec2.y -= this.m_invMassA * f8;
        vec22.x += this.m_invMassB * f7;
        vec22.y += this.m_invMassB * f8;
        this.pool.pushVec2(3);
        solverData.velocities[this.m_indexA].w = f -= this.m_invIA * (this.m_rA.x * f8 - this.m_rA.y * f7);
        solverData.velocities[this.m_indexB].w = f2 += this.m_invIB * (this.m_rB.x * f8 - this.m_rB.y * f7);
    }

    @Override
    public boolean solvePositionConstraints(SolverData solverData) {
        Vec2 vec2 = solverData.positions[this.m_indexA].c;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec22 = solverData.positions[this.m_indexB].c;
        float f2 = solverData.positions[this.m_indexB].a;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        Vec2 vec26 = this.pool.popVec2();
        rot.set(f);
        rot2.set(f2);
        Rot.mulToOutUnsafe(rot, vec26.set(this.m_localAnchorA).subLocal(this.m_localCenterA), vec24);
        Rot.mulToOutUnsafe(rot2, vec26.set(this.m_localAnchorB).subLocal(this.m_localCenterB), vec25);
        vec23.set(vec22).addLocal(vec25).subLocal(vec2).subLocal(vec24);
        float f3 = vec23.normalize();
        float f4 = f3 - this.m_maxLength;
        f4 = MathUtils.clamp(f4, 0.0f, Settings.maxLinearCorrection);
        float f5 = -this.m_mass * f4;
        float f6 = f5 * vec23.x;
        float f7 = f5 * vec23.y;
        vec2.x -= this.m_invMassA * f6;
        vec2.y -= this.m_invMassA * f7;
        vec22.x += this.m_invMassB * f6;
        vec22.y += this.m_invMassB * f7;
        this.pool.pushRot(2);
        this.pool.pushVec2(4);
        solverData.positions[this.m_indexA].a = f -= this.m_invIA * (vec24.x * f7 - vec24.y * f6);
        solverData.positions[this.m_indexB].a = f2 += this.m_invIB * (vec25.x * f7 - vec25.y * f6);
        return f3 - this.m_maxLength < Settings.linearSlop;
    }

    @Override
    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
    }

    @Override
    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
    }

    @Override
    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_u).mulLocal(f).mulLocal(this.m_impulse);
    }

    @Override
    public float getReactionTorque(float f) {
        return 0.0f;
    }

    public Vec2 getLocalAnchorA() {
        return this.m_localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.m_localAnchorB;
    }

    public float getMaxLength() {
        return this.m_maxLength;
    }

    public void setMaxLength(float f) {
        this.m_maxLength = f;
    }

    public LimitState getLimitState() {
        return this.m_state;
    }
}

