/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.particle;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.particle.StackQueue;
import org.jbox2d.pooling.normal.MutableStack;

public class VoronoiDiagram {
    private Generator[] m_generatorBuffer;
    private int m_generatorCount;
    private int m_countX;
    private int m_countY;
    private Generator[] m_diagram;
    private final Vec2 lower = new Vec2();
    private final Vec2 upper = new Vec2();
    private MutableStack<VoronoiDiagramTask> taskPool = new MutableStack<VoronoiDiagramTask>(50){

        @Override
        protected VoronoiDiagramTask newInstance() {
            return new VoronoiDiagramTask();
        }

        protected VoronoiDiagramTask[] newArray(int n) {
            return new VoronoiDiagramTask[n];
        }
    };
    private final StackQueue<VoronoiDiagramTask> queue = new StackQueue();

    public VoronoiDiagram(int n) {
        this.m_generatorBuffer = new Generator[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_generatorBuffer[n2] = new Generator();
            ++n2;
        }
        this.m_generatorCount = 0;
        this.m_countX = 0;
        this.m_countY = 0;
        this.m_diagram = null;
    }

    public void getNodes(VoronoiDiagramCallback voronoiDiagramCallback) {
        int n = 0;
        while (n < this.m_countY - 1) {
            int n2 = 0;
            while (n2 < this.m_countX - 1) {
                int n3 = n2 + n * this.m_countX;
                Generator generator = this.m_diagram[n3];
                Generator generator2 = this.m_diagram[n3 + 1];
                Generator generator3 = this.m_diagram[n3 + this.m_countX];
                Generator generator4 = this.m_diagram[n3 + 1 + this.m_countX];
                if (generator2 != generator3) {
                    if (generator != generator2 && generator != generator3) {
                        voronoiDiagramCallback.callback(generator.tag, generator2.tag, generator3.tag);
                    }
                    if (generator4 != generator2 && generator4 != generator3) {
                        voronoiDiagramCallback.callback(generator2.tag, generator4.tag, generator3.tag);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public void addGenerator(Vec2 vec2, int n) {
        Generator generator = this.m_generatorBuffer[this.m_generatorCount++];
        generator.center.x = vec2.x;
        generator.center.y = vec2.y;
        generator.tag = n;
    }

    public void generate(float f) {
        int n;
        int n2;
        Generator generator;
        assert (this.m_diagram == null);
        float f2 = 1.0f / f;
        this.lower.x = Float.MAX_VALUE;
        this.lower.y = Float.MAX_VALUE;
        this.upper.x = -3.4028235E38f;
        this.upper.y = -3.4028235E38f;
        int n3 = 0;
        while (n3 < this.m_generatorCount) {
            generator = this.m_generatorBuffer[n3];
            Vec2.minToOut(this.lower, generator.center, this.lower);
            Vec2.maxToOut(this.upper, generator.center, this.upper);
            ++n3;
        }
        this.m_countX = 1 + (int)(f2 * (this.upper.x - this.lower.x));
        this.m_countY = 1 + (int)(f2 * (this.upper.y - this.lower.y));
        this.m_diagram = new Generator[this.m_countX * this.m_countY];
        this.queue.reset((VoronoiDiagramTask[])new VoronoiDiagramTask[4 * this.m_countX * this.m_countX]);
        n3 = 0;
        while (n3 < this.m_generatorCount) {
            generator = this.m_generatorBuffer[n3];
            generator.center.x = f2 * (generator.center.x - this.lower.x);
            generator.center.y = f2 * (generator.center.y - this.lower.y);
            n2 = MathUtils.max(0, MathUtils.min((int)generator.center.x, this.m_countX - 1));
            n = MathUtils.max(0, MathUtils.min((int)generator.center.y, this.m_countY - 1));
            this.queue.push(this.taskPool.pop().set(n2, n, n2 + n * this.m_countX, generator));
            ++n3;
        }
        while (!this.queue.empty()) {
            VoronoiDiagramTask voronoiDiagramTask = this.queue.pop();
            int n4 = voronoiDiagramTask.m_x;
            n2 = voronoiDiagramTask.m_y;
            n = voronoiDiagramTask.m_i;
            Generator generator2 = voronoiDiagramTask.m_generator;
            if (this.m_diagram[n] == null) {
                this.m_diagram[n] = generator2;
                if (n4 > 0) {
                    this.queue.push(this.taskPool.pop().set(n4 - 1, n2, n - 1, generator2));
                }
                if (n2 > 0) {
                    this.queue.push(this.taskPool.pop().set(n4, n2 - 1, n - this.m_countX, generator2));
                }
                if (n4 < this.m_countX - 1) {
                    this.queue.push(this.taskPool.pop().set(n4 + 1, n2, n + 1, generator2));
                }
                if (n2 < this.m_countY - 1) {
                    this.queue.push(this.taskPool.pop().set(n4, n2 + 1, n + this.m_countX, generator2));
                }
            }
            this.taskPool.push(voronoiDiagramTask);
        }
        int n5 = this.m_countX + this.m_countY;
        int n6 = 0;
        while (n6 < n5) {
            Generator generator3;
            Generator generator4;
            n2 = 0;
            while (n2 < this.m_countY) {
                int n7 = 0;
                while (n7 < this.m_countX - 1) {
                    int n8 = n7 + n2 * this.m_countX;
                    generator4 = this.m_diagram[n8];
                    generator3 = this.m_diagram[n8 + 1];
                    if (generator4 != generator3) {
                        this.queue.push(this.taskPool.pop().set(n7, n2, n8, generator3));
                        this.queue.push(this.taskPool.pop().set(n7 + 1, n2, n8 + 1, generator4));
                    }
                    ++n7;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.m_countY - 1) {
                int n9 = 0;
                while (n9 < this.m_countX) {
                    int n10 = n9 + n2 * this.m_countX;
                    generator4 = this.m_diagram[n10];
                    generator3 = this.m_diagram[n10 + this.m_countX];
                    if (generator4 != generator3) {
                        this.queue.push(this.taskPool.pop().set(n9, n2, n10, generator3));
                        this.queue.push(this.taskPool.pop().set(n9, n2 + 1, n10 + this.m_countX, generator4));
                    }
                    ++n9;
                }
                ++n2;
            }
            n2 = 0;
            while (!this.queue.empty()) {
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8;
                VoronoiDiagramTask voronoiDiagramTask = this.queue.pop();
                int n11 = voronoiDiagramTask.m_x;
                int n12 = voronoiDiagramTask.m_y;
                int n13 = voronoiDiagramTask.m_i;
                Generator generator5 = this.m_diagram[n13];
                Generator generator6 = voronoiDiagramTask.m_generator;
                Generator generator7 = generator6;
                if (generator5 != generator7 && (f8 = (f7 = generator5.center.x - (float)n11) * f7 + (f6 = generator5.center.y - (float)n12) * f6) > (f5 = (f4 = generator7.center.x - (float)n11) * f4 + (f3 = generator7.center.y - (float)n12) * f3)) {
                    this.m_diagram[n13] = generator7;
                    if (n11 > 0) {
                        this.queue.push(this.taskPool.pop().set(n11 - 1, n12, n13 - 1, generator7));
                    }
                    if (n12 > 0) {
                        this.queue.push(this.taskPool.pop().set(n11, n12 - 1, n13 - this.m_countX, generator7));
                    }
                    if (n11 < this.m_countX - 1) {
                        this.queue.push(this.taskPool.pop().set(n11 + 1, n12, n13 + 1, generator7));
                    }
                    if (n12 < this.m_countY - 1) {
                        this.queue.push(this.taskPool.pop().set(n11, n12 + 1, n13 + this.m_countX, generator7));
                    }
                    n2 = 1;
                }
                this.taskPool.push(voronoiDiagramTask);
            }
            if (n2 == 0) break;
            ++n6;
        }
    }

    public static class Generator {
        final Vec2 center = new Vec2();
        int tag;
    }

    public static interface VoronoiDiagramCallback {
        public void callback(int var1, int var2, int var3);
    }

    public static class VoronoiDiagramTask {
        int m_x;
        int m_y;
        int m_i;
        Generator m_generator;

        public VoronoiDiagramTask() {
        }

        public VoronoiDiagramTask(int n, int n2, int n3, Generator generator) {
            this.m_x = n;
            this.m_y = n2;
            this.m_i = n3;
            this.m_generator = generator;
        }

        public VoronoiDiagramTask set(int n, int n2, int n3, Generator generator) {
            this.m_x = n;
            this.m_y = n2;
            this.m_i = n3;
            this.m_generator = generator;
            return this;
        }
    }
}

