/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.pooling.normal;

import org.jbox2d.pooling.IOrderedStack;

public abstract class CircleStack<E>
implements IOrderedStack<E> {
    private final Object[] pool;
    private int index;
    private final int size;
    private final Object[] container;

    public CircleStack(int n, int n2) {
        this.size = n;
        this.pool = new Object[n];
        int n3 = 0;
        while (n3 < n) {
            this.pool[n3] = this.newInstance();
            ++n3;
        }
        this.index = 0;
        this.container = new Object[n2];
    }

    @Override
    public final E pop() {
        ++this.index;
        if (this.index >= this.size) {
            this.index = 0;
        }
        return (E)this.pool[this.index];
    }

    @Override
    public final E[] pop(int n) {
        assert (n <= this.container.length) : "Container array is too small";
        if (this.index + n < this.size) {
            System.arraycopy(this.pool, this.index, this.container, 0, n);
            this.index += n;
        } else {
            int n2 = this.index + n - this.size;
            System.arraycopy(this.pool, this.index, this.container, 0, n - n2);
            System.arraycopy(this.pool, 0, this.container, n - n2, n2);
            this.index = n2;
        }
        return this.container;
    }

    @Override
    public void push(int n) {
    }

    protected abstract E newInstance();
}

